/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.encrypt.interceptor;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.config.properties.EncryptorProperties;
import cn.smarthse.framework.encrypt.core.EncryptContext;
import cn.smarthse.framework.encrypt.core.EncryptorManager;
import cn.smarthse.framework.encrypt.enumd.AlgorithmType;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.encrypt.enumd.EncodeType;
import com.baomidou.mybatisplus.core.MybatisParameterHandler;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=ParameterHandler.class, method="setParameters", args={PreparedStatement.class})})
public class MybatisEncryptInterceptor
implements Interceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MybatisEncryptInterceptor.class);
    private final EncryptorManager encryptorManager;
    private final EncryptorProperties encryptorProperties;
    private static final Field BOUND_SQL_FIELD;
    private static Field META_PARAMETERS_FIELD;
    private static Field ORIGINAL_OBJECT_FIELD;
    private static final Map<Class<?>, List<Field>> FIELD_CACHE;

    public MybatisEncryptInterceptor(EncryptorManager encryptorManager, EncryptorProperties encryptorProperties) {
        this.encryptorManager = encryptorManager;
        this.encryptorProperties = encryptorProperties;
    }

    public Object intercept(Invocation invocation) {
        return invocation;
    }

    public Object plugin(Object target) {
        ParameterHandler parameterHandler;
        Object parameterObject;
        if (target instanceof ParameterHandler && ObjectUtil.isNotNull((Object)(parameterObject = (parameterHandler = (ParameterHandler)target).getParameterObject())) && !(parameterObject instanceof String)) {
            HashMap<Object, Object> copyParameterObject = null;
            if (parameterObject instanceof Map && parameterHandler instanceof MybatisParameterHandler) {
                copyParameterObject = new HashMap<Object, Object>((Map)parameterObject);
                MybatisParameterHandler mybatisParameterHandler = (MybatisParameterHandler)target;
                parameterObject = this.getMybatisParameterHandlerOriginalParameter(mybatisParameterHandler);
            }
            this.encryptHandler(parameterObject);
            if (ObjectUtil.isNotNull(copyParameterObject) && !Objects.equals(copyParameterObject, parameterObject)) {
                Map<String, Object> afterMap = this.getFieldAndValueMap(parameterObject);
                HashMap<String, Object> beforeMap = new HashMap<String, Object>(copyParameterObject.size() + afterMap.size());
                copyParameterObject.forEach((key, value) -> beforeMap.put(key.toString(), value));
                beforeMap.putAll(afterMap);
                try {
                    Field parameterObjectField = DefaultParameterHandler.class.getDeclaredField("parameterObject");
                    parameterObjectField.setAccessible(true);
                    parameterObjectField.set(target, beforeMap);
                }
                catch (Exception e) {
                    log.error("\u8986\u76d6MyBatis-Plus\u53c2\u6570\u5bf9\u8c61\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return target;
    }

    private Map<String, Object> getFieldAndValueMap(Object obj) {
        if (obj == null) {
            return Collections.emptyMap();
        }
        Class<?> clazz = obj.getClass();
        List fields = FIELD_CACHE.computeIfAbsent(clazz, c -> {
            ArrayList<Field> fieldList = new ArrayList<Field>();
            while (c != null && c != Object.class && !c.getName().startsWith("java.") && !c.getName().startsWith("javax.")) {
                for (Field field : c.getDeclaredFields()) {
                    if (field.getDeclaringClass().getName().startsWith("java.") || field.getDeclaringClass().getName().startsWith("javax.")) continue;
                    field.setAccessible(true);
                    fieldList.add(field);
                }
                c = c.getSuperclass();
            }
            return fieldList;
        });
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        for (Field field : fields) {
            try {
                fieldMap.put(field.getName(), field.get(obj));
            }
            catch (IllegalAccessException e) {
                log.error("\u83b7\u53d6MyBatis-Plus\u53c2\u6570\u5bf9\u8c61\u5b57\u6bb5\u503c\u5931\u8d25", (Throwable)e);
            }
        }
        return fieldMap;
    }

    private Object getMybatisParameterHandlerOriginalParameter(MybatisParameterHandler parameterHandler) {
        try {
            Object originalObject;
            Object boundSql = BOUND_SQL_FIELD.get(parameterHandler);
            if (ObjectUtil.isNull((Object)META_PARAMETERS_FIELD)) {
                Field metaParametersField = boundSql.getClass().getDeclaredField("metaParameters");
                metaParametersField.setAccessible(true);
                META_PARAMETERS_FIELD = metaParametersField;
            }
            Object metaParameters = META_PARAMETERS_FIELD.get(boundSql);
            if (ObjectUtil.isNull((Object)ORIGINAL_OBJECT_FIELD)) {
                Field originalObjectField = metaParameters.getClass().getDeclaredField("originalObject");
                originalObjectField.setAccessible(true);
                ORIGINAL_OBJECT_FIELD = originalObjectField;
            }
            if ((originalObject = ORIGINAL_OBJECT_FIELD.get(metaParameters)) instanceof Map) {
                Map map = (Map)originalObject;
                Object obj = map.get("_parameter");
                return ObjectUtil.isNull(obj) ? parameterHandler.getParameterObject() : obj;
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6MyBatis-Plus\u539f\u59cb\u53c2\u6570\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    private void encryptHandler(Object sourceObject) {
        if (ObjectUtil.isNull((Object)sourceObject)) {
            return;
        }
        if (sourceObject instanceof Map) {
            Map map = (Map)sourceObject;
            new HashSet(map.values()).forEach(this::encryptHandler);
            return;
        }
        if (sourceObject instanceof List) {
            List list = (List)sourceObject;
            if (CollUtil.isEmpty((Collection)list)) {
                return;
            }
            Object firstItem = list.get(0);
            if (ObjectUtil.isNull(firstItem) || CollUtil.isEmpty(this.encryptorManager.getFieldCache(firstItem.getClass()))) {
                return;
            }
            list.forEach(this::encryptHandler);
            return;
        }
        Set<Field> fields = this.encryptorManager.getFieldCache(sourceObject.getClass());
        if (ObjectUtil.isNull(fields)) {
            return;
        }
        for (Field field : fields) {
            try {
                field.set(sourceObject, this.encryptField(Convert.toStr((Object)field.get(sourceObject)), field));
            }
            catch (Exception e) {
                log.error("\u5904\u7406\u52a0\u5bc6\u5b57\u6bb5\u65f6\u51fa\u9519", (Throwable)e);
                throw new RuntimeException("\u5904\u7406\u52a0\u5bc6\u5b57\u6bb5\u65f6\u51fa\u9519", e);
            }
        }
    }

    private String encryptField(String value, Field field) {
        byte[] data;
        if (ObjectUtil.isNull((Object)value)) {
            return null;
        }
        if (StrUtil.startWith((CharSequence)(value = StrUtil.trim((CharSequence)value)), (CharSequence)"VI*D#S")) {
            log.warn("\u6570\u636e\u5df2\u52a0\u5bc6\uff0c\u8bf7\u52ff\u91cd\u590d\u52a0\u5bc6\uff01\uff01\uff01\u5b57\u6bb5[{}]", (Object)field.getName());
            return value;
        }
        if (this.encryptorProperties.getAlgorithm() == AlgorithmType.WCSP_LIGHT_DATA_SERVICE && (data = value.getBytes(StandardCharsets.UTF_8)).length > 1023) {
            throw new IllegalArgumentException("Input data is too long");
        }
        EncryptContext encryptContext = new EncryptContext();
        encryptContext.setAlgorithm(this.encryptorProperties.getAlgorithm());
        encryptContext.setEncode(EncodeType.BASE64);
        EncryptField encryptField = field.getAnnotation(EncryptField.class);
        encryptContext.setDataProcessingMethodsType(ObjectUtil.isNotNull((Object)encryptField) && ObjectUtil.isNotNull((Object)((Object)encryptField.dataProcessingMethodsType())) ? encryptField.dataProcessingMethodsType() : DataProcessingMethodsType.VAGUE);
        if (encryptContext.getAlgorithm() == AlgorithmType.WCSP_LIGHT_DATA_SERVICE) {
            encryptContext.setWcspApiKey(this.encryptorProperties.getWcspApiKey());
            encryptContext.setWcspSecretKey(this.encryptorProperties.getWcspSecretKey());
            encryptContext.setWcspVersion(this.encryptorProperties.getWcspVersion());
            encryptContext.setWcspLocalHostEncryptUrl(this.encryptorProperties.getWcspLocalHostEncryptUrl());
            encryptContext.setWcspLocalHostDecryptUrl(this.encryptorProperties.getWcspLocalHostDecryptUrl());
        } else {
            EncryptorProperties.GroupConfig maxVersionGroupConfig = this.encryptorProperties.getMaxVersionGroupConfig();
            encryptContext.setVersion(maxVersionGroupConfig.getVersion());
            encryptContext.setPassword(maxVersionGroupConfig.getPassword());
            encryptContext.setPublicKey(maxVersionGroupConfig.getPublicKey());
            encryptContext.setPrivateKey(maxVersionGroupConfig.getPrivateKey());
        }
        return this.encryptorManager.encrypt(value, encryptContext);
    }

    public void setProperties(Properties properties) {
    }

    static {
        FIELD_CACHE = new ConcurrentHashMap();
        try {
            BOUND_SQL_FIELD = MybatisParameterHandler.class.getSuperclass().getDeclaredField("boundSql");
            BOUND_SQL_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

