/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.encrypt.core;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.core.utils.StringUtils;
import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.core.EncryptContext;
import cn.smarthse.framework.encrypt.core.IEncryptor;
import cn.smarthse.framework.encrypt.enumd.AlgorithmType;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.ibatis.io.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.util.ClassUtils;

public class EncryptorManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EncryptorManager.class);
    Map<Integer, IEncryptor> encryptorMap = new ConcurrentHashMap<Integer, IEncryptor>();
    Map<Class<?>, Set<Field>> fieldCache = new ConcurrentHashMap();
    private static final int encryptorLength = 24;

    public EncryptorManager(String typeAliasesPackage) {
        this.scanEncryptClasses(typeAliasesPackage);
    }

    public Set<Field> getFieldCache(Class<?> sourceClazz) {
        return EncryptorManager.notNullGetter(this.fieldCache, f -> (Set)f.get(sourceClazz));
    }

    public IEncryptor registerAndGetEncryptor(EncryptContext encryptContext) {
        int key = encryptContext.hashCode();
        if (this.encryptorMap.containsKey(key)) {
            return this.encryptorMap.get(key);
        }
        IEncryptor encryptor = (IEncryptor)ReflectUtil.newInstance(encryptContext.getAlgorithm().getClazz(), (Object[])new Object[]{encryptContext});
        this.encryptorMap.put(key, encryptor);
        return encryptor;
    }

    public void removeEncryptor(EncryptContext encryptContext) {
        this.encryptorMap.remove(encryptContext.hashCode());
    }

    public String encrypt(String value, EncryptContext encryptContext) {
        IEncryptor encryptor = this.registerAndGetEncryptor(encryptContext);
        if ((encryptContext.getAlgorithm() == AlgorithmType.SM4 || encryptContext.getAlgorithm() == AlgorithmType.WCSP_LIGHT_DATA_SERVICE) && encryptContext.getDataProcessingMethodsType() == DataProcessingMethodsType.ACCURATE) {
            String version = encryptContext.getAlgorithm() == AlgorithmType.SM4 ? encryptContext.getVersion() : encryptContext.getWcspVersion();
            return version + encryptor.encrypt(value, encryptContext.getEncode());
        }
        return encryptor.encrypt(value, encryptContext.getEncode());
    }

    public String decrypt(String value, EncryptContext encryptContext) {
        IEncryptor encryptor = this.registerAndGetEncryptor(encryptContext);
        if (encryptContext.getAlgorithm() == AlgorithmType.SM4 || encryptContext.getAlgorithm() == AlgorithmType.WCSP_LIGHT_DATA_SERVICE) {
            value = StrUtil.subSuf((CharSequence)value, (int)14);
            if (encryptContext.getDataProcessingMethodsType() == DataProcessingMethodsType.ACCURATE) {
                return encryptor.decrypt(value, encryptContext.getEncode());
            }
        }
        return encryptor.decrypt(value, encryptContext.getEncode());
    }

    public void scanEncryptClasses(String typeAliasesPackage) {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        CachingMetadataReaderFactory factory = new CachingMetadataReaderFactory();
        String[] packagePatternArray = StringUtils.splitPreserveAllTokens((String)typeAliasesPackage, (String)",; \t\n");
        String classpath = "classpath*:";
        try {
            for (String packagePattern : packagePatternArray) {
                Resource[] resources;
                String path = ClassUtils.convertClassNameToResourcePath((String)packagePattern);
                for (Resource resource : resources = resolver.getResources(classpath + path + "/*.class")) {
                    ClassMetadata classMetadata = factory.getMetadataReader(resource).getClassMetadata();
                    Class clazz = Resources.classForName((String)classMetadata.getClassName());
                    Set<Field> encryptFieldSet = this.getEncryptFieldSetFromClazz(clazz);
                    if (!CollUtil.isNotEmpty(encryptFieldSet)) continue;
                    this.fieldCache.put(clazz, encryptFieldSet);
                }
            }
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316\u6570\u636e\u5b89\u5168\u7f13\u5b58\u65f6\u51fa\u9519:{}", (Object)e.getMessage());
        }
    }

    private Set<Field> getEncryptFieldSetFromClazz(Class<?> clazz) {
        Set<Field> fieldSet = new HashSet<Field>();
        if (clazz.isInterface() || clazz.isMemberClass() || clazz.isAnonymousClass()) {
            return fieldSet;
        }
        while (clazz != null) {
            Field[] fields = clazz.getDeclaredFields();
            fieldSet.addAll(Arrays.asList(fields));
            clazz = clazz.getSuperclass();
        }
        fieldSet = fieldSet.stream().filter(field -> field.isAnnotationPresent(EncryptField.class) && field.getType() == String.class).collect(Collectors.toSet());
        for (Field field2 : fieldSet) {
            field2.setAccessible(true);
        }
        return fieldSet;
    }

    private static <T, E> E notNullGetter(T obj, Function<T, E> func) {
        if (ObjectUtil.isNotNull(obj) && ObjectUtil.isNotNull(func)) {
            return func.apply(obj);
        }
        return null;
    }

    @Generated
    public EncryptorManager() {
    }
}

