/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.dubbo.handler;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.core.utils.ServletUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import lombok.Generated;
import org.apache.dubbo.rpc.RpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@Order(value=0x7FFFFFFE)
@RestControllerAdvice
public class DubboExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DubboExceptionHandler.class);

    @ExceptionHandler(value={RpcException.class})
    public ResponseData<Object> dealException(RpcException e, HttpServletRequest request) {
        if (!Objects.nonNull(request)) {
            log.error("[Dubbo] [RPC\u5f02\u5e38] [failure] [error] [non-web] exceptionClass={} message={}", new Object[]{e.getClass().getSimpleName(), e.getMessage(), e});
            return null;
        }
        log.error("[Dubbo] [RPC\u5f02\u5e38] [failure] [error] [web] ip={} userAgent={} requestUri={} exceptionClass={} message={}", new Object[]{ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]), ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage(), e});
        ResponseData r = new ResponseData();
        r.setState(ResponseStateEnum.INTERNAL_SERVER_ERROR.getValue());
        r.setMessage("RPC\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u786e\u8ba4");
        return r;
    }
}

