/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.dubbo.metadata;

import cn.hutool.core.map.MapUtil;
import cn.smarthse.framework.core.utils.StringUtils;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstanceCustomizer;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class MonitorPortMetadataCustomizer
implements ServiceInstanceCustomizer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MonitorPortMetadataCustomizer.class);
    private static final String MANAGEMENT_SERVER_PORT = "management.server.port";
    private static final String MANAGEMENT_SERVER_BASEPATH = "management.server.basePath";
    private static final String CONFIG_FILE_PATH = System.getProperty("monitor.config.path", "application-actuator.yml");
    private static final String CONFIG_KEY_MANAGEMENT_SERVER_PORT = System.getProperty("monitor.config.key1", "management.server.port");
    private static final String CONFIG_KEY_MANAGEMENT_SERVER_BASEPATH = System.getProperty("monitor.config.key2", "management.server.basePath");
    private final Map<String, Object> yamlConfig = Collections.unmodifiableMap(this.loadYamlConfig());

    public void customize(ServiceInstance serviceInstance, ApplicationModel applicationModel) {
        String serviceName = applicationModel.getApplicationName();
        if (MapUtil.isEmpty(this.yamlConfig)) {
            log.warn("[Service={}] Configuration file '{}' not found or empty, skipping metadata injection", (Object)serviceName, (Object)CONFIG_FILE_PATH);
            return;
        }
        this.injectMetadata(serviceInstance, serviceName, MANAGEMENT_SERVER_PORT, CONFIG_KEY_MANAGEMENT_SERVER_PORT);
        this.injectMetadata(serviceInstance, serviceName, MANAGEMENT_SERVER_BASEPATH, CONFIG_KEY_MANAGEMENT_SERVER_BASEPATH);
    }

    private void injectMetadata(ServiceInstance serviceInstance, String serviceName, String metadataKey, String configKey) {
        String value = this.loadConfigValue(configKey);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            serviceInstance.getMetadata().put(metadataKey, value);
            log.info("[Service={}] Injected metadata [key={}] with value [{}]", new Object[]{serviceName, metadataKey, value});
        } else {
            log.debug("[Service={}] Skipping metadata injection for key [{}] as value is blank", (Object)serviceName, (Object)metadataKey);
        }
    }

    private String loadConfigValue(String key) {
        if (MapUtil.isEmpty(this.yamlConfig)) {
            return null;
        }
        String[] keyParts = key.split("\\.");
        String value = this.extractValueFromMap(this.yamlConfig, keyParts);
        if (StringUtils.isBlank((CharSequence)value)) {
            log.warn("Configuration not found for key [{}] in file [{}]", (Object)key, (Object)CONFIG_FILE_PATH);
        }
        return value;
    }

    private String extractValueFromMap(Map<String, Object> map, String[] keys) {
        Object value = map;
        for (String key : keys) {
            if (!(value instanceof Map)) {
                return null;
            }
            if ((value = value.get(key)) != null) continue;
            return null;
        }
        return value.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> loadYamlConfig() {
        try (InputStream input = this.getClass().getClassLoader().getResourceAsStream(CONFIG_FILE_PATH);){
            if (input == null) {
                log.warn("Configuration file not found: {}", (Object)CONFIG_FILE_PATH);
                Map<String, Object> map = Collections.emptyMap();
                return map;
            }
            Map config = (Map)new Yaml().load(input);
            if (config == null) {
                log.warn("Configuration file {} is empty", (Object)CONFIG_FILE_PATH);
                Map<String, Object> map = Collections.emptyMap();
                return map;
            }
            Map<String, Object> map = Collections.unmodifiableMap(config);
            return map;
        }
        catch (Exception e) {
            log.warn("Failed to load configuration file: {}", (Object)CONFIG_FILE_PATH, (Object)e);
            return Collections.emptyMap();
        }
    }
}

