/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.core.utils.ip;

import cn.hutool.http.HtmlUtil;
import cn.smarthse.framework.core.utils.NetUtils;
import cn.smarthse.framework.core.utils.StringUtils;
import cn.smarthse.framework.core.utils.ip.RegionUtils;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AddressUtils.class);
    public static final String UNKNOWN_IP = "XX XX";
    public static final String LOCAL_ADDRESS = "\u5185\u7f51IP";
    public static final String UNKNOWN_ADDRESS = "\u672a\u77e5";

    public static String getRealAddressByIP(String ip) {
        if (NetUtils.isIPv4(ip = HtmlUtil.cleanHtmlTag((String)StringUtils.blankToDefault(ip, "")))) {
            return AddressUtils.resolverIPv4Region(ip);
        }
        if (NetUtils.isIPv6(ip)) {
            return AddressUtils.resolverIPv6Region(ip);
        }
        return UNKNOWN_IP;
    }

    private static String resolverIPv4Region(String ip) {
        if (NetUtils.isInnerIP((String)ip)) {
            return LOCAL_ADDRESS;
        }
        return RegionUtils.getCityInfo(ip);
    }

    private static String resolverIPv6Region(String ip) {
        if (NetUtils.isInnerIPv6(ip)) {
            return LOCAL_ADDRESS;
        }
        log.warn("ip2region\u4e0d\u652f\u6301IPV6\u5730\u5740\u89e3\u6790\uff1a{}", (Object)ip);
        return UNKNOWN_ADDRESS;
    }

    @Generated
    private AddressUtils() {
    }
}

