/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.core.utils.file;

import cn.hutool.core.img.Img;
import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.io.FileTypeUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.smarthse.framework.core.domain.ResponseData;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.Image;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class FileUtils
extends FileUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);
    private static final float scale = 1.0f;
    private static final long min_size = 0x100000L;
    private static final Map<String, Set<String>> FILE_CATEGORY_WHITELIST = new HashMap<String, Set<String>>();
    private static final Map<String, String> EXT_TO_CATEGORY;

    public static void writeFromStream(InputStream inputStream, String realPath, float scale) {
        if (realPath.endsWith("jpg") || realPath.endsWith("jpeg") || realPath.endsWith("bmp") || realPath.endsWith("png") || realPath.endsWith("psd")) {
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(FileUtils.touch((String)realPath));
            }
            catch (FileNotFoundException e) {
                log.error("FileNotFoundException\uff1a", (Throwable)e);
            }
            try {
                ImgUtil.scale((Image)Img.from((InputStream)inputStream).setTargetImageType(FileUtils.extName((String)realPath)).getImg(), (OutputStream)outputStream, (float)scale);
            }
            catch (IORuntimeException e) {
                log.error("IORuntimeException\uff1a", (Throwable)e);
                try {
                    FileUtils.writeFromStream((InputStream)inputStream, (String)realPath);
                }
                catch (IORuntimeException e2) {
                    log.error("IORuntimeException\uff1a", (Throwable)e2);
                }
            }
            IoUtil.close((Closeable)inputStream);
            IoUtil.close((Closeable)outputStream);
        } else {
            try {
                FileUtils.writeFromStream((InputStream)inputStream, (String)realPath);
            }
            catch (IORuntimeException e) {
                log.error("IORuntimeException\uff1a", (Throwable)e);
            }
        }
    }

    public static void writeFromStream(MultipartFile fileData, String realPath) {
        try {
            if (fileData.getSize() <= 0x100000L) {
                FileUtils.writeFromStream((InputStream)fileData.getInputStream(), (String)realPath);
            } else {
                FileUtils.writeFromStream(fileData.getInputStream(), realPath, 1.0f);
            }
        }
        catch (IOException e) {
            log.error("IORuntimeException\uff1a", (Throwable)e);
        }
    }

    public static float scale200K(long srcSize) {
        float scale = srcSize < 200000L ? 1.0f : (srcSize < 500000L ? 0.57f : (srcSize < 700000L ? 0.47f : (srcSize < 1000000L ? 0.37f : (srcSize < 2000000L ? 0.25f : (srcSize < 4000000L ? 0.17f : (srcSize < 5000000L ? 0.13f : (srcSize < 10000000L ? 0.1f : 0.01f)))))));
        return scale;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ResponseData<String> isAllowedFile(MultipartFile file, String allowedTypes) {
        String filename = file.getOriginalFilename();
        if (filename == null) return ResponseData.fail("\u6587\u4ef6\u540d\u65e0\u6cd5\u83b7\u53d6\u6269\u5c55\u540d");
        if (!filename.contains(".")) {
            return ResponseData.fail("\u6587\u4ef6\u540d\u65e0\u6cd5\u83b7\u53d6\u6269\u5c55\u540d");
        }
        String ext = filename.substring(filename.lastIndexOf(".") + 1).toLowerCase();
        if (allowedTypes != null && !allowedTypes.isEmpty()) {
            Set allowedTypeSet = Arrays.stream(allowedTypes.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
            if (!allowedTypeSet.contains(ext)) {
                return ResponseData.fail("\u8be5\u63a5\u53e3\u4ec5\u5141\u8bb8\u4e0a\u4f20\u7c7b\u578b\uff1a" + allowedTypes + "\uff0c\u5b9e\u9645\u6587\u4ef6\u7c7b\u578b\uff1a" + ext);
            }
        } else {
            String category = EXT_TO_CATEGORY.get(ext);
            if (category == null) {
                return ResponseData.fail("\u6587\u4ef6\u6269\u5c55\u540d\u4e0d\u5728\u5141\u8bb8\u8303\u56f4");
            }
        }
        try (InputStream is = file.getInputStream();){
            String fileType = FileTypeUtil.getType((InputStream)is, (boolean)true);
            String category = EXT_TO_CATEGORY.get(ext);
            if ("image".equals(category) || "video".equals(category) || "archive".equals(category)) {
                Set<String> allowed = FILE_CATEGORY_WHITELIST.get(category);
                if (fileType == null || !allowed.contains(fileType)) {
                    ResponseData<String> responseData2 = ResponseData.fail(String.format("\u6587\u4ef6\u5185\u5bb9\u4e0e\u6269\u5c55\u540d\u4e0d\u5339\u914d\uff0c\u6269\u5c55\u540d\uff1a%s\uff0c\u9b54\u6570\u7c7b\u578b\uff1a%s", ext, fileType));
                    return responseData2;
                }
            }
            ResponseData<String> responseData = ResponseData.success("\u6587\u4ef6\u5408\u6cd5");
            return responseData;
        }
        catch (IORuntimeException | IOException e) {
            log.error("\u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38", e);
            return ResponseData.fail("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25: " + e.getMessage());
        }
    }

    public static void setAttachmentResponseHeader(HttpServletResponse response, String realFileName) {
        String percentEncodedFileName = FileUtils.percentEncode(realFileName);
        String contentDispositionValue = "attachment; filename=%s;filename*=utf-8''%s".formatted(percentEncodedFileName, percentEncodedFileName);
        response.addHeader("Access-Control-Expose-Headers", "Content-Disposition,download-filename");
        response.setHeader("Content-disposition", contentDispositionValue);
        response.setHeader("download-filename", percentEncodedFileName);
    }

    public static String percentEncode(String s) {
        String encode = URLEncoder.encode(s, StandardCharsets.UTF_8);
        return encode.replaceAll("\\+", "%20");
    }

    @Generated
    private FileUtils() {
    }

    static {
        FILE_CATEGORY_WHITELIST.put("image", Set.of("jpg", "jpeg", "png", "gif", "bmp", "webp", "tiff", "ico"));
        FILE_CATEGORY_WHITELIST.put("pdf", Set.of("pdf"));
        FILE_CATEGORY_WHITELIST.put("word", Set.of("doc", "docx"));
        FILE_CATEGORY_WHITELIST.put("excel", Set.of("xls", "xlsx"));
        FILE_CATEGORY_WHITELIST.put("ppt", Set.of("ppt", "pptx"));
        FILE_CATEGORY_WHITELIST.put("text", Set.of("txt", "rtf"));
        FILE_CATEGORY_WHITELIST.put("video", Set.of("mp4", "avi", "mov", "mkv", "flv", "wmv", "webm"));
        FILE_CATEGORY_WHITELIST.put("archive", Set.of("zip", "rar", "tar", "7z", "gz", "bz2"));
        EXT_TO_CATEGORY = new ConcurrentHashMap<String, String>();
        FILE_CATEGORY_WHITELIST.forEach((category, types) -> {
            for (String ext : types) {
                EXT_TO_CATEGORY.put(ext, (String)category);
            }
        });
    }
}

