/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.core.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.lang.tree.TreeUtil;
import cn.hutool.core.lang.tree.parser.NodeParser;
import cn.smarthse.framework.core.utils.ReflectUtils;
import cn.smarthse.framework.core.utils.StreamUtils;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class TreeBuildUtils
extends TreeUtil {
    public static final TreeNodeConfig DEFAULT_CONFIG = TreeNodeConfig.DEFAULT_CONFIG.setNameKey("label");

    public static <T, K> List<Tree<K>> build(List<T> list, NodeParser<T, K> nodeParser) {
        if (CollUtil.isEmpty(list)) {
            return CollUtil.newArrayList((Object[])new Tree[0]);
        }
        Object k = ReflectUtils.invokeGetter(list.get(0), "parentId");
        return TreeUtil.build(list, k, (TreeNodeConfig)DEFAULT_CONFIG, nodeParser);
    }

    public static <T, K> List<Tree<K>> build(List<T> list, K parentId, NodeParser<T, K> nodeParser) {
        if (CollUtil.isEmpty(list)) {
            return CollUtil.newArrayList((Object[])new Tree[0]);
        }
        return TreeUtil.build(list, parentId, (TreeNodeConfig)DEFAULT_CONFIG, nodeParser);
    }

    public static <T, K> List<Tree<K>> buildMultiRoot(List<T> list, Function<T, K> getId, Function<T, K> getParentId, NodeParser<T, K> parser) {
        if (CollUtil.isEmpty(list)) {
            return CollUtil.newArrayList((Object[])new Tree[0]);
        }
        Set allIds = StreamUtils.toSet(list, getId);
        Set rootParentIds = list.stream().map(getParentId).filter(Objects::nonNull).filter(pid -> !allIds.contains(pid)).collect(Collectors.toSet());
        return rootParentIds.stream().flatMap(rootParentId -> TreeUtil.build((List)list, (Object)rootParentId, (NodeParser)parser).stream()).collect(Collectors.toList());
    }

    public static <K> List<Tree<K>> getLeafNodes(List<Tree<K>> nodes) {
        if (CollUtil.isEmpty(nodes)) {
            return CollUtil.newArrayList((Object[])new Tree[0]);
        }
        return nodes.stream().flatMap(TreeBuildUtils::extractLeafNodes).collect(Collectors.toList());
    }

    private static <K> Stream<Tree<K>> extractLeafNodes(Tree<K> node) {
        if (!node.hasChild()) {
            return Stream.of(node);
        }
        return node.getChildren().stream().flatMap(TreeBuildUtils::extractLeafNodes);
    }

    @Generated
    private TreeBuildUtils() {
    }
}

