/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.core.utils;

import cn.smarthse.framework.core.utils.StringUtils;
import java.net.MalformedURLException;
import java.net.URL;
import lombok.Generated;

public class SSRFLeakUtil {
    private static String[] urlwhitelist = new String[0];
    private static String[] fileTypeList = new String[]{"doc", "docx", "gif", "jpeg", "jpg", "pdf", "png", "pptx", "txt", "wps", "xls", "xlsx", "zip"};

    public static boolean securitySSRFUrlCheck(String url) {
        try {
            if (StringUtils.isBlank((CharSequence)url)) {
                return false;
            }
            URL u = new URL(url);
            return u.getProtocol().startsWith("http") || u.getProtocol().startsWith("https");
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean securitySSRFFileTypeCheck(String fileExt, String url) throws MalformedURLException {
        if (StringUtils.isEmpty(url)) {
            return false;
        }
        URL u = new URL(url);
        if (!u.getProtocol().startsWith("http") && !u.getProtocol().startsWith("https")) {
            return false;
        }
        String subStr = null;
        if (url.length() < 4) {
            subStr = url;
        } else {
            if (url.contains("?")) {
                url = url.split("\\?")[0];
            }
            subStr = url.substring(url.length() - 4, url.length());
        }
        if (StringUtils.isNotEmpty(fileExt) && !subStr.contains(fileExt)) {
            return false;
        }
        for (int i = 0; i < fileTypeList.length; ++i) {
            if (!subStr.contains(fileTypeList[i])) continue;
            return true;
        }
        return false;
    }

    @Generated
    private SSRFLeakUtil() {
    }
}

