/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.core.utils;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.format.DateParser;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.management.ManagementFactory;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;

public class DateUtils
extends org.apache.commons.lang3.time.DateUtils {
    private static final String[] PARSE_PATTERNS = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM"};

    public static Date getNowDate() {
        return new Date();
    }

    public static Date parseDate(Object str) {
        if (str == null) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)str.toString(), (String[])PARSE_PATTERNS);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getServerStartDate() {
        long time = ManagementFactory.getRuntimeMXBean().getStartTime();
        return new Date(time);
    }

    public static long difference(Date start, Date end, TimeUnit unit) {
        long diffInMillis = Math.abs(end.getTime() - start.getTime());
        return switch (unit) {
            default -> throw new IncompatibleClassChangeError();
            case TimeUnit.DAYS -> diffInMillis / TimeUnit.DAYS.toMillis(1L);
            case TimeUnit.HOURS -> diffInMillis / TimeUnit.HOURS.toMillis(1L);
            case TimeUnit.MINUTES -> diffInMillis / TimeUnit.MINUTES.toMillis(1L);
            case TimeUnit.SECONDS -> diffInMillis / TimeUnit.SECONDS.toMillis(1L);
            case TimeUnit.MILLISECONDS -> diffInMillis;
            case TimeUnit.MICROSECONDS -> TimeUnit.MILLISECONDS.toMicros(diffInMillis);
            case TimeUnit.NANOSECONDS -> TimeUnit.MILLISECONDS.toNanos(diffInMillis);
        };
    }

    public static String getDatePoor(Date endDate, Date nowDate) {
        long diffInMillis = endDate.getTime() - nowDate.getTime();
        long day = TimeUnit.MILLISECONDS.toDays(diffInMillis);
        long hour = TimeUnit.MILLISECONDS.toHours(diffInMillis) % 24L;
        long min = TimeUnit.MILLISECONDS.toMinutes(diffInMillis) % 60L;
        return String.format("%d\u5929 %d\u5c0f\u65f6 %d\u5206\u949f", day, hour, min);
    }

    public static String getTimeDifference(Date endDate, Date nowDate) {
        long diffInMillis = endDate.getTime() - nowDate.getTime();
        long day = TimeUnit.MILLISECONDS.toDays(diffInMillis);
        long hour = TimeUnit.MILLISECONDS.toHours(diffInMillis) % 24L;
        long min = TimeUnit.MILLISECONDS.toMinutes(diffInMillis) % 60L;
        long sec = TimeUnit.MILLISECONDS.toSeconds(diffInMillis) % 60L;
        StringBuilder result = new StringBuilder();
        if (day > 0L) {
            result.append(String.format("%d\u5929 ", day));
        }
        if (hour > 0L) {
            result.append(String.format("%d\u5c0f\u65f6 ", hour));
        }
        if (min > 0L) {
            result.append(String.format("%d\u5206\u949f ", min));
        }
        if (sec > 0L) {
            result.append(String.format("%d\u79d2", sec));
        }
        return result.length() > 0 ? result.toString().trim() : "0\u79d2";
    }

    public static Date toDate(LocalDateTime temporalAccessor) {
        ZonedDateTime zdt = temporalAccessor.atZone(ZoneId.systemDefault());
        return Date.from(zdt.toInstant());
    }

    public static Date toDate(LocalDate temporalAccessor) {
        LocalDateTime localDateTime = LocalDateTime.of(temporalAccessor, LocalTime.of(0, 0, 0));
        ZonedDateTime zdt = localDateTime.atZone(ZoneId.systemDefault());
        return Date.from(zdt.toInstant());
    }

    public static void validateDateRange(Date startDate, Date endDate, int maxValue, TimeUnit unit) {
        if (endDate.before(startDate)) {
            throw new ServiceException("\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5f00\u59cb\u65e5\u671f");
        }
        long diffInMillis = endDate.getTime() - startDate.getTime();
        long diff = switch (unit) {
            case TimeUnit.DAYS -> TimeUnit.MILLISECONDS.toDays(diffInMillis);
            case TimeUnit.HOURS -> TimeUnit.MILLISECONDS.toHours(diffInMillis);
            case TimeUnit.MINUTES -> TimeUnit.MILLISECONDS.toMinutes(diffInMillis);
            default -> throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u65f6\u95f4\u5355\u4f4d");
        };
        if (diff > (long)maxValue) {
            throw new ServiceException("\u6700\u5927\u65f6\u95f4\u8de8\u5ea6\u4e3a " + maxValue + " " + unit.toString().toLowerCase());
        }
    }

    public static DateTime parse(CharSequence dateCharSequence) {
        if (StrUtil.isBlank((CharSequence)dateCharSequence)) {
            return null;
        }
        String dateStr = dateCharSequence.toString();
        dateStr = StrUtil.removeAll((CharSequence)dateStr.trim(), (char[])new char[]{'\u65e5', '\u79d2'});
        int length = dateStr.length();
        if (NumberUtil.isNumber((CharSequence)dateStr)) {
            if (length == "yyyyMMddHHmmss".length()) {
                return DateUtil.parse((CharSequence)dateStr, (DateParser)DatePattern.PURE_DATETIME_FORMAT);
            }
            if (length == "yyyyMMddHHmmssSSS".length()) {
                return DateUtil.parse((CharSequence)dateStr, (DateParser)DatePattern.PURE_DATETIME_MS_FORMAT);
            }
            if (length == "yyyyMMdd".length()) {
                return DateUtil.parse((CharSequence)dateStr, (DateParser)DatePattern.PURE_DATE_FORMAT);
            }
            if (length == "HHmmss".length()) {
                return DateUtil.parse((CharSequence)dateStr, (DateParser)DatePattern.PURE_TIME_FORMAT);
            }
            if (length == 12 || length == 13) {
                return DateUtil.date((long)NumberUtil.parseLong((String)dateStr));
            }
        }
        return DateUtil.parse((CharSequence)dateCharSequence);
    }

    @Generated
    private DateUtils() {
    }
}

