/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.core.config;

import cn.smarthse.framework.core.config.properties.TaskExecutorProperties;
import cn.smarthse.framework.core.utils.SpringUtils;
import cn.smarthse.framework.core.utils.Threads;
import jakarta.annotation.PreDestroy;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.Generated;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.task.VirtualThreadTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@AutoConfiguration
@EnableConfigurationProperties(value={TaskExecutorProperties.class})
public class ThreadPoolConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolConfig.class);
    private final int core = Runtime.getRuntime().availableProcessors() + 1;
    private ScheduledExecutorService scheduledExecutorService;

    @Bean(name={"threadPoolTaskExecutor"})
    @ConditionalOnProperty(prefix="thread-pool", name={"enabled"}, havingValue="true")
    public ThreadPoolTaskExecutor threadPoolTaskExecutor(TaskExecutorProperties threadPoolProperties) {
        log.info("\u521d\u59cb\u5316 ThreadPoolTaskExecutor \u914d\u7f6e");
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.core);
        executor.setMaxPoolSize(this.core * 2);
        executor.setQueueCapacity(threadPoolProperties.getQueueCapacity());
        executor.setKeepAliveSeconds(threadPoolProperties.getKeepAliveSeconds());
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        return executor;
    }

    @Bean(name={"scheduledExecutorService"})
    protected ScheduledExecutorService scheduledExecutorService() {
        BasicThreadFactory.Builder builder = new BasicThreadFactory.Builder().daemon(true);
        if (SpringUtils.isVirtual()) {
            builder.namingPattern("virtual-schedule-pool-%d").wrappedFactory(new VirtualThreadTaskExecutor().getVirtualThreadFactory());
        } else {
            builder.namingPattern("schedule-pool-%d");
        }
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(this.core, (ThreadFactory)builder.build(), new ThreadPoolExecutor.CallerRunsPolicy()){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                Threads.printException(r, t);
            }
        };
        this.scheduledExecutorService = scheduledThreadPoolExecutor;
        return scheduledThreadPoolExecutor;
    }

    @PreDestroy
    public void destroy() {
        try {
            log.info("====\u5173\u95ed\u540e\u53f0\u4efb\u52a1\u4efb\u52a1\u7ebf\u7a0b\u6c60====");
            Threads.shutdownAndAwaitTermination(this.scheduledExecutorService);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

