/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.aws.core;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.IdUtil;
import cn.smarthse.framework.aws.constant.OssConstant;
import cn.smarthse.framework.aws.core.WriteOutSubscriber;
import cn.smarthse.framework.aws.entity.UploadResult;
import cn.smarthse.framework.aws.enums.AccessPolicyType;
import cn.smarthse.framework.aws.exception.OssException;
import cn.smarthse.framework.aws.properties.OssProperties;
import cn.smarthse.framework.core.utils.DateUtils;
import cn.smarthse.framework.core.utils.StringUtils;
import cn.smarthse.framework.core.utils.file.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.BlockingInputStreamAsyncRequestBody;
import software.amazon.awssdk.core.async.ResponsePublisher;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;
import software.amazon.awssdk.transfer.s3.S3TransferManager;
import software.amazon.awssdk.transfer.s3.model.CompletedDownload;
import software.amazon.awssdk.transfer.s3.model.CompletedFileUpload;
import software.amazon.awssdk.transfer.s3.model.CompletedUpload;
import software.amazon.awssdk.transfer.s3.model.Download;
import software.amazon.awssdk.transfer.s3.model.DownloadRequest;
import software.amazon.awssdk.transfer.s3.model.FileDownload;
import software.amazon.awssdk.transfer.s3.model.FileUpload;
import software.amazon.awssdk.transfer.s3.model.Upload;
import software.amazon.awssdk.transfer.s3.progress.LoggingTransferListener;
import software.amazon.awssdk.transfer.s3.progress.TransferListener;

public class OssClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OssClient.class);
    private final String configKey;
    private final OssProperties properties;
    private final S3AsyncClient client;
    private final S3TransferManager transferManager;
    private final S3Presigner presigner;

    public OssClient(String configKey, OssProperties ossProperties) {
        this.configKey = configKey;
        this.properties = ossProperties;
        try {
            StaticCredentialsProvider credentialsProvider = StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.properties.getAccessKey(), (String)this.properties.getSecretKey()));
            boolean isStyle = !StringUtils.containsAny((CharSequence)this.properties.getEndpoint(), (CharSequence[])OssConstant.CLOUD_SERVICE);
            this.client = (S3AsyncClient)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)S3AsyncClient.builder().credentialsProvider((AwsCredentialsProvider)credentialsProvider)).endpointOverride(URI.create(this.getEndpoint()))).region(this.of())).forcePathStyle(Boolean.valueOf(isStyle))).httpClient(NettyNioAsyncHttpClient.builder().connectionTimeout(Duration.ofSeconds(60L)).build())).build();
            this.transferManager = S3TransferManager.builder().s3Client(this.client).build();
            S3Configuration config = (S3Configuration)S3Configuration.builder().chunkedEncodingEnabled(Boolean.valueOf(false)).pathStyleAccessEnabled(Boolean.valueOf(isStyle)).build();
            this.presigner = S3Presigner.builder().region(this.of()).credentialsProvider((AwsCredentialsProvider)credentialsProvider).endpointOverride(URI.create(this.getDomain())).serviceConfiguration(config).build();
        }
        catch (Exception e) {
            if (e instanceof OssException) {
                throw e;
            }
            throw new OssException("\u914d\u7f6e\u9519\u8bef! \u8bf7\u68c0\u67e5\u7cfb\u7edf\u914d\u7f6e:[" + e.getMessage() + "]");
        }
    }

    public UploadResult upload(Path filePath, String key, String md5Digest, String contentType) {
        try {
            FileUpload fileUpload = this.transferManager.uploadFile(x -> x.putObjectRequest(y -> y.bucket(this.properties.getBucketName()).key(key).contentMD5(StringUtils.isNotEmpty((String)md5Digest) ? md5Digest : null).contentType(contentType).build()).addTransferListener((TransferListener)LoggingTransferListener.create()).source(filePath).build());
            CompletedFileUpload uploadResult = (CompletedFileUpload)fileUpload.completionFuture().join();
            String eTag = uploadResult.response().eTag();
            UploadResult uploadResult2 = UploadResult.builder().url(this.getUrl() + "/" + key).filename(key).eTag(eTag).build();
            return uploadResult2;
        }
        catch (Exception e) {
            throw new OssException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f:[" + e.getMessage() + "]");
        }
        finally {
            FileUtils.del((Path)filePath);
        }
    }

    public UploadResult upload(InputStream inputStream, String key, Long length, String contentType) {
        if (!(inputStream instanceof ByteArrayInputStream)) {
            inputStream = new ByteArrayInputStream(IoUtil.readBytes((InputStream)inputStream));
        }
        try {
            BlockingInputStreamAsyncRequestBody body = BlockingInputStreamAsyncRequestBody.builder().contentLength(length).subscribeTimeout(Duration.ofSeconds(120L)).build();
            Upload upload = this.transferManager.upload(x -> x.requestBody((AsyncRequestBody)body).addTransferListener((TransferListener)LoggingTransferListener.create()).putObjectRequest(y -> y.bucket(this.properties.getBucketName()).key(key).contentType(contentType).build()).build());
            body.writeInputStream(inputStream);
            CompletedUpload uploadResult = (CompletedUpload)upload.completionFuture().join();
            String eTag = uploadResult.response().eTag();
            return UploadResult.builder().url(this.getUrl() + "/" + key).filename(key).eTag(eTag).build();
        }
        catch (Exception e) {
            throw new OssException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f:[" + e.getMessage() + "]");
        }
    }

    public Path fileDownload(String path) {
        Path tempFilePath = FileUtils.createTempFile().toPath();
        FileDownload downloadFile = this.transferManager.downloadFile(x -> x.getObjectRequest(y -> y.bucket(this.properties.getBucketName()).key(this.removeBaseUrl(path)).build()).addTransferListener((TransferListener)LoggingTransferListener.create()).destination(tempFilePath).build());
        downloadFile.completionFuture().join();
        return tempFilePath;
    }

    public void download(String key, OutputStream out, Consumer<Long> consumer) {
        try {
            this.download(key, consumer).writeTo(out);
        }
        catch (Exception e) {
            throw new OssException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:[" + e.getMessage() + "]");
        }
    }

    public WriteOutSubscriber<OutputStream> download(String key, Consumer<Long> contentLengthConsumer) {
        try {
            DownloadRequest publisherDownloadRequest = (DownloadRequest)DownloadRequest.builder().getObjectRequest(y -> y.bucket(this.properties.getBucketName()).key(key).build()).addTransferListener((TransferListener)LoggingTransferListener.create()).responseTransformer(AsyncResponseTransformer.toPublisher()).build();
            Download publisherDownload = this.transferManager.download(publisherDownloadRequest);
            ResponsePublisher publisher = (ResponsePublisher)((CompletedDownload)publisherDownload.completionFuture().join()).result();
            Optional.ofNullable(contentLengthConsumer).ifPresent(lengthConsumer -> lengthConsumer.accept(((GetObjectResponse)publisher.response()).contentLength()));
            return out -> {
                try (WritableByteChannel channel = Channels.newChannel(out);){
                    publisher.subscribe(byteBuffer -> {
                        while (byteBuffer.hasRemaining()) {
                            try {
                                channel.write((ByteBuffer)byteBuffer);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }).join();
                }
            };
        }
        catch (Exception e) {
            throw new OssException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:[" + e.getMessage() + "]");
        }
    }

    public void delete(String path) {
        try {
            this.client.deleteObject(x -> x.bucket(this.properties.getBucketName()).key(this.removeBaseUrl(path)).build());
        }
        catch (Exception e) {
            throw new OssException("\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f:[" + e.getMessage() + "]");
        }
    }

    public String createPresignedGetUrl(String objectKey, Duration expiredTime) {
        URL url = this.presigner.presignGetObject(x -> x.signatureDuration(expiredTime).getObjectRequest(y -> y.bucket(this.properties.getBucketName()).key(objectKey).build()).build()).url();
        return url.toExternalForm();
    }

    public String createPresignedPutUrl(String objectKey, Duration expiredTime, Map<String, String> metadata) {
        URL url = this.presigner.presignPutObject(x -> x.signatureDuration(expiredTime).putObjectRequest(y -> y.bucket(this.properties.getBucketName()).key(objectKey).metadata(metadata).build()).build()).url();
        return url.toExternalForm();
    }

    public UploadResult uploadSuffix(byte[] data, String suffix, String contentType) {
        return this.upload(new ByteArrayInputStream(data), this.getPath(this.properties.getPrefix(), suffix), Long.valueOf(data.length), contentType);
    }

    public UploadResult uploadSuffix(InputStream inputStream, String suffix, Long length, String contentType) {
        return this.upload(inputStream, this.getPath(this.properties.getPrefix(), suffix), length, contentType);
    }

    public UploadResult uploadSuffix(File file, String suffix) {
        return this.upload(file.toPath(), this.getPath(this.properties.getPrefix(), suffix), null, FileUtils.getMimeType((String)suffix));
    }

    public InputStream getObjectContent(String path) throws IOException {
        Path tempFilePath = this.fileDownload(path);
        InputStream inputStream = Files.newInputStream(tempFilePath, new OpenOption[0]);
        FileUtils.del((Path)tempFilePath);
        return inputStream;
    }

    public String getEndpoint() {
        String header = this.getIsHttps();
        return header + this.properties.getEndpoint();
    }

    public String getDomain() {
        String domain = this.properties.getDomain();
        String endpoint = this.properties.getEndpoint();
        String header = this.getIsHttps();
        if (StringUtils.containsAny((CharSequence)endpoint, (CharSequence[])OssConstant.CLOUD_SERVICE)) {
            return StringUtils.isNotEmpty((String)domain) ? header + domain : header + endpoint;
        }
        if (StringUtils.isNotEmpty((String)domain)) {
            return domain.startsWith("https://") || domain.startsWith("http://") ? domain : header + domain;
        }
        return header + endpoint;
    }

    public Region of() {
        String region = this.properties.getRegion();
        return StringUtils.isNotEmpty((String)region) ? Region.of((String)region) : Region.US_EAST_1;
    }

    public String getUrl() {
        String domain = this.properties.getDomain();
        String endpoint = this.properties.getEndpoint();
        String header = this.getIsHttps();
        if (StringUtils.containsAny((CharSequence)endpoint, (CharSequence[])OssConstant.CLOUD_SERVICE)) {
            return header + (String)(StringUtils.isNotEmpty((String)domain) ? domain : this.properties.getBucketName() + "." + endpoint);
        }
        if (StringUtils.isNotEmpty((String)domain)) {
            return domain.startsWith("https://") || domain.startsWith("http://") ? domain + "/" + this.properties.getBucketName() : header + domain + "/" + this.properties.getBucketName();
        }
        return header + endpoint + "/" + this.properties.getBucketName();
    }

    public String getPath(String prefix, String suffix) {
        String uuid = IdUtil.fastSimpleUUID();
        String datePath = DateUtils.datePath();
        String path = StringUtils.isNotEmpty((String)prefix) ? prefix + "/" + datePath + "/" + uuid : datePath + "/" + uuid;
        return path + suffix;
    }

    public String removeBaseUrl(String path) {
        return path.replace(this.getUrl() + "/", "");
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public String getIsHttps() {
        return "Y".equals(this.properties.getIsHttps()) ? "https://" : "http://";
    }

    public boolean checkPropertiesSame(OssProperties properties) {
        return this.properties.equals(properties);
    }

    public AccessPolicyType getAccessPolicy() {
        return AccessPolicyType.getByType(this.properties.getAccessPolicy());
    }
}

