/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.syn.service.impl;

import cn.smarthse.fwgj.converter.SynGjConverter;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjCheckInfo;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjCheckItem;
import cn.smarthse.fwgj.framework.RedisKey;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjCheckInfoService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjCheckItemService;
import cn.smarthse.fwgj.syn.param.CheckInfoParam;
import cn.smarthse.fwgj.syn.param.CheckItemParam;
import cn.smarthse.fwgj.syn.param.SynGjCheckAddParam;
import cn.smarthse.fwgj.syn.service.ISynGjCheckService;
import cn.smarthse.fwgj.syn.service.UploadOssUtil;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.platform.model.AreaModel;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class SynGjCheckServiceImpl
implements ISynGjCheckService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SynGjCheckServiceImpl.class);
    private final IThirdGjCheckInfoService thirdGjCheckInfoService;
    private final IThirdGjCheckItemService thirdGjCheckItemService;
    private final UploadOssUtil UploadOssUtil;
    private final SynGjConverter converter;
    private final RedisTemplate redisTemplate;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaProvideService;

    @Override
    public Long addCheckInfo(SynGjCheckAddParam param) {
        CheckInfoParam checkInfoParam = param.getCheck();
        CheckItemParam checkItem = param.getCheckItem();
        if (this.isExistsCheckInfo(checkInfoParam.getSource(), checkInfoParam.getSourceId())) {
            log.error(String.format("sourceId\u4e3a\u201c%s\u201d\u7684\u5de1\u67e5\u5df2\u5b58\u5728\uff01", checkInfoParam.getSourceId()));
            return 0L;
        }
        ThirdGjCheckInfo checkInfo = this.converter.CheckInfoParam2ThirdGjCheckInfo(checkInfoParam);
        this.initCheckInfo(checkInfo, checkInfoParam);
        this.thirdGjCheckInfoService.saveOrUpdate(checkInfo);
        ThirdGjCheckItem tmPatrolItem = this.converter.CheckItemParam2ThirdGjCheckItem(checkItem);
        this.initCheckItemParam(tmPatrolItem, checkInfo);
        this.thirdGjCheckItemService.saveOrUpdate(tmPatrolItem);
        this.addCheckInfoAfter(checkInfo.getCid(), tmPatrolItem.getId());
        return checkInfo.getId();
    }

    private void addCheckInfoAfter(Long cid, Long itemId) {
        this.redisTemplate.opsForValue().set((Object)RedisKey.synReferenceData(cid), (Object)itemId);
    }

    private void initCheckInfo(ThirdGjCheckInfo checkInfo, CheckInfoParam checkInfoParam) {
        CompanySuperviseModel company = this.companyProvideService.getCompanyInfoById(checkInfo.getCid());
        if (company != null) {
            checkInfo.setUnitName(company.getName());
            checkInfo.setUnitStatus(null);
            checkInfo.setManager(company.getMainLeaderName());
            checkInfo.setTel(company.getMainLeaderTel());
            checkInfo.setHseManager(company.getOccManagerName());
            checkInfo.setHesTel(company.getOccManagerTel());
            checkInfo.setIndustryCode(String.valueOf(company.getIndustryCategory()));
            checkInfo.setIndustryName(company.getIndustryCategoryName());
            checkInfo.setScaleCode(company.getScale());
            checkInfo.setEconomyCode(String.valueOf(company.getRegisterType()));
            checkInfo.setEconomyName(company.getRegisterTypeName());
            checkInfo.setAreaId(company.getAreaId());
            checkInfo.setAddress(company.getRegisterAddress());
            checkInfo.setWorkAddress(company.getWorkAddress());
            AreaModel area = this.areaProvideService.getAreaById(company.getAreaId());
            if (area != null) {
                checkInfo.setAreaId1(area.getProvinceId());
                checkInfo.setAreaId2(area.getCityId());
                checkInfo.setAreaId3(area.getAreaId());
                checkInfo.setAreaId4(area.getStreetId());
            }
        }
        checkInfo.setCheckFile(this.UploadOssUtil.uplod2Oss(checkInfoParam.getCheckFileList()));
        checkInfo.setUnitManageSign(this.UploadOssUtil.uplod2Oss(checkInfoParam.getUnitManageSign()));
    }

    private void initCheckItemParam(ThirdGjCheckItem tmPatrolItem, ThirdGjCheckInfo checkInfo) {
        tmPatrolItem.setCheckId(checkInfo.getId());
        tmPatrolItem.setCid(checkInfo.getCid());
        this.redisTemplate.opsForValue().set((Object)RedisKey.synReferenceData(checkInfo.getCid()), (Object)checkInfo.getId());
    }

    private boolean isExistsCheckInfo(String source, String sourceId) {
        return this.thirdGjCheckInfoService.getCheckInfoBySourceId(source, sourceId) != null;
    }

    @Override
    public ThirdGjCheckItem getItemReferenceData(Long cid) {
        return null;
    }

    @Override
    public void updateReferenceData(ThirdGjCheckItem referenceData) {
    }

    @Generated
    public SynGjCheckServiceImpl(IThirdGjCheckInfoService thirdGjCheckInfoService, IThirdGjCheckItemService thirdGjCheckItemService, UploadOssUtil UploadOssUtil2, SynGjConverter converter, RedisTemplate redisTemplate) {
        this.thirdGjCheckInfoService = thirdGjCheckInfoService;
        this.thirdGjCheckItemService = thirdGjCheckItemService;
        this.UploadOssUtil = UploadOssUtil2;
        this.converter = converter;
        this.redisTemplate = redisTemplate;
    }
}

