/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.syn.service;

import cn.hutool.core.io.FileUtil;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.smarthse.common.framework.file.FileUploadSimple;
import cn.smarthse.common.framework.file.UploadFileParameter;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.framework.oss.bean.OssClientBean;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.vo.outdata.checkplan.FileParam;
import cn.smarthse.modules.uploader.FileResourceEnum;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class UploadOssUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UploadOssUtil.class);
    @Autowired
    protected OssClientBean ossClientBean;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;

    public Long uplod2Oss(FileParam fileParam) {
        if (fileParam == null) {
            return null;
        }
        return Long.parseLong(this.uplod2Oss(fileParam.getUrl(), fileParam.getFileName()));
    }

    public String uplod2Oss(List<FileParam> fileParamList) {
        if (CollectionUtils.isEmpty(fileParamList)) {
            return null;
        }
        StringBuilder fileIds = new StringBuilder();
        for (FileParam record : fileParamList) {
            fileIds.append(this.uplod2Oss(record.getUrl(), record.getFileName())).append(",");
        }
        return fileIds.deleteCharAt(fileIds.length() - 1).toString();
    }

    public String uplod2Oss(String urlStr, String fileName) {
        if (StringUtils.isEmpty((CharSequence)urlStr)) {
            return null;
        }
        if (!urlStr.startsWith("http") && !urlStr.startsWith("https")) {
            log.error("\u8be5\u8bf7\u6c42\u4e0d\u662f\u4ee5http\u6216https\u5f00\u5934");
            return null;
        }
        try {
            HttpResponse execute = HttpUtil.createGet((String)urlStr).execute();
            InputStream inputStream = execute.bodyStream();
            String ossFileName = FileUploadSimple.getNumberName((String)FileUtil.getSuffix((String)fileName));
            String uploadDir = UploadFileParameter.FILE_PATH + FileResourceEnum.FWGJ.getCode() + File.separator + "syn" + File.separator + FileUploadSimple.getDataPath();
            String realPath = this.ossClientBean.getLocal() + uploadDir + File.separator + ossFileName;
            String ossUrl = (uploadDir + "/" + ossFileName).replace("\\", "/");
            File obj = new File(realPath);
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)obj);
            this.ossClientBean.OSSPutObject(ossFileName, new File(realPath), uploadDir, fileName, null);
            SysFileModel file = new SysFileModel();
            file.setFileName(fileName);
            file.setResource(Integer.valueOf(FileResourceEnum.TOWNSHIP_MANAGE.getValue()));
            file.setFileSize(FileUtils.byteCountToDisplaySize((long)FileUtils.sizeOf((File)obj)));
            file.setFileExt(fileName.contains(".") ? fileName.substring(fileName.lastIndexOf(".") + 1) : "");
            file.setFileHash(String.valueOf(FileUtils.checksumCRC32((File)obj)));
            file.setOssUrl(uploadDir);
            file.setDescription("");
            file = this.sysFileProvideService.addSysFile(file, Long.valueOf(0L));
            obj.delete();
            return file.getId().toString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

