/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.service.thirdGj.impl;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.fwgj.dao.thirdGj.ThirdGjOrgMapper;
import cn.smarthse.fwgj.dao.thirdGj.ThirdOrgMapper;
import cn.smarthse.fwgj.entity.sys.ThirdOrganization;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrg;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgAuditLog;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgCustomer;
import cn.smarthse.fwgj.enums.ThirdGjOrgAuditLogTypeEnum;
import cn.smarthse.fwgj.enums.ThirdGjOrgAuditOptEnum;
import cn.smarthse.fwgj.enums.ThirdGjOrgAuditResultEnum;
import cn.smarthse.fwgj.enums.ThirdGjOrgCustomerStateEnum;
import cn.smarthse.fwgj.enums.ThirdGjOrgCustomerUnsignTypeEnum;
import cn.smarthse.fwgj.enums.ThirdGjOrgStateEnums;
import cn.smarthse.fwgj.enums.ThirdGjUserLogStateEnums;
import cn.smarthse.fwgj.framework.Constant;
import cn.smarthse.fwgj.model.param.admin.ForbiddenGjOrgParam;
import cn.smarthse.fwgj.model.param.admin.GjFilingAuditListParam;
import cn.smarthse.fwgj.model.param.admin.GjFilingAuditParam;
import cn.smarthse.fwgj.model.param.admin.GjOrgAddParam;
import cn.smarthse.fwgj.model.param.admin.GjOrgInfoManageListParam;
import cn.smarthse.fwgj.model.param.admin.GjOrgScoringParam;
import cn.smarthse.fwgj.model.param.admin.OneOrgStatisticsParam;
import cn.smarthse.fwgj.model.param.company.GjOrjSearchParam;
import cn.smarthse.fwgj.model.param.third.GjOrgParamParam;
import cn.smarthse.fwgj.model.vo.admin.GjFilingAuditStatisticsVo;
import cn.smarthse.fwgj.model.vo.admin.GjFilingAuditVo;
import cn.smarthse.fwgj.model.vo.admin.GjOrgFilingDetailVo;
import cn.smarthse.fwgj.model.vo.admin.GjOrgInfoChooseVo;
import cn.smarthse.fwgj.model.vo.admin.GjOrgInfoVo;
import cn.smarthse.fwgj.model.vo.admin.GjOrgServiceAreaStatisticsVo;
import cn.smarthse.fwgj.model.vo.admin.GjOrgServiceStatisticsVo;
import cn.smarthse.fwgj.model.vo.admin.OneOrgStatisticsVo;
import cn.smarthse.fwgj.model.vo.company.CompanyGjOrjListVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgListVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgScoreVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgVo;
import cn.smarthse.fwgj.model.vo.third.ThirdGjUserVo;
import cn.smarthse.fwgj.model.vo.third.ThirdOrganizationVo;
import cn.smarthse.fwgj.service.sys.IThirdGjUserLogService;
import cn.smarthse.fwgj.service.sys.IThirdGjUserService;
import cn.smarthse.fwgj.service.sys.IThirdOrganizationService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjOrgAuditLogService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjOrgCustomerService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjOrgService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.platform.model.AreaModel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ThirdGjOrgServiceImpl
extends ServiceImpl<ThirdGjOrgMapper, ThirdGjOrg>
implements IThirdGjOrgService {
    @Resource
    private IThirdGjUserService userService;
    @Resource
    private IThirdGjUserLogService userLogService;
    @Resource
    private IThirdGjOrgAuditLogService orgAuditLogService;
    @Resource
    private IThirdGjOrgCustomerService orgCustomerService;
    @Resource
    private IThirdOrganizationService thirdOrganizationService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaProvideService;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    private final ThirdOrgMapper thirdOrgMapper;

    @Override
    public JqGridData<GjOrgListVo> getGjOrgListData(GjOrgParamParam param) {
        AreaModel area;
        Long areaId = param.getAreaId();
        if (areaId != null && (area = this.areaProvideService.getAreaById(areaId)) != null) {
            param.setLevel(area.getLevel());
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new JqGridData((Page)((ThirdGjOrgMapper)this.baseMapper).getGjOrgListData(param), (JqGridParam)param);
    }

    @Override
    public GjOrgVo getGjOrg(Long gjOrgId) {
        ThirdGjOrg gjOrg = (ThirdGjOrg)this.getById(gjOrgId);
        if (gjOrg == null) {
            return null;
        }
        GjOrgVo gjOrgVo = new GjOrgVo();
        gjOrgVo.setId(gjOrgId);
        gjOrgVo.setAuditTime(gjOrg.getAuditTime());
        gjOrgVo.setState(gjOrg.getState());
        gjOrgVo.setOrgId(gjOrg.getOrgId());
        gjOrgVo.setApplyFileList(this.sysFileProvideService.getListByIds(gjOrg.getApplyFile()));
        gjOrgVo.setCommitmentFileList(this.sysFileProvideService.getListByIds(gjOrg.getCommitmentFile()));
        gjOrgVo.setBusLicenseFileList(this.sysFileProvideService.getListByIds(gjOrg.getBusLicenseFile()));
        gjOrgVo.setArea(this.areaProvideService.getAreaById(gjOrg.getAreaId()));
        return gjOrgVo;
    }

    @Override
    public GjOrgVo getLastGjOrg(Long orgId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ThirdGjOrg.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdGjOrg::getOrgId, (Object)orgId)).eq(ThirdGjOrg::getState, (Object)ThirdGjOrgStateEnums.PASS.getValue())).eq(ThirdGjOrg::getIsValid, (Object)Constant.ACTIVE_YES)).orderByDesc(ThirdGjOrg::getId)).last("limit 1");
        ThirdGjOrg gjOrg = (ThirdGjOrg)((ThirdGjOrgMapper)this.baseMapper).selectOne((Wrapper)wrapper);
        if (gjOrg == null) {
            return null;
        }
        GjOrgVo gjOrgVo = new GjOrgVo();
        gjOrgVo.setId(gjOrg.getId());
        gjOrgVo.setAuditTime(gjOrg.getAuditTime());
        gjOrgVo.setState(gjOrg.getState());
        gjOrgVo.setOrgId(gjOrg.getOrgId());
        gjOrgVo.setApplyFileList(this.sysFileProvideService.getListByIds(gjOrg.getApplyFile()));
        gjOrgVo.setCommitmentFileList(this.sysFileProvideService.getListByIds(gjOrg.getCommitmentFile()));
        gjOrgVo.setBusLicenseFileList(this.sysFileProvideService.getListByIds(gjOrg.getBusLicenseFile()));
        return gjOrgVo;
    }

    @Override
    public ThirdGjOrg getByAreaId(Long orgId, Long areaId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ThirdGjOrg.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdGjOrg::getOrgId, (Object)orgId)).eq(ThirdGjOrg::getAreaId, (Object)areaId)).eq(ThirdGjOrg::getIsValid, (Object)Constant.ACTIVE_YES)).last("limit 1");
        return (ThirdGjOrg)((ThirdGjOrgMapper)this.baseMapper).selectOne((Wrapper)wrapper);
    }

    @Override
    public ThirdGjOrg getByAreaId(Long orgId, Long areaId, Integer state) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ThirdGjOrg.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdGjOrg::getOrgId, (Object)orgId)).eq(ThirdGjOrg::getAreaId, (Object)areaId)).eq(ThirdGjOrg::getIsValid, (Object)Constant.ACTIVE_YES)).eq(ThirdGjOrg::getState, (Object)state)).last("limit 1");
        return (ThirdGjOrg)((ThirdGjOrgMapper)this.baseMapper).selectOne((Wrapper)wrapper);
    }

    @Override
    public List<GjFilingAuditStatisticsVo> fwgjFilingAuditStatisticsPageData(GjFilingAuditListParam param) {
        List<GjFilingAuditStatisticsVo> results = ((ThirdGjOrgMapper)this.baseMapper).getFwgjFilingAuditStatisticsList(param);
        if (!CollectionUtils.isEmpty(results)) {
            results.forEach(item -> {
                if (item.getUpdateTime() == null) {
                    Date updateTime = ((ThirdGjOrgMapper)this.baseMapper).getGjFilingUpdateTime(item.getAreaId(), item.getAreaLevel());
                    item.setUpdateTime(updateTime);
                }
            });
        }
        return results;
    }

    @Override
    public JqGridData<GjFilingAuditVo> fwgjFilingAuditPageData(GjFilingAuditListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        PageInfo resultList = new PageInfo(((ThirdGjOrgMapper)this.baseMapper).getFwgjFilingAuditList(param));
        return new JqGridData(resultList, (JqGridParam)param);
    }

    @Override
    public JqGridData<GjOrgInfoVo> getFwgjInfoListPageData(GjOrgInfoManageListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        PageInfo resultList = new PageInfo(((ThirdGjOrgMapper)this.baseMapper).getFwgjInfoList(param));
        return new JqGridData(resultList, (JqGridParam)param);
    }

    @Override
    public void updateStateById(Long id, Integer state) {
        LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)lambdaUpdateWrapper.eq(ThirdGjOrg::getId, (Object)id)).set(ThirdGjOrg::getState, (Object)state);
        if (state.equals(ThirdGjOrgStateEnums.PASS.getValue())) {
            lambdaUpdateWrapper.set(ThirdGjOrg::getAuditTime, (Object)new Date());
        }
        this.update((Wrapper)lambdaUpdateWrapper);
    }

    @Override
    public List<GjOrgScoreVo> getScoreListByOrgId(Long orgId) {
        return ((ThirdGjOrgMapper)this.baseMapper).getScoreListByOrgId(orgId);
    }

    @Override
    @Transactional
    public void fwgjFilingAudit(GjFilingAuditParam param) {
        ThirdOrganization organization;
        this.updateStateById(param.getGjOrgId(), param.getState());
        List<ThirdGjUserVo> gjUserVoList = this.userService.getOrgGJInfoList(param.getOrgId(), ThirdGjUserLogStateEnums.PENDING_AUDIT.getValue());
        if (!CollectionUtils.isEmpty(gjUserVoList)) {
            List<Long> userLogIds = gjUserVoList.stream().map(ThirdGjUserVo::getGjUserLogId).collect(Collectors.toList());
            this.userLogService.updateStateBatchByIds(userLogIds, param.getState(), param.getReason());
            if (param.getState().equals(ThirdGjOrgAuditResultEnum.PASS.getValue())) {
                ArrayList userLogs = new ArrayList();
                gjUserVoList.forEach(item -> {
                    ThirdGjOrgAuditLog log = new ThirdGjOrgAuditLog().setType(ThirdGjOrgAuditLogTypeEnum.third_gj_user_log.getValue()).setBusinessId(item.getGjUserLogId()).setOptPeople(param.getOptPeople()).setOpt(ThirdGjOrgAuditOptEnum.user_log_state_2.getOptName()).setOptValue(ThirdGjOrgAuditOptEnum.user_log_state_2.getOptValue()).setOptDesc("\u901a\u8fc7\u670d\u52a1\u7ba1\u5bb6\u5907\u6848\u6dfb\u52a0");
                    userLogs.add(log);
                });
                this.orgAuditLogService.saveBatch(userLogs);
            }
        }
        ThirdGjOrgAuditLog log = new ThirdGjOrgAuditLog().setType(ThirdGjOrgAuditLogTypeEnum.third_gj_org.getValue()).setBusinessId(param.getGjOrgId()).setOptPeople(param.getOptPeople());
        if (param.getState().equals(ThirdGjOrgAuditResultEnum.PASS.getValue())) {
            log.setOpt(ThirdGjOrgAuditOptEnum.org_opt_2.getOptName());
            log.setOptValue(ThirdGjOrgAuditOptEnum.org_opt_2.getOptValue());
            if (!CollectionUtils.isEmpty(gjUserVoList)) {
                log.setOptDesc("\u5907\u6848\u6210\u529f\uff0c\u6dfb\u52a0" + gjUserVoList.size() + "\u540d\u7ba1\u5bb6\u4eba\u5458");
            }
        } else {
            log.setOpt(ThirdGjOrgAuditOptEnum.org_opt_3.getOptName());
            log.setOptValue(ThirdGjOrgAuditOptEnum.org_opt_3.getOptValue());
            log.setOptDesc(param.getReason());
        }
        this.orgAuditLogService.save(log);
        if (param.getState().equals(ThirdGjOrgAuditResultEnum.PASS.getValue()) && (organization = (ThirdOrganization)this.thirdOrganizationService.getById(param.getOrgId())) != null) {
            String orgTypes = organization.getOrgTypes();
            if (StringUtils.isEmpty((CharSequence)orgTypes)) {
                organization.setOrgTypes("12");
                this.thirdOrganizationService.updateById(organization);
            } else {
                orgTypes = orgTypes.contains("12") ? orgTypes : String.join((CharSequence)",", orgTypes, "12");
                organization.setOrgTypes(orgTypes);
                this.thirdOrganizationService.updateById(organization);
            }
        }
    }

    @Override
    public List<ThirdGjOrgCustomer> forbiddenGjOrg(ForbiddenGjOrgParam param) {
        if (param.getGjOrgId() == null || param.getForbiddenState() == null) {
            return null;
        }
        ThirdGjOrg thirdGjOrg = (ThirdGjOrg)this.getById(param.getGjOrgId());
        if (thirdGjOrg == null) {
            return null;
        }
        if (param.getLoginAreaLevel() > 1 && !Objects.equals(param.getLoginAreaId(), thirdGjOrg.getAreaId())) {
            return null;
        }
        if (!param.getForbiddenState().booleanValue()) {
            thirdGjOrg.setState(ThirdGjOrgStateEnums.FORBIDDEN.getValue());
            this.updateById(thirdGjOrg);
            ThirdGjOrgAuditLog log = new ThirdGjOrgAuditLog().setType(ThirdGjOrgAuditLogTypeEnum.third_gj_org_customer_cancel.getValue()).setBusinessId(param.getGjOrgId()).setOptPeople(param.getOptUser()).setOpt(ThirdGjOrgAuditOptEnum.org_opt_4.getOptName()).setOptDesc("\u76d1\u7ba1\u7981\u7528");
            List<ThirdGjOrgCustomer> customers = this.orgCustomerService.getCustomersByGjOrg(thirdGjOrg);
            ArrayList<ThirdGjOrgAuditLog> logs = new ArrayList<ThirdGjOrgAuditLog>();
            if (!CollectionUtils.isEmpty(customers)) {
                logs.add(log);
                customers.forEach(customer -> {
                    customer.setState(ThirdGjOrgCustomerStateEnum.cancel.getValue());
                    customer.setUnsignType(ThirdGjOrgCustomerUnsignTypeEnum.FORBIDDEN.getValue());
                    ThirdGjOrgAuditLog auditLog = new ThirdGjOrgAuditLog().setType(ThirdGjOrgAuditLogTypeEnum.third_gj_org_customer_cancel.getValue()).setBusinessId(customer.getId()).setOptPeople(param.getOptUser()).setOpt(ThirdGjOrgAuditOptEnum.customer_cancel_opt_2.getOptName()).setOptDesc("\u76d1\u7ba1\u7981\u7528\u6279\u91cf\u89e3\u7ea6");
                    logs.add(auditLog);
                });
                this.orgCustomerService.updateBatchById(customers);
                this.orgAuditLogService.saveBatch(logs);
            }
            return customers;
        }
        thirdGjOrg.setState(ThirdGjOrgStateEnums.PASS.getValue());
        this.updateById(thirdGjOrg);
        return null;
    }

    @Override
    public GjOrgServiceStatisticsVo getGjOrgServiceStatisticsData(Long orgId, Long areaId, Integer areaLevel) {
        List<ThirdGjOrg> allGjOrgList = this.getGjOrgList(orgId);
        allGjOrgList.sort(Comparator.comparingInt(ThirdGjOrg::getLevel));
        String areas = "";
        if (!CollectionUtils.isEmpty(allGjOrgList)) {
            areas = allGjOrgList.stream().map(ThirdGjOrg::getBaName).collect(Collectors.joining("\u3001"));
        }
        List gjOrgList = areaLevel == 1 ? allGjOrgList.stream().filter(item -> Objects.equals(item.getAreaId1(), areaId)).collect(Collectors.toList()) : (areaLevel == 2 ? allGjOrgList.stream().filter(item -> Objects.equals(item.getAreaId2(), areaId)).collect(Collectors.toList()) : allGjOrgList.stream().filter(item -> Objects.equals(item.getAreaId3(), areaId)).collect(Collectors.toList()));
        ThirdGjOrg gjOrg = this.getByAreaId(orgId, areaId, ThirdGjOrgStateEnums.PASS.getValue());
        if (gjOrg == null) {
            gjOrg = this.getByAreaId(orgId, areaId, ThirdGjOrgStateEnums.FORBIDDEN.getValue());
        }
        ThirdOrganization organization = (ThirdOrganization)this.thirdOrganizationService.getById(orgId);
        CompletableFuture<Integer> gjUserNumFuture = CompletableFuture.supplyAsync(() -> this.userLogService.getGjUserNumByOrgId(orgId));
        CompletableFuture<Integer> signedCompanyNumFuture = CompletableFuture.supplyAsync(() -> this.orgCustomerService.getSignedCompanyNumByOrgId(orgId));
        CompletableFuture<Integer> needCheckNumFuture = CompletableFuture.supplyAsync(() -> this.orgCustomerService.getNeedCheckCompanyNumByOrgId(orgId));
        CompletableFuture<Integer> nearDueNumFuture = CompletableFuture.supplyAsync(() -> this.orgCustomerService.getNearDueCompanyNumByOrgId(orgId));
        return new GjOrgServiceStatisticsVo().setOrgId(orgId).setOrgName(organization == null ? (gjOrg == null ? "" : gjOrg.getOrgName()) : organization.getName()).setOrgUserNum(gjUserNumFuture.join()).setSignComNum(signedCompanyNumFuture.join()).setServicedComNum(needCheckNumFuture.join()).setNearDueNum(nearDueNumFuture.join()).setCurrGjOrg(gjOrg).setGjOrgList(gjOrgList).setServiceAreas(areas);
    }

    @Override
    public List<GjOrgInfoChooseVo> getGjOrgInfoChooseVoList(Long orgId, Long areaId, Integer areaLevel, String keyword) {
        return ((ThirdGjOrgMapper)this.baseMapper).getGjOrgInfoChooseVoList(orgId, areaId, areaLevel, keyword);
    }

    @Override
    public GjOrgFilingDetailVo getGjOrgFilingDetailVo(Long gjOrgId) {
        return ((ThirdGjOrgMapper)this.baseMapper).getGjOrgFilingDetailVo(gjOrgId);
    }

    @Override
    public OneOrgStatisticsVo getMaterialInformation(OneOrgStatisticsParam param) {
        return ((ThirdGjOrgMapper)this.baseMapper).getMaterialInformation(param);
    }

    @Override
    public List<ThirdGjOrg> getGjOrgList(Long orgId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ThirdGjOrg.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdGjOrg::getOrgId, (Object)orgId)).eq(ThirdGjOrg::getState, (Object)ThirdGjOrgStateEnums.PASS.getValue())).eq(ThirdGjOrg::getIsValid, (Object)Constant.ACTIVE_YES);
        return ((ThirdGjOrgMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public List<ThirdGjOrg> getGjOrgList(Long orgId, Long areaId, Integer areaLevel) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ThirdGjOrg.class);
        ((LambdaQueryWrapper)wrapper.eq(ThirdGjOrg::getState, (Object)ThirdGjOrgStateEnums.PASS.getValue())).eq(ThirdGjOrg::getIsValid, (Object)Constant.ACTIVE_YES);
        if (orgId != null) {
            wrapper.eq(ThirdGjOrg::getOrgId, (Object)orgId);
        }
        if (areaLevel == 1) {
            wrapper.eq(ThirdGjOrg::getAreaId1, (Object)areaId);
        }
        if (areaLevel == 2) {
            ((LambdaQueryWrapper)wrapper.eq(ThirdGjOrg::getAreaId2, (Object)areaId)).eq(ThirdGjOrg::getAreaId, (Object)areaId);
        }
        if (areaLevel == 3) {
            ((LambdaQueryWrapper)wrapper.eq(ThirdGjOrg::getAreaId3, (Object)areaId)).eq(ThirdGjOrg::getAreaId, (Object)areaId);
        }
        return ((ThirdGjOrgMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public List<ThirdGjOrg> getGjOrgStateList(Long orgId, Long areaId, Integer areaLevel) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ThirdGjOrg.class);
        wrapper.eq(ThirdGjOrg::getIsValid, (Object)Constant.ACTIVE_YES);
        if (orgId != null) {
            wrapper.eq(ThirdGjOrg::getOrgId, (Object)orgId);
        }
        if (areaLevel == 1) {
            ((LambdaQueryWrapper)wrapper.eq(ThirdGjOrg::getAreaId1, (Object)areaId)).in(ThirdGjOrg::getState, new Object[]{2, 4});
        }
        if (areaLevel == 2) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdGjOrg::getAreaId2, (Object)areaId)).eq(ThirdGjOrg::getAreaId, (Object)areaId)).eq(ThirdGjOrg::getState, (Object)ThirdGjOrgStateEnums.PASS.getValue());
        }
        if (areaLevel == 3) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdGjOrg::getAreaId3, (Object)areaId)).eq(ThirdGjOrg::getAreaId, (Object)areaId)).eq(ThirdGjOrg::getState, (Object)ThirdGjOrgStateEnums.PASS.getValue());
        }
        return ((ThirdGjOrgMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public List<ThirdGjOrg> getGjOrgList(Long areaId, Integer areaLevel) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ThirdGjOrg.class);
        ((LambdaQueryWrapper)wrapper.eq(ThirdGjOrg::getState, (Object)ThirdGjOrgStateEnums.PASS.getValue())).eq(ThirdGjOrg::getIsValid, (Object)Constant.ACTIVE_YES);
        if (areaLevel == 1) {
            wrapper.eq(ThirdGjOrg::getAreaId1, (Object)areaId);
        }
        if (areaLevel == 2) {
            ((LambdaQueryWrapper)wrapper.eq(ThirdGjOrg::getAreaId2, (Object)areaId)).eq(ThirdGjOrg::getAreaId, (Object)areaId);
        }
        if (areaLevel == 3) {
            ((LambdaQueryWrapper)wrapper.eq(ThirdGjOrg::getAreaId3, (Object)areaId)).eq(ThirdGjOrg::getAreaId, (Object)areaId);
        }
        return ((ThirdGjOrgMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public JqGridData<CompanyGjOrjListVo> listOrjByCompanyAreaId(GjOrjSearchParam param) {
        AreaModel area = this.areaProvideService.getAreaById(param.getAreaId());
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(area.getProvinceId());
        list.add(area.getCityId());
        list.add(area.getAreaId());
        list.add(area.getStreetId());
        param.setAreaIdList(list);
        if (param.getBelongType() == 1) {
            param.setAreaId1(area.getProvinceId());
        } else if (param.getBelongType() == 2) {
            param.setAreaId2(area.getCityId());
        }
        if (param.getBelongType() == 0) {
            PageHelper.startPage((int)param.getPage(), (int)param.getRows());
            return new JqGridData((Page)((ThirdGjOrgMapper)this.baseMapper).listOrjByCompanyAreaId(param), (JqGridParam)param);
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new JqGridData((Page)((ThirdGjOrgMapper)this.baseMapper).listOrjByCompanyBelongType(param), (JqGridParam)param);
    }

    @Override
    public Boolean scoringForGjOrg(GjOrgScoringParam param) {
        ThirdGjOrg org = (ThirdGjOrg)this.getById(param.getGjOrgId());
        if (org == null) {
            return false;
        }
        org.setScore(param.getScore());
        this.updateById(org);
        return true;
    }

    @Override
    public List<GjOrgServiceAreaStatisticsVo> getGjOrgServiceAreaStatisticsVoList(Long loginUserAreaId, Integer loginAreaLevel, Long orgId) {
        ArrayList<GjOrgServiceAreaStatisticsVo> resultList = new ArrayList<GjOrgServiceAreaStatisticsVo>();
        List<ThirdGjOrg> currGJOrgAreas = this.getGjOrgList(orgId, loginUserAreaId, loginAreaLevel);
        if (!CollectionUtils.isEmpty(currGJOrgAreas)) {
            currGJOrgAreas.sort(Comparator.comparingInt(ThirdGjOrg::getLevel));
            currGJOrgAreas.forEach(gjOrg -> {
                GjOrgServiceAreaStatisticsVo statisticsVo = new GjOrgServiceAreaStatisticsVo();
                int unitNum = ((ThirdGjOrgMapper)this.baseMapper).getGjOrgServiceAreaUnitNum(gjOrg.getAreaId(), gjOrg.getLevel(), orgId);
                statisticsVo.setGjOrgId(gjOrg.getId());
                statisticsVo.setAreaId(gjOrg.getAreaId());
                statisticsVo.setLevel(gjOrg.getLevel());
                statisticsVo.setBaName(gjOrg.getBaName());
                statisticsVo.setBelongType(Integer.valueOf(gjOrg.getLevel() == 1 ? 1 : (gjOrg.getLevel() == 2 ? 2 : 0)));
                statisticsVo.setUnitNum(Integer.valueOf(unitNum));
                resultList.add(statisticsVo);
            });
            GjOrgServiceAreaStatisticsVo statisticsVo = new GjOrgServiceAreaStatisticsVo();
            statisticsVo.setBaName("\u5168\u90e8\u4f01\u4e1a");
            statisticsVo.setUnitNum(Integer.valueOf(resultList.stream().mapToInt(GjOrgServiceAreaStatisticsVo::getUnitNum).sum()));
            resultList.add(0, statisticsVo);
        }
        return resultList;
    }

    @Override
    public void addGjOrg(GjOrgAddParam param) {
        AreaModel baArea = this.areaProvideService.getAreaById(param.getLoginAdminUserAreaId());
        ThirdGjOrg gjOrg = new ThirdGjOrg();
        gjOrg.setOrgId(param.getOrgId());
        gjOrg.setOrgName(param.getOrgName());
        gjOrg.setOrgCreditCode(param.getOrgCreditCode());
        gjOrg.setUserId(param.getOrgUserId());
        gjOrg.setAreaId(param.getLoginAdminUserAreaId());
        gjOrg.setAddress(param.getAddress());
        gjOrg.setLevel(param.getLoginAdminUserAreaLevel());
        if (baArea != null && baArea.getLevel() >= 1) {
            gjOrg.setAreaId1(baArea.getProvinceId());
            gjOrg.setBaName(baArea.getFullname());
        }
        if (baArea != null && baArea.getLevel() >= 2) {
            gjOrg.setAreaId2(baArea.getCityId());
        }
        if (baArea != null && baArea.getLevel() >= 3) {
            gjOrg.setAreaId3(baArea.getAreaId());
        }
        gjOrg.setState(ThirdGjOrgStateEnums.PASS.getValue());
        gjOrg.setSubTime(new Date());
        gjOrg.setAuditTime(new Date());
        gjOrg.setCreateBy(param.getLoginAdminUserId());
        this.save(gjOrg);
        ThirdGjOrgAuditLog log = new ThirdGjOrgAuditLog().setType(ThirdGjOrgAuditLogTypeEnum.third_gj_org.getValue()).setBusinessId(gjOrg.getId()).setOptPeople(param.getLoginAdminUsername()).setOpt(ThirdGjOrgAuditOptEnum.org_opt_2.getOptName()).setOptDesc("\u76d1\u7ba1\u5bfc\u5165\u673a\u6784\u5907\u6848");
        this.orgAuditLogService.save(log);
    }

    @Override
    public String getOrgName(Long orgId) {
        ThirdOrganizationVo org = this.thirdOrgMapper.getThirdOrganization(orgId);
        return org != null ? org.getName() : null;
    }

    @Override
    public List<ThirdGjOrg> getOverSixMonthsGjOrgList(Long areaId, Integer areaLevel) {
        return ((ThirdGjOrgMapper)this.baseMapper).getOverSixMonthsGjOrgList(areaId, areaLevel);
    }

    @Generated
    public ThirdGjOrgServiceImpl(ThirdOrgMapper thirdOrgMapper) {
        this.thirdOrgMapper = thirdOrgMapper;
    }
}

