/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.service.thirdGj.impl;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.fwgj.dao.thirdGj.ThirdGjOrgCustomerLotMapper;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrg;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgAuditLog;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgCustomer;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgCustomerLot;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgCustomerLotDetail;
import cn.smarthse.fwgj.enums.GjOrgAddCompEnums;
import cn.smarthse.fwgj.enums.ThirdGjOrgAuditLogTypeEnum;
import cn.smarthse.fwgj.enums.ThirdGjOrgAuditOptEnum;
import cn.smarthse.fwgj.enums.ThirdGjOrgCustomerSourceEnum;
import cn.smarthse.fwgj.enums.ThirdGjOrgCustomerStateEnum;
import cn.smarthse.fwgj.model.param.admin.GjOrgAddCompListPageParam;
import cn.smarthse.fwgj.model.param.admin.GjOrgAddCompParam;
import cn.smarthse.fwgj.model.vo.admin.GjOrgAddCompDetailVo;
import cn.smarthse.fwgj.provider.supervise.thirdGjCheck.IThirdGjCheckProviderToSupervise;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjOrgAuditLogService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjOrgCustomerLotDetailService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjOrgCustomerLotService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjOrgCustomerService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjOrgService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ThirdGjOrgCustomerLotServiceImpl
extends ServiceImpl<ThirdGjOrgCustomerLotMapper, ThirdGjOrgCustomerLot>
implements IThirdGjOrgCustomerLotService {
    private final IThirdGjOrgService orgService;
    private final IThirdGjOrgAuditLogService orgAuditLogService;
    private final IThirdGjOrgCustomerService orgCustomerService;
    private final IThirdGjOrgCustomerLotDetailService customerLotDetailService;
    private final IThirdGjCheckProviderToSupervise thirdGjCheckProviderToSupervise;

    @Override
    public JqGridData<ThirdGjOrgCustomerLot> getGjOrgAddCompListPageData(GjOrgAddCompListPageParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new JqGridData((Page)((ThirdGjOrgCustomerLotMapper)this.baseMapper).getGjOrgAddCompListData(param), (JqGridParam)param);
    }

    @Override
    @Transactional
    public Long saveDraft(GjOrgAddCompParam param) {
        List customerLotDetails;
        ThirdGjOrg gjOrg = (ThirdGjOrg)this.orgService.getById(param.getGjOrgId());
        ThirdGjOrgCustomerLot lot = new ThirdGjOrgCustomerLot();
        if (param.getLotId() != null) {
            lot = (ThirdGjOrgCustomerLot)this.getById(param.getLotId());
        }
        if (gjOrg != null) {
            lot.setOrgId(gjOrg.getOrgId());
            lot.setGjOrgId(gjOrg.getId());
            lot.setOrgName(gjOrg.getOrgName());
            lot.setAddress(gjOrg.getAddress());
            lot.setAreaId(gjOrg.getAreaId());
            lot.setLevel(gjOrg.getLevel());
            lot.setAreaId1(gjOrg.getAreaId1());
            lot.setAreaId2(gjOrg.getAreaId2());
            lot.setAreaId3(gjOrg.getAreaId3());
        }
        lot.setOrgMan(param.getOrgMan());
        lot.setOrgTel(param.getOrgTel());
        lot.setState(GjOrgAddCompEnums.DRAFT.getValue());
        lot.setSubTime(new Date());
        lot.setChooseAreas(param.getChooseAreas());
        lot.setCreateBy(param.getLoginUserId());
        this.saveOrUpdate(lot);
        if (param.getLotId() != null) {
            this.customerLotDetailService.removeByLotId(lot.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(customerLotDetails = param.getCustomerLotDetails()))) {
            customerLotDetails = customerLotDetails.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ThirdGjOrgCustomerLotDetail>(Comparator.comparing(ThirdGjOrgCustomerLotDetail::getCid))), ArrayList::new));
            ThirdGjOrgCustomerLot finalLot = lot;
            customerLotDetails.forEach(detail -> {
                detail.setLotId(finalLot.getId());
                detail.setId(null);
            });
        }
        this.customerLotDetailService.saveBatch(customerLotDetails);
        return lot.getId();
    }

    @Override
    @Transactional
    public List<ThirdGjOrgCustomerLotDetail> saveList(Long lotId, String loginUser) {
        ThirdGjOrgCustomerLot lot = (ThirdGjOrgCustomerLot)this.getById(lotId);
        if (lot == null) {
            return null;
        }
        ThirdGjOrg gjOrg = (ThirdGjOrg)this.orgService.getById(lot.getGjOrgId());
        if (gjOrg == null) {
            return null;
        }
        lot.setState(GjOrgAddCompEnums.ADD.getValue());
        lot.setSubTime(new Date());
        this.saveOrUpdate(lot);
        List<Object> customerLotDetails = this.customerLotDetailService.getListByLotId(lotId);
        List<ThirdGjOrgCustomer> signedList = this.orgCustomerService.getCustomerListByOrgId(null);
        List<ThirdGjOrgCustomerLotDetail> tobeDelList = null;
        if (CollectionUtils.isNotEmpty(signedList)) {
            List<ThirdGjOrgCustomerLotDetail> finalTobeDelList = tobeDelList = customerLotDetails.stream().filter(a -> signedList.stream().map(ThirdGjOrgCustomer::getCid).anyMatch(cid -> Objects.equals(a.getCid(), cid))).collect(Collectors.toList());
            customerLotDetails = customerLotDetails.stream().filter(item -> !finalTobeDelList.stream().map(ThirdGjOrgCustomerLotDetail::getCid).collect(Collectors.toList()).contains(item.getCid())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(finalTobeDelList)) {
                this.customerLotDetailService.removeByIds(tobeDelList);
            }
        }
        ArrayList<ThirdGjOrgCustomer> customers = new ArrayList<ThirdGjOrgCustomer>();
        if (CollectionUtils.isNotEmpty(customerLotDetails)) {
            for (ThirdGjOrgCustomerLotDetail detail : customerLotDetails) {
                ThirdGjOrgCustomer customer = new ThirdGjOrgCustomer();
                customer.setGjOrgId(lot.getGjOrgId());
                customer.setOrgId(lot.getOrgId());
                customer.setCid(detail.getCid());
                customer.setUnitName(detail.getUnitName());
                customer.setUnitCreditCode(detail.getUnitCreditCode());
                customer.setAreaId(detail.getAreaId());
                customer.setAreaId1(detail.getAreaId1());
                customer.setAreaId2(detail.getAreaId2());
                customer.setAreaId3(detail.getAreaId3());
                customer.setAreaId4(detail.getAreaId4());
                customer.setUnitAddress(detail.getAddress());
                customer.setBelongType(Byte.valueOf(detail.getBelongType().byteValue()));
                customer.setOrgMan(lot.getOrgMan());
                customer.setOrgTel(lot.getOrgTel());
                customer.setUnitMan(detail.getUnitMan());
                customer.setUnitTel(detail.getUnitTel());
                customer.setState(ThirdGjOrgCustomerStateEnum.sign.getValue());
                customer.setSignTime(detail.getSignTime());
                customer.setExpireTime(detail.getExpireTime());
                customer.setConcludeTime(new Date());
                customer.setSource(ThirdGjOrgCustomerSourceEnum.SUPERVISE.getValue());
                customer.setIsShowData(Integer.valueOf(1));
                this.orgCustomerService.initCustomerCheckStatusForAudit(customer);
                customers.add(customer);
            }
            this.orgCustomerService.updateCustomerIsShowData(customers.stream().map(ThirdGjOrgCustomer::getCid).collect(Collectors.toList()));
            this.orgCustomerService.saveBatch(customers);
            this.thirdGjCheckProviderToSupervise.addAutoCreateCheck(customers);
        }
        ArrayList auditLogs = new ArrayList();
        if (CollectionUtils.isNotEmpty(customers)) {
            customers.forEach(orgCustomer -> {
                ThirdGjOrgAuditLog log = new ThirdGjOrgAuditLog().setType(ThirdGjOrgAuditLogTypeEnum.third_gj_org_customer_sign.getValue()).setBusinessId(orgCustomer.getId()).setOptPeople(loginUser).setOpt(ThirdGjOrgAuditOptEnum.customer_sign_opt_2.getOptName());
                auditLogs.add(log);
            });
        }
        this.orgAuditLogService.saveBatch(auditLogs);
        return tobeDelList;
    }

    @Override
    public GjOrgAddCompDetailVo getGjOrgAddCompDetailVo(Long lotId) {
        ThirdGjOrgCustomerLot lot = (ThirdGjOrgCustomerLot)this.getById(lotId);
        if (lot == null) {
            return null;
        }
        GjOrgAddCompDetailVo detailVo = new GjOrgAddCompDetailVo();
        BeanUtils.copyProperties((Object)lot, (Object)detailVo);
        detailVo.setLotId(lotId);
        List<ThirdGjOrgCustomerLotDetail> lotDetails = this.customerLotDetailService.getListByLotId(lotId);
        if (CollectionUtils.isNotEmpty(lotDetails)) {
            detailVo.setCustomerLotDetails(lotDetails);
        }
        return detailVo;
    }

    @Override
    public Boolean del(Long id, Long loginUserId) {
        if (id == null) {
            return false;
        }
        this.removeById(id);
        this.customerLotDetailService.removeByLotId(id);
        return true;
    }

    @Generated
    public ThirdGjOrgCustomerLotServiceImpl(IThirdGjOrgService orgService, IThirdGjOrgAuditLogService orgAuditLogService, IThirdGjOrgCustomerService orgCustomerService, IThirdGjOrgCustomerLotDetailService customerLotDetailService, IThirdGjCheckProviderToSupervise thirdGjCheckProviderToSupervise) {
        this.orgService = orgService;
        this.orgAuditLogService = orgAuditLogService;
        this.orgCustomerService = orgCustomerService;
        this.customerLotDetailService = customerLotDetailService;
        this.thirdGjCheckProviderToSupervise = thirdGjCheckProviderToSupervise;
    }
}

