/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.service.sys.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.Digests;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.fwgj.dao.sys.ThirdGjUserMapper;
import cn.smarthse.fwgj.entity.sys.ThirdGjUser;
import cn.smarthse.fwgj.framework.Constant;
import cn.smarthse.fwgj.model.param.admin.OrgAuditListParam;
import cn.smarthse.fwgj.model.param.admin.OrgAuditTabStatisticsParam;
import cn.smarthse.fwgj.model.param.admin.OrgGjAddedAuditTabStatisticsParam;
import cn.smarthse.fwgj.model.param.admin.OrgGjAddedInfoAuditListParam;
import cn.smarthse.fwgj.model.param.admin.OrgGjAuditAgainListParam;
import cn.smarthse.fwgj.model.param.admin.OrgGjAuditAgainTabStatisticsParam;
import cn.smarthse.fwgj.model.param.admin.OrgGjForbiddenListParam;
import cn.smarthse.fwgj.model.param.admin.OrgGjStatisticsListParam;
import cn.smarthse.fwgj.model.param.admin.OrgGjStatisticsParam;
import cn.smarthse.fwgj.model.param.third.GjUserQueryParam;
import cn.smarthse.fwgj.model.vo.admin.OrgAuditStatisticsListAdminVo;
import cn.smarthse.fwgj.model.vo.admin.OrgAuditTabStatisticsAdminVo;
import cn.smarthse.fwgj.model.vo.admin.OrgGjAddedAuditTabStatisticsAdminVo;
import cn.smarthse.fwgj.model.vo.admin.OrgGjAdminVo;
import cn.smarthse.fwgj.model.vo.admin.OrgGjAuditAgainListAdminVo;
import cn.smarthse.fwgj.model.vo.admin.OrgGjAuditAgainTabStatisticsAdminVo;
import cn.smarthse.fwgj.model.vo.admin.OrgGjAuditListAdminVo;
import cn.smarthse.fwgj.model.vo.admin.OrgGjForbiddenListAdminVo;
import cn.smarthse.fwgj.model.vo.admin.OrgGjListAdminVo;
import cn.smarthse.fwgj.model.vo.third.ThirdGjUserVo;
import cn.smarthse.fwgj.service.sys.IThirdGjUserLogService;
import cn.smarthse.fwgj.service.sys.IThirdGjUserService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.shiro.crypto.hash.SimpleHash;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ThirdGjUserServiceImpl
extends ServiceImpl<ThirdGjUserMapper, ThirdGjUser>
implements IThirdGjUserService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThirdGjUserServiceImpl.class);
    private final IThirdGjUserLogService gjUserLogService;

    @Override
    public ThirdGjUser getUserById(Long gjUserId) {
        if (gjUserId == null) {
            return null;
        }
        ThirdGjUser user = (ThirdGjUser)this.getById(gjUserId);
        user.setPassword(null);
        user.setSalt(null);
        return user;
    }

    @Override
    public ThirdGjUser getUserByUsername(String username) {
        if (StringUtils.isEmpty((CharSequence)username)) {
            return null;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ThirdGjUser.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdGjUser::getUsername, (Object)SpringEncryptUtils.encrypt((String)username))).eq(ThirdGjUser::getIsValid, (Object)Constant.ACTIVE_YES)).last("LIMIT 1");
        return (ThirdGjUser)((ThirdGjUserMapper)this.baseMapper).selectOne((Wrapper)wrapper);
    }

    @Override
    public ThirdGjUser getUserByMobile(String mobile) {
        if (StringUtils.isEmpty((CharSequence)mobile)) {
            return null;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ThirdGjUser.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdGjUser::getMobile, (Object)SpringEncryptUtils.encrypt((String)mobile))).eq(ThirdGjUser::getIsValid, (Object)Constant.ACTIVE_YES)).last("LIMIT 1");
        return (ThirdGjUser)((ThirdGjUserMapper)this.baseMapper).selectOne((Wrapper)wrapper);
    }

    @Override
    public List<ThirdGjUser> getUserByMobile(List<String> mobileList) {
        if (CollectionUtils.isEmpty(mobileList)) {
            return null;
        }
        mobileList = mobileList.stream().map(SpringEncryptUtils::encrypt).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ThirdGjUser.class);
        ((LambdaQueryWrapper)wrapper.in(ThirdGjUser::getMobile, mobileList)).eq(ThirdGjUser::getIsValid, (Object)Constant.ACTIVE_YES);
        return ((ThirdGjUserMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public ThirdGjUser getUserByIdcard(String idcard) {
        if (StringUtils.isEmpty((CharSequence)idcard)) {
            return null;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ThirdGjUser.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdGjUser::getIdcard, (Object)SpringEncryptUtils.encrypt((String)idcard))).eq(ThirdGjUser::getIsValid, (Object)Constant.ACTIVE_YES)).last("LIMIT 1");
        return (ThirdGjUser)((ThirdGjUserMapper)this.baseMapper).selectOne((Wrapper)wrapper);
    }

    @Override
    public ThirdGjUser getUserByZlbUserId(String zlbUserId) {
        if (StringUtils.isEmpty((CharSequence)zlbUserId)) {
            return null;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ThirdGjUser.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdGjUser::getZlbUserId, (Object)zlbUserId)).eq(ThirdGjUser::getIsValid, (Object)Constant.ACTIVE_YES)).last("LIMIT 1");
        return (ThirdGjUser)((ThirdGjUserMapper)this.baseMapper).selectOne((Wrapper)wrapper);
    }

    @Override
    public boolean isExistsUsername(String username) {
        if (StringUtils.isEmpty((CharSequence)username)) {
            return false;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ThirdGjUser.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdGjUser::getUsername, (Object)SpringEncryptUtils.encrypt((String)username))).eq(ThirdGjUser::getIsValid, (Object)Constant.ACTIVE_YES)).select(new SFunction[]{ThirdGjUser::getUsername}).last("LIMIT 1");
        return ((ThirdGjUserMapper)this.baseMapper).selectOne((Wrapper)wrapper) != null;
    }

    @Override
    public boolean checkMobile(String mobile, Long gjUserId) {
        if (StringUtils.isEmpty((CharSequence)mobile)) {
            return true;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ThirdGjUser.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdGjUser::getMobile, (Object)SpringEncryptUtils.encrypt((String)mobile))).eq(ThirdGjUser::getIsValid, (Object)Constant.ACTIVE_YES)).select(new SFunction[]{ThirdGjUser::getId, ThirdGjUser::getMobile}).last("LIMIT 1");
        ThirdGjUser thirdGjUser = (ThirdGjUser)((ThirdGjUserMapper)this.baseMapper).selectOne((Wrapper)wrapper);
        return thirdGjUser == null || thirdGjUser.getId().equals(gjUserId);
    }

    @Override
    public boolean checkMobileWithOrgId(String mobile, Long orgId) {
        if (StringUtils.isEmpty((CharSequence)mobile)) {
            return true;
        }
        ThirdGjUser thirdGjUser = this.getUserByMobile(mobile);
        return thirdGjUser == null || this.gjUserLogService.getGjUserLog(thirdGjUser.getId(), orgId) == null;
    }

    @Override
    public boolean checkIdcard(String idcard, Long gjUserId) {
        if (StringUtils.isEmpty((CharSequence)idcard)) {
            return true;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ThirdGjUser.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdGjUser::getIdcard, (Object)SpringEncryptUtils.encrypt((String)idcard))).eq(ThirdGjUser::getIsValid, (Object)Constant.ACTIVE_YES)).select(new SFunction[]{ThirdGjUser::getId, ThirdGjUser::getIdcard}).last("LIMIT 1");
        ThirdGjUser thirdGjUser = (ThirdGjUser)((ThirdGjUserMapper)this.baseMapper).selectOne((Wrapper)wrapper);
        return thirdGjUser == null || thirdGjUser.getId().equals(gjUserId);
    }

    @Override
    public boolean checkIdcardWithOrgId(String idcard, Long orgId) {
        if (StringUtils.isEmpty((CharSequence)idcard)) {
            return true;
        }
        ThirdGjUser thirdGjUser = this.getUserByIdcard(idcard);
        return thirdGjUser == null || this.gjUserLogService.getGjUserLog(thirdGjUser.getId(), orgId) == null;
    }

    @Override
    public List<ThirdGjUserVo> getOrgGJInfoList(Long orgId, Integer state) {
        if (orgId == null) {
            return null;
        }
        return ((ThirdGjUserMapper)this.baseMapper).getOrgGjInfoList(orgId, state);
    }

    @Override
    public JqGridData<ThirdGjUserVo> getGjUserListData(GjUserQueryParam param) {
        param.setKeywordEn(param.getKeyword());
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<ThirdGjUserVo> list = ((ThirdGjUserMapper)this.baseMapper).getGjUserListData(param);
        return new JqGridData((Page)list, (JqGridParam)param);
    }

    @Override
    @Transactional
    public void bindZlbUserId(Long gjUserId, String zlbUserId) {
        ThirdGjUser user = (ThirdGjUser)this.getById(gjUserId);
        if (user == null) {
            log.warn("\u7ed1\u5b9azlbUserId\u5931\u8d25\uff0c\u8d26\u53f7\u4e0d\u5b58\u5728\uff01gjUserId\uff1a{}-zlbUserId\uff1a{}", (Object)gjUserId, (Object)zlbUserId);
            return;
        }
        if (!StringUtils.isEmpty((CharSequence)user.getZlbUserId())) {
            log.warn("\u7ed1\u5b9azlbUserId\u5931\u8d25\uff0c\u8d26\u53f7\u5df2\u7ed1\u5b9azlbUserId\uff01gjUserId\uff1a{}-zlbUserId\uff1a{}-existsZlbUserId\uff1a{}", new Object[]{gjUserId, zlbUserId, user.getZlbUserId()});
            return;
        }
        ThirdGjUser thirdGjUser = new ThirdGjUser();
        thirdGjUser.setId(gjUserId);
        thirdGjUser.setZlbUserId(zlbUserId);
        ((ThirdGjUserMapper)this.baseMapper).updateById(thirdGjUser);
    }

    @Override
    public JqGridData<OrgAuditStatisticsListAdminVo> getOrgAuditListForAdmin(OrgAuditListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new JqGridData((Page)((ThirdGjUserMapper)this.baseMapper).getOrgAuditList(param), (JqGridParam)param);
    }

    @Override
    public List<OrgAuditTabStatisticsAdminVo> getOrgAuditTabStatisticsForAdmin(OrgAuditTabStatisticsParam param) {
        return ((ThirdGjUserMapper)this.baseMapper).getOrgAuditTabStatisticsForAdmin(param);
    }

    @Override
    public JqGridData<OrgGjListAdminVo> getOrgGJStatisticsListForAdmin(OrgGjStatisticsListParam param) {
        List<OrgGjListAdminVo> orgNameList;
        param.setKeywordEn(param.getKeyword());
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<OrgGjListAdminVo> voList = ((ThirdGjUserMapper)this.baseMapper).getOrgGJStatisticsListForAdmin(param);
        if (!CollectionUtil.isEmpty(voList) && !CollectionUtil.isEmpty(orgNameList = ((ThirdGjUserMapper)this.baseMapper).getOrgGjOrgName(voList.stream().map(v -> v.getId()).collect(Collectors.toList())))) {
            Map<Long, OrgGjListAdminVo> orgNameMap = orgNameList.stream().collect(Collectors.toMap(v -> v.getId(), v -> v));
            for (OrgGjListAdminVo vo : voList) {
                if (!orgNameMap.containsKey(vo.getId())) continue;
                vo.setOrgName(orgNameMap.get(vo.getId()).getOrgName());
            }
        }
        return new JqGridData((Page)voList, (JqGridParam)param);
    }

    @Override
    public OrgGjAdminVo getOneOrgGJInfoStatisticsForAdmin(OrgGjStatisticsParam param) {
        List<OrgGjListAdminVo> orgNameList;
        OrgGjAdminVo vo = ((ThirdGjUserMapper)this.baseMapper).getOneOrgGJInfoStatisticsForAdmin(param);
        if (vo != null && !CollectionUtil.isEmpty(orgNameList = ((ThirdGjUserMapper)this.baseMapper).getOrgGjOrgName(Arrays.asList(param.getGjUserId())))) {
            vo.setOrgNames(orgNameList.get(0).getOrgName());
        }
        return vo;
    }

    @Override
    public JqGridData<OrgGjAuditListAdminVo> getOrgGjAddedInfoAuditListForAdmin(OrgGjAddedInfoAuditListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new JqGridData((Page)((ThirdGjUserMapper)this.baseMapper).getOrgGjAddedInfoAuditListForAdmin(param), (JqGridParam)param);
    }

    @Override
    public List<OrgGjAddedAuditTabStatisticsAdminVo> getOrgGjAddedAuditTabStatistics(OrgGjAddedAuditTabStatisticsParam param) {
        return ((ThirdGjUserMapper)this.baseMapper).getOrgGjAddedAuditTabStatistics(param);
    }

    @Override
    public JqGridData<OrgGjForbiddenListAdminVo> getOrgGjForbiddenListForAdmin(OrgGjForbiddenListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<OrgGjForbiddenListAdminVo> voList = ((ThirdGjUserMapper)this.baseMapper).getOrgGjForbiddenListForAdmin(param);
        if (CollectionUtil.isEmpty(voList)) {
            return new JqGridData((Page)voList, (JqGridParam)param);
        }
        List<Long> gjUserList = voList.stream().map(OrgGjForbiddenListAdminVo::getId).collect(Collectors.toList());
        List<OrgGjListAdminVo> performanceStatistics = ((ThirdGjUserMapper)this.baseMapper).getGjPerformanceStatisticsForAdmin(gjUserList);
        Map<Long, OrgGjListAdminVo> performanceStatisticsMap = performanceStatistics.stream().collect(Collectors.toMap(v -> v.getId(), v -> v));
        for (OrgGjForbiddenListAdminVo vo : voList) {
            if (!performanceStatisticsMap.containsKey(vo.getId())) continue;
            OrgGjListAdminVo performance = performanceStatisticsMap.get(vo.getId());
            vo.setCompanyTotalNum(performance.getCompanyTotalNum());
            vo.setCurrentYearCompanyTotalNum(performance.getCurrentYearCompanyTotalNum());
            vo.setCurrentYearRiskNum(performance.getCurrentYearRiskNum());
        }
        return new JqGridData((Page)voList, (JqGridParam)param);
    }

    @Override
    public JqGridData<OrgGjAuditAgainListAdminVo> getOrgGjAuditAgainList(OrgGjAuditAgainListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<OrgGjAuditAgainListAdminVo> voList = ((ThirdGjUserMapper)this.baseMapper).getOrgGjAuditAgainList(param);
        if (CollectionUtil.isEmpty(voList)) {
            return new JqGridData((Page)voList, (JqGridParam)param);
        }
        List<Long> gjUserList = voList.stream().map(OrgGjAuditAgainListAdminVo::getId).collect(Collectors.toList());
        List<OrgGjListAdminVo> performanceStatistics = ((ThirdGjUserMapper)this.baseMapper).getGjPerformanceStatisticsForAdmin(gjUserList);
        Map<Long, OrgGjListAdminVo> performanceStatisticsMap = performanceStatistics.stream().collect(Collectors.toMap(v -> v.getId(), v -> v));
        for (OrgGjAuditAgainListAdminVo vo : voList) {
            if (!performanceStatisticsMap.containsKey(vo.getId())) continue;
            OrgGjListAdminVo performance = performanceStatisticsMap.get(vo.getId());
            vo.setCompanyTotalNum(performance.getCompanyTotalNum());
            vo.setCurrentYearCompanyTotalNum(performance.getCurrentYearCompanyTotalNum());
            vo.setCurrentYearRiskNum(performance.getCurrentYearRiskNum());
        }
        return new JqGridData((Page)voList, (JqGridParam)param);
    }

    @Override
    public List<OrgGjAuditAgainTabStatisticsAdminVo> getOrgGjAuditAgainTabStatisticsForAdmin(OrgGjAuditAgainTabStatisticsParam param) {
        return ((ThirdGjUserMapper)this.baseMapper).getOrgGjAuditAgainTabStatisticsForAdmin(param);
    }

    @Override
    public void modifyPassword(Long userId, String newPassword) {
        if (userId == null) {
            throw new ServiceException("userId\u4e3a\u7a7a\uff01");
        }
        ThirdGjUser userById = (ThirdGjUser)this.getById(userId);
        ThirdGjUser thirdGjUser = new ThirdGjUser();
        String salt = Digests.salt();
        String encryptPassword = new SimpleHash("SHA-1", (Object)newPassword, (Object)salt, 1024).toHex();
        if (Objects.equals(encryptPassword, userById.getPassword())) {
            throw new ServiceException("\u65b0\u5bc6\u7801\u4e0e\u65e7\u5bc6\u7801\u4e0d\u80fd\u76f8\u540c\uff01");
        }
        if (org.springframework.util.DigestUtils.md5DigestAsHex((byte[])"Zyj@2022".getBytes()).equals(newPassword)) {
            throw new ServiceException("\u4e0d\u80fd\u4fee\u6539\u4e3a\u9ed8\u8ba4\u5bc6\u7801\uff01");
        }
        thirdGjUser.setId(userId);
        thirdGjUser.setSalt(salt);
        thirdGjUser.setPassword(encryptPassword);
        thirdGjUser.setIsDefaultPwd(Boolean.valueOf(false));
        thirdGjUser.setPwdUpdateTime(new Date());
        ((ThirdGjUserMapper)this.baseMapper).updateById(thirdGjUser);
    }

    @Override
    public void modifyPassword(Long userId, String oldPassword, String newPassword) {
        if (userId == null) {
            throw new ServiceException("userId\u4e3a\u7a7a\uff01");
        }
        ThirdGjUser user = (ThirdGjUser)this.getById(userId);
        String oldEncryptPassword = new SimpleHash("SHA-1", (Object)oldPassword, (Object)user.getSalt(), 1024).toHex();
        if (!oldEncryptPassword.equalsIgnoreCase(user.getPassword())) {
            throw new ServiceException("\u65e7\u5bc6\u7801\u9519\u8bef\uff01");
        }
        if (Objects.equals(oldPassword, newPassword)) {
            throw new ServiceException("\u65b0\u5bc6\u7801\u4e0e\u65e7\u5bc6\u7801\u4e0d\u80fd\u76f8\u540c\uff01");
        }
        if (org.springframework.util.DigestUtils.md5DigestAsHex((byte[])"Zyj@2022".getBytes()).equals(newPassword)) {
            throw new ServiceException("\u4e0d\u80fd\u4fee\u6539\u4e3a\u9ed8\u8ba4\u5bc6\u7801\uff01");
        }
        ThirdGjUser thirdGjUser = new ThirdGjUser();
        String salt = Digests.salt();
        String encryptPassword = new SimpleHash("SHA-1", (Object)newPassword, (Object)salt, 1024).toHex();
        thirdGjUser.setId(userId);
        thirdGjUser.setSalt(salt);
        thirdGjUser.setPassword(encryptPassword);
        thirdGjUser.setIsDefaultPwd(Boolean.valueOf(false));
        thirdGjUser.setPwdUpdateTime(new Date());
        ((ThirdGjUserMapper)this.baseMapper).updateById(thirdGjUser);
    }

    @Override
    @Transactional
    public void resetPassword(Long gjUserId) {
        ThirdGjUser thirdGjUser = new ThirdGjUser();
        String salt = Digests.salt();
        String md5Password = DigestUtils.md5Hex((byte[])"Zyj@2022".getBytes());
        String encryptPassword = new SimpleHash("SHA-1", (Object)md5Password, (Object)salt, 1024).toHex();
        thirdGjUser.setId(gjUserId);
        thirdGjUser.setSalt(salt);
        thirdGjUser.setPassword(encryptPassword);
        thirdGjUser.setIsDefaultPwd(Boolean.valueOf(true));
        thirdGjUser.setPwdUpdateTime(new Date());
        ((ThirdGjUserMapper)this.baseMapper).updateById(thirdGjUser);
    }

    @Generated
    public ThirdGjUserServiceImpl(IThirdGjUserLogService gjUserLogService) {
        this.gjUserLogService = gjUserLogService;
    }
}

