/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.provider.third;

import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.PhoneUtil;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.util.Digests;
import cn.smarthse.fwgj.dao.CompanyMapper;
import cn.smarthse.fwgj.dao.ReformItemBasicMapper;
import cn.smarthse.fwgj.dao.thirdGj.ThirdGjOrgMapper;
import cn.smarthse.fwgj.dao.thirdGj.ThirdOrgMapper;
import cn.smarthse.fwgj.entity.sys.ThirdGjUser;
import cn.smarthse.fwgj.entity.sys.ThirdGjUserLog;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrg;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgAuditLog;
import cn.smarthse.fwgj.enums.ThirdGjOrgAuditLogTypeEnum;
import cn.smarthse.fwgj.enums.ThirdGjOrgAuditOptEnum;
import cn.smarthse.fwgj.enums.ThirdGjOrgStateEnums;
import cn.smarthse.fwgj.enums.ThirdGjUserLogForbiddenStateEnum;
import cn.smarthse.fwgj.enums.ThirdGjUserLogStateEnums;
import cn.smarthse.fwgj.framework.Constant;
import cn.smarthse.fwgj.model.param.company.GjOrjSearchParam;
import cn.smarthse.fwgj.model.param.third.GjOrgParamParam;
import cn.smarthse.fwgj.model.param.third.GjOrgSummitParam;
import cn.smarthse.fwgj.model.param.third.GjUserAddParam;
import cn.smarthse.fwgj.model.param.third.GjUserQueryParam;
import cn.smarthse.fwgj.model.vo.admin.GjOrgListAdminVo;
import cn.smarthse.fwgj.model.vo.admin.GjOrgServiceAreaStatisticsVo;
import cn.smarthse.fwgj.model.vo.company.CompanyGjOrjListVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgListVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgUserVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgVo;
import cn.smarthse.fwgj.model.vo.third.GjUserForbiddenStateStatistics;
import cn.smarthse.fwgj.model.vo.third.GjUserStateStatistics;
import cn.smarthse.fwgj.model.vo.third.GjUserStatisticsVo;
import cn.smarthse.fwgj.model.vo.third.OrgInfoForSignVo;
import cn.smarthse.fwgj.model.vo.third.ThirdGjUserVo;
import cn.smarthse.fwgj.model.vo.third.ThirdOrganizationVo;
import cn.smarthse.fwgj.provider.third.IThirdGjOrgProviderService;
import cn.smarthse.fwgj.service.sys.IThirdGjUserLogService;
import cn.smarthse.fwgj.service.sys.IThirdGjUserService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjCheckInfoService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjOrgAuditLogService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjOrgService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.platform.model.AreaModel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.shiro.crypto.hash.SimpleHash;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@DubboService
public class ThirdGjOrgProviderToThird
implements IThirdGjOrgProviderService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThirdGjOrgProviderToThird.class);
    private final IThirdGjOrgService thirdGjOrgService;
    private final IThirdGjUserService thirdGjUserService;
    private final IThirdGjUserLogService thirdGjUserLogService;
    private final IThirdGjOrgAuditLogService thirdGjOrgAuditLogService;
    private final IThirdGjCheckInfoService thirdGjCheckInfoService;
    private final ThirdOrgMapper thirdOrgMapper;
    private final ThirdGjOrgMapper gjOrgMapper;
    private final ReformItemBasicMapper reformItemBasicMapper;
    private final CompanyMapper companyMapper;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaProvideService;

    public JqGridData<GjOrgListVo> getGjOrgListData(GjOrgParamParam param) {
        return this.thirdGjOrgService.getGjOrgListData(param);
    }

    public GjOrgVo getGjOrg(Long gjOrgId) {
        return this.thirdGjOrgService.getGjOrg(gjOrgId);
    }

    public GjOrgVo getLastGjOrg(Long orgId) {
        return this.thirdGjOrgService.getLastGjOrg(orgId);
    }

    public boolean isExistsGjOrg(Long orgId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ThirdGjOrg.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdGjOrg::getOrgId, (Object)orgId)).eq(ThirdGjOrg::getState, (Object)ThirdGjOrgStateEnums.PASS.getValue())).eq(ThirdGjOrg::getIsValid, (Object)Constant.ACTIVE_YES);
        return this.thirdGjOrgService.count((Wrapper)wrapper) > 0L;
    }

    public List<ThirdGjUserVo> getGjUserList(Long orgId) {
        return this.thirdGjUserService.getOrgGJInfoList(orgId, null);
    }

    public JqGridData<ThirdGjUserVo> getGjUserListData(GjUserQueryParam param) {
        if (param.getOrgId() == null) {
            return new JqGridData();
        }
        JqGridData<ThirdGjUserVo> data = this.thirdGjUserService.getGjUserListData(param);
        List rows = data.getRows();
        if (!CollectionUtils.isEmpty((Collection)rows)) {
            List<GjUserStatisticsVo> checkList = this.thirdGjCheckInfoService.getCheckStatistics(rows.stream().map(ThirdGjUserVo::getId).collect(Collectors.toList()), null);
            Map<Long, GjUserStatisticsVo> checkMap = CollectionUtils.isEmpty(checkList) ? null : checkList.stream().collect(Collectors.toMap(GjUserStatisticsVo::getGroupBy, item -> item));
            List<GjUserStatisticsVo> reformList = this.reformItemBasicMapper.getReformStatisticsByFinder(rows.stream().map(ThirdGjUserVo::getId).collect(Collectors.toList()), null);
            Map<Long, GjUserStatisticsVo> reformMap = CollectionUtils.isEmpty(reformList) ? null : reformList.stream().collect(Collectors.toMap(GjUserStatisticsVo::getGroupBy, item -> item));
            rows.forEach(record -> {
                GjUserStatisticsVo reform;
                GjUserStatisticsVo check;
                GjUserStatisticsVo gjUserStatisticsVo = new GjUserStatisticsVo();
                record.setGjUserStatisticsVo(gjUserStatisticsVo);
                if (checkMap != null && (check = (GjUserStatisticsVo)checkMap.get(record.getId())) != null) {
                    gjUserStatisticsVo.setGjCheckInfoNum(check.getGjCheckInfoNum());
                    gjUserStatisticsVo.setCurrGjCheckInfoNum(check.getCurrGjCheckInfoNum());
                }
                if (reformMap != null && (reform = (GjUserStatisticsVo)reformMap.get(record.getId())) != null) {
                    gjUserStatisticsVo.setCurrRiskNum(reform.getCurrRiskNum());
                    gjUserStatisticsVo.setUnRiskNum(reform.getUnRiskNum());
                }
            });
        }
        return data;
    }

    public ThirdGjUser getGjUserById(Long gjUserId) {
        return this.thirdGjUserService.getUserById(gjUserId);
    }

    public GjOrgUserVo getGjUser(Long gjUserLogId) {
        GjOrgUserVo result = new GjOrgUserVo();
        ThirdGjUserLog gjUserLog = (ThirdGjUserLog)this.thirdGjUserLogService.getById(gjUserLogId);
        if (gjUserLog != null) {
            result.setGjUser(this.thirdGjUserService.getUserById(gjUserLog.getGjUserId()));
            List<GjOrgListAdminVo> gjOrgList = this.thirdGjUserLogService.getGjOrgList(gjUserLog.getGjUserId());
            if (!CollectionUtils.isEmpty(gjOrgList)) {
                result.setThirdGjOrgNames(gjOrgList.stream().map(GjOrgListAdminVo::getOrgName).collect(Collectors.joining("\u3001")));
            }
            result.setThirdGjOrgNames(this.thirdGjUserLogService.getOrgNames(gjUserLog.getGjUserId()));
            result.setGjUserLog(gjUserLog);
            result.setGjUserStatistics(this.thirdGjCheckInfoService.getCheckStatistics(gjUserLog.getGjUserId(), null));
        }
        return result;
    }

    public ThirdGjUserLog getGjUserLog(Long gjUserLogId) {
        return (ThirdGjUserLog)this.thirdGjUserLogService.getById(gjUserLogId);
    }

    public boolean checkGjUserLog(Long gjUserLogId, Long orgId) {
        return this.thirdGjUserLogService.checkGjUserLog(gjUserLogId, orgId);
    }

    public boolean checkGjUserLog(List<Long> gjUserLogIdList, Long orgId) {
        return this.thirdGjUserLogService.checkGjUserLog(gjUserLogIdList, orgId);
    }

    public boolean checkGjUser(Long gjUserId, Long orgId) {
        return this.thirdGjUserLogService.checkGjUser(gjUserId, orgId);
    }

    @Transactional
    public Long addSubmitGjOrg(GjOrgSummitParam param) {
        ThirdGjOrg gjOrg = new ThirdGjOrg();
        ThirdGjOrg exists = this.thirdGjOrgService.getByAreaId(param.getOrgId(), param.getAreaId());
        if (exists != null) {
            throw new ServiceException("\u8be5\u884c\u653f\u533a\u5212\u7684\u5907\u6848\u5df2\u5b58\u5728\uff01");
        }
        ThirdOrganizationVo thirdOrganization = this.thirdOrgMapper.getThirdOrganization(param.getOrgId());
        if (thirdOrganization != null) {
            gjOrg.setOrgName(thirdOrganization.getName());
            gjOrg.setOrgCreditCode(thirdOrganization.getCreditCode());
            gjOrg.setAddress(StringUtils.join((Object[])new String[]{thirdOrganization.getProvinceName(), thirdOrganization.getCityName(), thirdOrganization.getAreaName(), thirdOrganization.getAddress()}));
        }
        gjOrg.setOrgId(param.getOrgId());
        gjOrg.setUserId(param.getUserId());
        gjOrg.setApplyFile(param.getApplyFile());
        gjOrg.setCommitmentFile(param.getCommitmentFile());
        gjOrg.setBusLicenseFile(param.getBusLicenseFile());
        gjOrg.setAreaId(param.getAreaId());
        gjOrg.setState(ThirdGjOrgStateEnums.PENDING_AUDIT.getValue());
        gjOrg.setSubTime(new Date());
        AreaModel area = this.areaProvideService.getAreaById(param.getAreaId());
        if (area != null) {
            if (area.getLevel() == 1) {
                gjOrg.setBaName(area.getProvinceName());
            } else if (area.getLevel() == 2) {
                gjOrg.setBaName(area.getCityName() + "\u5e02\u672c\u7ea7");
            } else {
                gjOrg.setBaName((area.getCityName() != null ? area.getCityName() : "") + (area.getAreaName() != null ? area.getAreaName() : ""));
            }
            gjOrg.setLevel(Integer.valueOf(area.getLevel().intValue()));
            gjOrg.setAreaId1(area.getProvinceId());
            gjOrg.setAreaId2(area.getCityId());
            gjOrg.setAreaId3(area.getAreaId());
        }
        this.thirdGjOrgService.save(gjOrg);
        this.thirdGjUserLogService.updateState1(param.getOrgId());
        this.thirdGjOrgAuditLogService.save(new ThirdGjOrgAuditLog().setType(ThirdGjOrgAuditLogTypeEnum.third_gj_org.getValue()).setBusinessId(gjOrg.getId()).setOpt(ThirdGjOrgAuditOptEnum.org_opt_1.getOptName()).setOptValue(ThirdGjOrgAuditOptEnum.org_opt_1.getOptValue()).setOptPeople(this.getOrgName(param.getOrgId())));
        return gjOrg.getOrgId();
    }

    @Transactional
    public void updateSubmitGjOrg(GjOrgSummitParam param) {
        ThirdGjOrg record = (ThirdGjOrg)this.thirdGjOrgService.getById(param.getGjOrgId());
        if (!ThirdGjOrgStateEnums.DRAFT.getValue().equals(record.getState()) && !ThirdGjOrgStateEnums.RETURNED.getValue().equals(record.getState())) {
            throw new ServiceException("\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u63d0\u4ea4\u5ba1\u6838\uff01");
        }
        ThirdGjOrg gjOrg = new ThirdGjOrg();
        ThirdOrganizationVo thirdOrganization = this.thirdOrgMapper.getThirdOrganization(param.getOrgId());
        if (thirdOrganization != null) {
            gjOrg.setOrgName(thirdOrganization.getName());
            gjOrg.setOrgCreditCode(thirdOrganization.getCreditCode());
            gjOrg.setAddress(StringUtils.join((Object[])new String[]{thirdOrganization.getProvinceName(), thirdOrganization.getCityName(), thirdOrganization.getAreaName(), thirdOrganization.getAddress()}));
        }
        gjOrg.setId(param.getGjOrgId());
        gjOrg.setApplyFile(param.getApplyFile());
        gjOrg.setCommitmentFile(param.getCommitmentFile());
        gjOrg.setBusLicenseFile(param.getBusLicenseFile());
        gjOrg.setAreaId(param.getAreaId());
        gjOrg.setState(ThirdGjOrgStateEnums.PENDING_AUDIT.getValue());
        AreaModel area = this.areaProvideService.getAreaById(param.getAreaId());
        if (area != null) {
            if (area.getLevel() == 1) {
                gjOrg.setBaName(area.getProvinceName());
            } else if (area.getLevel() == 2) {
                gjOrg.setBaName(area.getCityName() + "\u5e02\u672c\u7ea7");
            } else {
                gjOrg.setBaName((area.getCityName() != null ? area.getCityName() : "") + (area.getAreaName() != null ? area.getAreaName() : ""));
            }
            gjOrg.setLevel(Integer.valueOf(area.getLevel().intValue()));
            gjOrg.setAreaId1(area.getProvinceId());
            gjOrg.setAreaId2(area.getCityId());
            gjOrg.setAreaId3(area.getAreaId());
        }
        this.thirdGjOrgService.saveOrUpdate(gjOrg);
        this.thirdGjUserLogService.updateState1(record.getOrgId());
        this.thirdGjOrgAuditLogService.save(new ThirdGjOrgAuditLog().setType(ThirdGjOrgAuditLogTypeEnum.third_gj_org.getValue()).setBusinessId(gjOrg.getId()).setOpt(ThirdGjOrgAuditOptEnum.org_opt_1.getOptName()).setOptValue(ThirdGjOrgAuditOptEnum.org_opt_1.getOptValue()).setOptPeople(this.getOrgName(param.getOrgId())));
    }

    @Transactional
    public void addGjUser(GjUserAddParam param) {
        if (!PhoneUtil.isMobile((CharSequence)param.getMobile())) {
            throw new ServiceException("\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef\u4e3a\u7a7a\uff01");
        }
        if (!this.thirdGjUserService.checkMobileWithOrgId(param.getMobile(), param.getOrgId())) {
            throw new ServiceException("\u624b\u673a\u53f7\u5df2\u5b58\u5728\uff01");
        }
        if (!this.thirdGjUserService.checkIdcardWithOrgId(param.getIdcard(), param.getOrgId())) {
            throw new ServiceException("\u8eab\u4efd\u8bc1\u5df2\u5b58\u5728\uff01");
        }
        ThirdGjUser thirdGjUser = new ThirdGjUser();
        ThirdGjUser exists = this.thirdGjUserService.getUserByIdcard(param.getIdcard());
        if (exists != null) {
            thirdGjUser.setId(exists.getId());
        }
        thirdGjUser.setFullname(param.getFullname());
        thirdGjUser.setSex(param.getSex());
        thirdGjUser.setBirthday(param.getBirthday());
        thirdGjUser.setWorkYear(param.getWorkYear());
        thirdGjUser.setPost(param.getPost());
        thirdGjUser.setEdu(param.getEdu());
        thirdGjUser.setMobile(param.getMobile());
        thirdGjUser.setIdcard(param.getIdcard());
        if (thirdGjUser.getId() == null) {
            thirdGjUser.setUsername("gj" + System.currentTimeMillis());
            String salt = Digests.salt();
            String md5Password = DigestUtils.md5Hex((byte[])"Zyj@2022".getBytes());
            String encryptPassword = new SimpleHash("SHA-1", (Object)md5Password, (Object)salt, 1024).toHex();
            thirdGjUser.setSalt(salt);
            thirdGjUser.setPassword(encryptPassword);
        }
        try {
            this.thirdGjUserService.saveOrUpdate(thirdGjUser);
        }
        catch (DuplicateKeyException e) {
            throw new ServiceException("\u624b\u673a\u53f7\u6216\u8eab\u4efd\u8bc1\u5df2\u5b58\u5728\uff01");
        }
        ThirdGjUserLog thirdGjUserLog = new ThirdGjUserLog();
        thirdGjUserLog.setUserId(param.getUserId());
        thirdGjUserLog.setOrgId(param.getOrgId());
        thirdGjUserLog.setGjUserId(thirdGjUser.getId());
        thirdGjUserLog.setState(ThirdGjUserLogStateEnums.PENDING_AUDIT.getValue());
        thirdGjUserLog.setForbiddenState(ThirdGjUserLogForbiddenStateEnum.PASS.getValue());
        thirdGjUserLog.setSubTime(new Date());
        thirdGjUserLog.setCreateBy(param.getUserId());
        this.thirdGjUserLogService.saveOrUpdate(thirdGjUserLog);
    }

    @Transactional
    public void updateGjUser(ThirdGjUser param) {
        if (!this.thirdGjUserService.checkMobile(param.getMobile(), param.getId())) {
            throw new ServiceException("\u624b\u673a\u53f7\u5df2\u5b58\u5728\uff01");
        }
        if (!this.thirdGjUserService.checkIdcard(param.getIdcard(), param.getId())) {
            throw new ServiceException("\u8eab\u4efd\u8bc1\u5df2\u5b58\u5728\uff01");
        }
        ThirdGjUser thirdGjUser = new ThirdGjUser();
        thirdGjUser.setId(param.getId());
        thirdGjUser.setFullname(param.getFullname());
        thirdGjUser.setSex(param.getSex());
        thirdGjUser.setBirthday((Date)IdcardUtil.getBirthDate((String)param.getIdcard()));
        thirdGjUser.setPost(param.getPost());
        thirdGjUser.setEdu(param.getEdu());
        thirdGjUser.setMobile(param.getMobile());
        thirdGjUser.setIdcard(param.getIdcard());
        thirdGjUser.setWorkYear(param.getWorkYear());
        this.thirdGjUserService.updateById(thirdGjUser);
    }

    public List<String> importGjUser(List<GjUserAddParam> list) {
        ArrayList<String> errMsgList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            GjUserAddParam param = list.get(i);
            if (StringUtils.isBlank((CharSequence)param.getMobile())) {
                errMsgList.add(String.format("\u7b2c%s\u884c\uff0c\u624b\u673a\u53f7\u4e3a\u7a7a\uff01", i + 2));
            }
            if (StringUtils.isBlank((CharSequence)param.getIdcard())) {
                errMsgList.add(String.format("\u7b2c%s\u884c\uff0c\u8eab\u4efd\u8bc1\u4e3a\u7a7a\uff01", i + 2));
            }
            if (!PhoneUtil.isMobile((CharSequence)param.getMobile())) {
                errMsgList.add(String.format("\u7b2c%s\u884c\uff0c\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef\u4e3a\u7a7a\uff01", i + 2));
            }
            if (!this.thirdGjUserService.checkMobileWithOrgId(param.getMobile(), param.getOrgId())) {
                errMsgList.add(String.format("\u7b2c%s\u884c\uff0c\u624b\u673a\u53f7\u5df2\u5b58\u5728\uff01", i + 2));
            }
            if (this.thirdGjUserService.checkIdcardWithOrgId(param.getIdcard(), param.getOrgId())) continue;
            errMsgList.add(String.format("\u7b2c%s\u884c\uff0c\u8eab\u4efd\u8bc1\u5df2\u5b58\u5728\uff01", i + 2));
        }
        if (!CollectionUtils.isEmpty(errMsgList)) {
            return errMsgList;
        }
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(this::addGjUser);
        }
        return null;
    }

    @Transactional
    public void submitGjUser(ThirdGjUser param) {
        if (!this.thirdGjUserService.checkMobile(param.getMobile(), param.getId())) {
            throw new ServiceException("\u624b\u673a\u53f7\u5df2\u88ab\u5176\u4ed6\u8d26\u53f7\u7ed1\u5b9a\uff01");
        }
        if (!this.thirdGjUserService.checkIdcard(param.getIdcard(), param.getId())) {
            throw new ServiceException("\u8eab\u4efd\u8bc1\u5df2\u88ab\u5176\u4ed6\u8d26\u53f7\u7ed1\u5b9a\uff01");
        }
        ThirdGjUser thirdGjUser = new ThirdGjUser();
        thirdGjUser.setId(param.getId());
        thirdGjUser.setFullname(param.getFullname());
        thirdGjUser.setSex(param.getSex());
        thirdGjUser.setBirthday((Date)IdcardUtil.getBirthDate((String)param.getIdcard()));
        thirdGjUser.setPost(param.getPost());
        thirdGjUser.setEdu(param.getEdu());
        thirdGjUser.setMobile(param.getMobile());
        thirdGjUser.setIdcard(param.getIdcard());
        this.thirdGjUserService.updateById(thirdGjUser);
        ThirdGjUserLog record = (ThirdGjUserLog)this.thirdGjUserLogService.getById(param.getGjUserLogId());
        if (record == null) {
            throw new ServiceException("\u6570\u636eThirdGjUserLog\u7f3a\u5931\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        if (!ThirdGjUserLogStateEnums.DRAFT.getValue().equals(record.getState()) && !ThirdGjUserLogStateEnums.REFUED.getValue().equals(record.getState())) {
            throw new ServiceException("\u5f53\u524d\u72b6\u6001\u7684\u8d26\u53f7\u4e0d\u53ef\u64cd\u4f5c\uff01");
        }
        ThirdGjUserLog thirdGjUserLog = new ThirdGjUserLog();
        thirdGjUserLog.setId(param.getGjUserLogId());
        thirdGjUserLog.setState(ThirdGjUserLogStateEnums.PENDING_AUDIT.getValue());
        thirdGjUserLog.setSubTime(new Date());
        this.thirdGjUserLogService.updateById(thirdGjUserLog);
    }

    @Transactional
    public void updateForbiddenState(Long gjUserlogId, Integer forbiddenState) {
        ThirdGjUserLog record = (ThirdGjUserLog)this.thirdGjUserLogService.getById(gjUserlogId);
        if (record == null) {
            throw new ServiceException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01");
        }
        ThirdGjUserLog thirdGjUserLog = new ThirdGjUserLog();
        thirdGjUserLog.setId(gjUserlogId);
        thirdGjUserLog.setForbiddenState(forbiddenState);
        ThirdGjOrgAuditOptEnum optEnum = null;
        if (ThirdGjUserLogForbiddenStateEnum.Forbidden.getValue().equals(forbiddenState)) {
            thirdGjUserLog.setForbiddenDate(new Date());
            optEnum = ThirdGjOrgAuditOptEnum.user_log_opt_4;
        } else if (ThirdGjUserLogForbiddenStateEnum.PENDING_AUDIT.getValue().equals(forbiddenState)) {
            thirdGjUserLog.setSubTime(new Date());
            optEnum = ThirdGjOrgAuditOptEnum.user_log_opt_1;
        }
        this.thirdGjUserLogService.updateById(thirdGjUserLog);
        this.thirdGjOrgAuditLogService.save(new ThirdGjOrgAuditLog().setType(ThirdGjOrgAuditLogTypeEnum.third_gj_user_log.getValue()).setBusinessId(gjUserlogId).setOpt(optEnum.getOptName()).setOptValue(optEnum.getOptValue()).setOptPeople(this.getOrgName(record.getOrgId())));
    }

    @Transactional
    public void updateForbiddenState(List<Long> gjUserlogIdList, Integer forbiddenState) {
        if (!CollectionUtils.isEmpty(gjUserlogIdList)) {
            gjUserlogIdList.forEach(gjUserlogId -> this.updateForbiddenState((Long)gjUserlogId, forbiddenState));
        }
    }

    @Transactional
    public void updateState(Long gjUserlogId, Integer state) {
        ThirdGjUserLog record = (ThirdGjUserLog)this.thirdGjUserLogService.getById(gjUserlogId);
        if (record == null) {
            throw new ServiceException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01");
        }
        ThirdGjUserLog thirdGjUserLog = new ThirdGjUserLog();
        thirdGjUserLog.setId(gjUserlogId);
        thirdGjUserLog.setState(state);
        if (ThirdGjUserLogStateEnums.PENDING_AUDIT.getValue().equals(state)) {
            thirdGjUserLog.setSubTime(new Date());
        }
        if (ThirdGjUserLogStateEnums.PASS.getValue().equals(state) || ThirdGjUserLogStateEnums.REFUED.getValue().equals(state) || ThirdGjUserLogStateEnums.STOP.getValue().equals(state)) {
            // empty if block
        }
        this.thirdGjUserLogService.updateById(thirdGjUserLog);
    }

    public GjUserStateStatistics getGjUserStateStatistics(Long orgId) {
        return this.thirdGjUserLogService.getGjUserStateStatistics(orgId);
    }

    public GjUserForbiddenStateStatistics getGjUserForbiddenStateStatistics(Long orgId) {
        return this.thirdGjUserLogService.getGjUserForbiddenStateStatistics(orgId);
    }

    public JqGridData<CompanyGjOrjListVo> listOrjByCompanyAreaId(GjOrjSearchParam param) {
        if (param.getAreaId() == null) {
            return null;
        }
        Byte belongType = this.companyMapper.getBelongType(param.getCid());
        if (belongType == null) {
            return null;
        }
        param.setBelongType(Integer.valueOf(belongType.intValue()));
        return this.thirdGjOrgService.listOrjByCompanyAreaId(param);
    }

    public OrgInfoForSignVo getOrjInfoForSign(Long orgId) {
        ThirdOrganizationVo org = this.thirdOrgMapper.getThirdOrganization(orgId);
        if (org == null) {
            return null;
        }
        return new OrgInfoForSignVo(org.getName(), org.getAddress(), org.getCreditCode());
    }

    public List<GjOrgServiceAreaStatisticsVo> getGjOrjCompanyAreaList(Long orgId) {
        if (orgId == null) {
            return null;
        }
        List<ThirdGjOrg> gjOrgList = this.thirdGjOrgService.getGjOrgList(orgId);
        if (CollectionUtils.isEmpty(gjOrgList)) {
            return null;
        }
        ArrayList<GjOrgServiceAreaStatisticsVo> resultList = new ArrayList<GjOrgServiceAreaStatisticsVo>();
        resultList.add(new GjOrgServiceAreaStatisticsVo(null, "\u5168\u90e8\u4f01\u4e1a", this.gjOrgMapper.getGjOrgServiceAreaUnitNum(null, null, orgId)));
        gjOrgList.sort(Comparator.comparingInt(ThirdGjOrg::getLevel));
        gjOrgList.forEach(gjOrg -> {
            GjOrgServiceAreaStatisticsVo statisticsVo = new GjOrgServiceAreaStatisticsVo();
            int unitNum = this.gjOrgMapper.getGjOrgServiceAreaUnitNum(gjOrg.getAreaId(), gjOrg.getLevel(), orgId);
            statisticsVo.setGjOrgId(gjOrg.getId());
            statisticsVo.setAreaId(gjOrg.getAreaId());
            statisticsVo.setLevel(gjOrg.getLevel());
            statisticsVo.setBaName(gjOrg.getBaName());
            statisticsVo.setBelongType(Integer.valueOf(gjOrg.getLevel() == 1 ? 1 : (gjOrg.getLevel() == 2 ? 2 : 0)));
            statisticsVo.setUnitNum(Integer.valueOf(unitNum));
            resultList.add(statisticsVo);
        });
        return resultList;
    }

    public void resetPassword(Long gjUserId) {
        this.thirdGjUserService.resetPassword(gjUserId);
    }

    private String getOrgName(Long orgId) {
        ThirdOrganizationVo org = this.thirdOrgMapper.getThirdOrganization(orgId);
        return org != null ? org.getName() : null;
    }

    @Generated
    public ThirdGjOrgProviderToThird(IThirdGjOrgService thirdGjOrgService, IThirdGjUserService thirdGjUserService, IThirdGjUserLogService thirdGjUserLogService, IThirdGjOrgAuditLogService thirdGjOrgAuditLogService, IThirdGjCheckInfoService thirdGjCheckInfoService, ThirdOrgMapper thirdOrgMapper, ThirdGjOrgMapper gjOrgMapper, ReformItemBasicMapper reformItemBasicMapper, CompanyMapper companyMapper) {
        this.thirdGjOrgService = thirdGjOrgService;
        this.thirdGjUserService = thirdGjUserService;
        this.thirdGjUserLogService = thirdGjUserLogService;
        this.thirdGjOrgAuditLogService = thirdGjOrgAuditLogService;
        this.thirdGjCheckInfoService = thirdGjCheckInfoService;
        this.thirdOrgMapper = thirdOrgMapper;
        this.gjOrgMapper = gjOrgMapper;
        this.reformItemBasicMapper = reformItemBasicMapper;
        this.companyMapper = companyMapper;
    }
}

