/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.provider.third;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.fwgj.converter.GjOrgCustomerConverter;
import cn.smarthse.fwgj.dao.CompanyMapper;
import cn.smarthse.fwgj.dao.thirdGj.ThirdOrgMapper;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrg;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgAuditLog;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgCustomer;
import cn.smarthse.fwgj.enums.ThirdGjOrgAuditLogTypeEnum;
import cn.smarthse.fwgj.enums.ThirdGjOrgAuditOptEnum;
import cn.smarthse.fwgj.enums.ThirdGjOrgCustomerSourceEnum;
import cn.smarthse.fwgj.enums.ThirdGjOrgCustomerStateEnum;
import cn.smarthse.fwgj.enums.ThirdGjOrgCustomerTypeEnum;
import cn.smarthse.fwgj.model.param.company.CompanyCustomerSearchParam;
import cn.smarthse.fwgj.model.param.third.GjOrgCompanyQueryParam;
import cn.smarthse.fwgj.model.param.third.GjOrgCustomerAddParam;
import cn.smarthse.fwgj.model.vo.admin.GjOrgSignCompHistoryVo;
import cn.smarthse.fwgj.model.vo.company.CompanyAreaChangedVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgCheckStatisticVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgCompanyAreaVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgCompanyListVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgCustomerChooseCompanyVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgCustomerStatisticVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgCustomerVo;
import cn.smarthse.fwgj.model.vo.third.ThirdOrganizationVo;
import cn.smarthse.fwgj.provider.third.IThirdGjOrgCustomerProviderService;
import cn.smarthse.fwgj.service.sys.IThirdGjUserLogService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjOrgAuditLogService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjOrgCustomerService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjOrgService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.platform.model.AreaModel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@DubboService
public class ThirdGjOrgCustomerProviderToThird
implements IThirdGjOrgCustomerProviderService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThirdGjOrgCustomerProviderToThird.class);
    private final IThirdGjOrgService thirdGjOrgService;
    private final IThirdGjUserLogService thirdGjUserLogService;
    private final IThirdGjOrgAuditLogService thirdGjOrgAuditLogService;
    private final IThirdGjOrgCustomerService gjOrgCustomerService;
    private final ThirdOrgMapper thirdOrgMapper;
    private final CompanyMapper companyMapper;
    private final GjOrgCustomerConverter gjOrgCustomerConverter;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;

    public GjOrgCheckStatisticVo getGjOrjCheckStatistic(Long orgId) {
        if (orgId == null) {
            return null;
        }
        GjOrgCheckStatisticVo rst = this.gjOrgCustomerService.getGjOrjCheckStatistic(orgId);
        rst.setScoreList(this.thirdGjOrgService.getScoreListByOrgId(orgId));
        rst.setGjUserNum(Integer.valueOf(this.thirdGjUserLogService.getGjUserNumByOrgId(orgId)));
        rst.setSignedCompanyNum(Integer.valueOf(this.gjOrgCustomerService.getSignedCompanyNumByOrgId(orgId)));
        rst.setOverDueNum(Integer.valueOf(this.gjOrgCustomerService.getOverDueCompanyNumByOrgId(orgId, 2)));
        rst.setNeedCheckNum(Integer.valueOf(this.gjOrgCustomerService.getNeedCheckCompanyNumByOrgId(orgId)));
        rst.setNearDueNum(Integer.valueOf(this.gjOrgCustomerService.getNearDueCompanyNumByOrgId(orgId)));
        return rst;
    }

    public List<GjOrgCompanyAreaVo> getGjOrjCompanyAreaList(Long orgId) {
        if (orgId == null) {
            return null;
        }
        return this.gjOrgCustomerService.getGjOrjCompanyAreaList(orgId);
    }

    public JqGridData<GjOrgCompanyListVo> getGjOrgCompanyList(GjOrgCompanyQueryParam param) {
        if (param.getOrgId() == null) {
            return new JqGridData();
        }
        return this.gjOrgCustomerService.getGjOrgCompanyList(param);
    }

    public GjOrgCustomerStatisticVo getGjOrjCustomerStatistic(Long customerId) {
        if (customerId == null) {
            return null;
        }
        return this.gjOrgCustomerService.getCustomerStatisticForGjOrj(customerId);
    }

    public GjOrgCustomerVo getGjOrgCustomer(Long gjOrgCustomerId) {
        ThirdGjOrgCustomer gjOrgCustomer = (ThirdGjOrgCustomer)this.gjOrgCustomerService.getById(gjOrgCustomerId);
        if (gjOrgCustomer == null) {
            return null;
        }
        GjOrgCustomerVo result = this.gjOrgCustomerConverter.ThirdGjOrgCustomer2GjOrgCustomerVo(gjOrgCustomer);
        result.setContractFileList(this.sysFileProvideService.getListByIds(gjOrgCustomer.getContractFileId()));
        ThirdOrganizationVo thirdOrganization = this.thirdOrgMapper.getThirdOrganization(gjOrgCustomer.getOrgId());
        if (thirdOrganization != null) {
            result.setOrgName(thirdOrganization.getName());
            result.setOrgCreditCode(thirdOrganization.getCreditCode());
            result.setOrgAddress(thirdOrganization.getAddress());
        }
        return result;
    }

    public GjOrgCustomerVo getLastGjOrgCustomer(Long orgId, Long cid) {
        ThirdGjOrgCustomer gjOrgCustomer = this.gjOrgCustomerService.getLastGjOrgCustomer(orgId, cid);
        if (gjOrgCustomer == null) {
            return null;
        }
        GjOrgCustomerVo result = this.gjOrgCustomerConverter.ThirdGjOrgCustomer2GjOrgCustomerVo(gjOrgCustomer);
        result.setContractFileList(this.sysFileProvideService.getListByIds(gjOrgCustomer.getContractFileId()));
        ThirdOrganizationVo thirdOrganization = this.thirdOrgMapper.getThirdOrganization(gjOrgCustomer.getOrgId());
        if (thirdOrganization != null) {
            result.setOrgName(thirdOrganization.getName());
            result.setOrgCreditCode(thirdOrganization.getCreditCode());
            result.setOrgAddress(thirdOrganization.getAddress());
        }
        return result;
    }

    @Transactional
    public Long addGjOrgCustomer(GjOrgCustomerAddParam param) {
        if (param.getType() == ThirdGjOrgCustomerTypeEnum.type1.getValue()) {
            if (!this.gjOrgCustomerService.checkSubmitGjOrgCustomer(param.getCid())) {
                throw new ServiceException("\u8be5\u4f01\u4e1a\u5df2\u7b7e\u7ea6\u6216\u5728\u7b7e\u7ea6\u6d41\u7a0b\u4e2d\uff01");
            }
        } else if (!this.gjOrgCustomerService.checkContinueGjOrgCustomer(param.getCid(), param.getOrgId())) {
            throw new ServiceException("\u8be5\u4f01\u4e1a\u5df2\u5b58\u5728\u7eed\u7ea6\u6d41\u7a0b\u4e2d\uff01");
        }
        if (param.getType() == 1) {
            this.gjOrgCustomerService.updateCustomerIsShowData(Collections.singletonList(param.getCid()));
        }
        ThirdGjOrgCustomer record = this.gjOrgCustomerConverter.GjOrgCustomerAddParam2ThirdGjOrgCustomer(param);
        AreaModel area = this.sysAreaProvideService.getAreaById(param.getAreaId());
        if (area != null) {
            record.setAreaId1(area.getProvinceId());
            record.setAreaId2(area.getCityId());
            record.setAreaId3(area.getAreaId());
            record.setAreaId4(area.getStreetId());
        }
        record.setSource(ThirdGjOrgCustomerSourceEnum.THIRD_ORG.getValue());
        record.setState(ThirdGjOrgCustomerStateEnum.sign_audit.getValue());
        record.setCreateBy(param.getUserId());
        if (param.getType() == 2) {
            record.setIsShowData(Integer.valueOf(0));
        }
        this.gjOrgCustomerService.save(record);
        this.thirdGjOrgAuditLogService.save(new ThirdGjOrgAuditLog().setType(ThirdGjOrgAuditLogTypeEnum.third_gj_org_customer_sign.getValue()).setBusinessId(record.getId()).setOpt(ThirdGjOrgAuditOptEnum.customer_sign_opt_1.getOptName()).setOptValue(ThirdGjOrgAuditOptEnum.customer_sign_opt_1.getOptValue()).setOptPeople(this.thirdGjOrgService.getOrgName(record.getOrgId())));
        return record.getId();
    }

    @Transactional
    public Long submitGjOrgCustomer(GjOrgCustomerAddParam param) {
        ThirdGjOrgCustomer exists = (ThirdGjOrgCustomer)this.gjOrgCustomerService.getById(param.getId());
        if (!ThirdGjOrgCustomerStateEnum.sign_refued.getValue().equals(exists.getState())) {
            throw new ServiceException("\u7b7e\u7ea6\u88ab\u9000\u56de\u7684\u624d\u80fd\u91cd\u65b0\u63d0\u4ea4\u5ba1\u6838\uff01");
        }
        ThirdGjOrgCustomer record = this.gjOrgCustomerConverter.GjOrgCustomerAddParam2ThirdGjOrgCustomer(param);
        AreaModel area = this.sysAreaProvideService.getAreaById(param.getAreaId());
        if (area != null) {
            record.setAreaId1(area.getProvinceId());
            record.setAreaId2(area.getCityId());
            record.setAreaId3(area.getAreaId());
            record.setAreaId4(area.getStreetId());
        }
        record.setState(ThirdGjOrgCustomerStateEnum.sign_audit.getValue());
        record.setUpdateBy(param.getUserId());
        this.gjOrgCustomerService.updateById(record);
        this.thirdGjOrgAuditLogService.save(new ThirdGjOrgAuditLog().setType(ThirdGjOrgAuditLogTypeEnum.third_gj_org_customer_sign.getValue()).setBusinessId(record.getId()).setOpt(ThirdGjOrgAuditOptEnum.customer_sign_opt_1.getOptName()).setOptValue(ThirdGjOrgAuditOptEnum.customer_sign_opt_1.getOptValue()).setOptPeople(this.thirdGjOrgService.getOrgName(record.getOrgId())));
        return record.getId();
    }

    @Transactional
    public void cancelGjOrgCustomer(Long gjOrgCustomerId, String cancelReason, String orgName) {
        ThirdGjOrgCustomer record = new ThirdGjOrgCustomer();
        record.setId(gjOrgCustomerId);
        record.setState(ThirdGjOrgCustomerStateEnum.cancel_audit.getValue());
        record.setCancelReason(cancelReason);
        record.setCancelTime(new Date());
        this.gjOrgCustomerService.updateById(record);
        this.thirdGjOrgAuditLogService.save(new ThirdGjOrgAuditLog().setType(ThirdGjOrgAuditLogTypeEnum.third_gj_org_customer_cancel.getValue()).setBusinessId(gjOrgCustomerId).setOpt(ThirdGjOrgAuditOptEnum.customer_cancel_opt_1.getOptName()).setOptValue(ThirdGjOrgAuditOptEnum.customer_cancel_opt_1.getOptValue()).setOptPeople(orgName).setOptDesc(cancelReason));
    }

    public boolean checkPermission(Long gjOrgCustomerId, Long orgId) {
        ThirdGjOrgCustomer record = (ThirdGjOrgCustomer)this.gjOrgCustomerService.getById(gjOrgCustomerId);
        return record != null && record.getOrgId() != null && record.getOrgId().equals(orgId);
    }

    public boolean checkContinueGjOrgCustomer(Long cid, Long orgId) {
        ThirdGjOrgCustomer last = this.gjOrgCustomerService.getLastEffectiveGjOrgCustomer(orgId, cid);
        return last != null && last.getExpireTime() != null && last.getState() != null && DateUtils.addDay((Date)new Date(), (int)60).after(last.getExpireTime()) && !ThirdGjOrgCustomerStateEnum.cancel_audit.getValue().equals(last.getState());
    }

    public List<GjOrgCustomerChooseCompanyVo> searchCompanyWithGjOrg(Long orgId, String keyword) {
        if (StringUtils.isBlank((CharSequence)keyword)) {
            return null;
        }
        List<ThirdGjOrg> list = this.thirdGjOrgService.getGjOrgList(orgId);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return this.companyMapper.getCompanyList(list, keyword, keyword.trim().matches("^[a-zA-Z0-9]*$"));
    }

    public JqGridData<GjOrgSignCompHistoryVo> listCustomerHistoryForOrj(CompanyCustomerSearchParam param) {
        return this.gjOrgCustomerService.listCustomerHistoryForOrj(param);
    }

    public void searchAndUpdateCustomerAboutRange(Long cid, LocalDate date) {
        List<Object> changeList = new ArrayList();
        changeList = null == cid ? this.gjOrgCustomerService.selectAreaChanged(LocalDate.now().minusDays(1L), null) : this.gjOrgCustomerService.selectAreaChanged(date, cid);
        for (CompanyAreaChangedVo item : changeList) {
            AreaModel areaModel = this.sysAreaProvideService.getAreaById(item.getToAreaId());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(ThirdGjOrgCustomer::getCid, (Object)item.getCid())).in(ThirdGjOrgCustomer::getState, new Object[]{2, 4, 6});
            List customerList = this.gjOrgCustomerService.list((Wrapper)queryWrapper);
            customerList.stream().forEach(customer -> {
                customer.setAreaId(item.getToAreaId());
                customer.setAreaId1(areaModel.getProvinceId());
                customer.setAreaId2(areaModel.getCityId());
                customer.setAreaId3(areaModel.getAreaId());
                customer.setAreaId4(areaModel.getStreetId());
                List<ThirdGjOrg> gjOrgList = this.thirdGjOrgService.getGjOrgList(customer.getOrgId());
                if (item.getBelongType() == 0) {
                    Set filterOrgAreaSet = gjOrgList.stream().filter(org -> org.getLevel() == 3).map(ThirdGjOrg::getAreaId3).collect(Collectors.toSet());
                    if (!filterOrgAreaSet.contains(areaModel.getAreaId())) {
                        customer.setIsInRange(Integer.valueOf(0));
                    } else {
                        customer.setIsInRange(Integer.valueOf(1));
                    }
                } else if (item.getBelongType() == 1) {
                    Set filterOrgAreaSet = gjOrgList.stream().filter(org -> org.getLevel() == 1).map(ThirdGjOrg::getAreaId1).collect(Collectors.toSet());
                    if (!filterOrgAreaSet.contains(areaModel.getProvinceId())) {
                        customer.setIsInRange(Integer.valueOf(0));
                    } else {
                        customer.setIsInRange(Integer.valueOf(1));
                    }
                } else if (item.getBelongType() == 2) {
                    Set filterOrgAreaSet = gjOrgList.stream().filter(org -> org.getLevel() == 2).map(ThirdGjOrg::getAreaId2).collect(Collectors.toSet());
                    if (!filterOrgAreaSet.contains(areaModel.getCityId())) {
                        customer.setIsInRange(Integer.valueOf(0));
                    } else {
                        customer.setIsInRange(Integer.valueOf(1));
                    }
                }
            });
            this.gjOrgCustomerService.updateBatchById(customerList);
        }
    }

    public Map<Long, Long> getSignedEnterpriseIdList(List<Long> cidList) {
        return this.gjOrgCustomerService.getSignedEnterpriseIdList(cidList);
    }

    @Generated
    public ThirdGjOrgCustomerProviderToThird(IThirdGjOrgService thirdGjOrgService, IThirdGjUserLogService thirdGjUserLogService, IThirdGjOrgAuditLogService thirdGjOrgAuditLogService, IThirdGjOrgCustomerService gjOrgCustomerService, ThirdOrgMapper thirdOrgMapper, CompanyMapper companyMapper, GjOrgCustomerConverter gjOrgCustomerConverter) {
        this.thirdGjOrgService = thirdGjOrgService;
        this.thirdGjUserLogService = thirdGjUserLogService;
        this.thirdGjOrgAuditLogService = thirdGjOrgAuditLogService;
        this.gjOrgCustomerService = gjOrgCustomerService;
        this.thirdOrgMapper = thirdOrgMapper;
        this.companyMapper = companyMapper;
        this.gjOrgCustomerConverter = gjOrgCustomerConverter;
    }
}

