/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.provider.supervise.thirdGjOrgManage;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.fwgj.dao.CompanyMapper;
import cn.smarthse.fwgj.dao.thirdGj.ThirdOrgMapper;
import cn.smarthse.fwgj.entity.sys.SysUser;
import cn.smarthse.fwgj.entity.sys.ThirdOrganization;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrg;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgAuditLog;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgCustomer;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgCustomerLot;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgCustomerLotDetail;
import cn.smarthse.fwgj.enums.ThirdGjOrgCustomerStateEnum;
import cn.smarthse.fwgj.model.param.admin.ForbiddenGjOrgParam;
import cn.smarthse.fwgj.model.param.admin.GjOrgAddParam;
import cn.smarthse.fwgj.model.param.admin.GjOrgCustomerLotDetailImportParam;
import cn.smarthse.fwgj.model.param.admin.GjOrgInfoManageListParam;
import cn.smarthse.fwgj.model.param.admin.GjOrgScoreParam;
import cn.smarthse.fwgj.model.param.admin.GjOrgScoringParam;
import cn.smarthse.fwgj.model.param.admin.GjOrgSignCompAuditParam;
import cn.smarthse.fwgj.model.param.admin.GjOrgSignCompLogParam;
import cn.smarthse.fwgj.model.param.admin.SearchNoSignCompaniesListParam;
import cn.smarthse.fwgj.model.param.third.GjOrgCompanyQueryParam;
import cn.smarthse.fwgj.model.vo.admin.CompanyInfoVo;
import cn.smarthse.fwgj.model.vo.admin.GjOrgCustomerLotDetailImportResultVo;
import cn.smarthse.fwgj.model.vo.admin.GjOrgInfoChooseVo;
import cn.smarthse.fwgj.model.vo.admin.GjOrgInfoVo;
import cn.smarthse.fwgj.model.vo.admin.GjOrgServiceAreaStatisticsVo;
import cn.smarthse.fwgj.model.vo.admin.GjOrgServiceStatisticsVo;
import cn.smarthse.fwgj.model.vo.admin.GjOrgSignCompHistoryVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgCompanyListVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgCustomerVo;
import cn.smarthse.fwgj.model.vo.third.ThirdOrganizationVo;
import cn.smarthse.fwgj.provider.supervise.thirdGjCheck.IThirdGjCheckProviderToSupervise;
import cn.smarthse.fwgj.provider.supervise.thirdGjOrgManage.IThirdGjOrgManageServiceProvider;
import cn.smarthse.fwgj.service.sys.ISysUserService;
import cn.smarthse.fwgj.service.sys.IThirdOrganizationService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjOrgAuditLogService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjOrgCustomerLotDetailService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjOrgCustomerLotService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjOrgCustomerService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjOrgService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.platform.model.AreaModel;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.curator.shaded.com.google.common.base.Joiner;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@DubboService
public class ThirdGjOrgManageServiceProviderImpl
implements IThirdGjOrgManageServiceProvider {
    @Resource
    private IThirdGjOrgService thirdGjOrgService;
    @Resource
    private IThirdGjOrgCustomerService orgCustomerService;
    @Resource
    private IThirdGjOrgCustomerLotService orgCustomerLotService;
    @Resource
    private IThirdGjOrgCustomerLotDetailService orgCustomerLotDetailService;
    @Resource
    private IThirdGjOrgAuditLogService orgAuditLogService;
    @Resource
    private ISysUserService userService;
    @Resource
    private IThirdOrganizationService thirdOrganizationService;
    @Resource
    private ThirdOrgMapper thirdOrgMapper;
    @Resource
    private CompanyMapper companyMapper;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    private final IThirdGjCheckProviderToSupervise thirdGjCheckProviderToSupervise;

    public JqGridData<GjOrgInfoVo> getFwgjInfoListPageData(GjOrgInfoManageListParam param) {
        return this.thirdGjOrgService.getFwgjInfoListPageData(param);
    }

    public GjOrgServiceStatisticsVo getGjOrgServiceStatisticsData(Long orgId, Long areaId, Integer areaLevel) {
        return this.thirdGjOrgService.getGjOrgServiceStatisticsData(orgId, areaId, areaLevel);
    }

    public GjOrgCustomerVo getOrgSignCompAuditDetail(Long gjOrgCustomerId) {
        ThirdGjOrgCustomer gjOrgCustomer = (ThirdGjOrgCustomer)this.orgCustomerService.getById(gjOrgCustomerId);
        if (gjOrgCustomer == null) {
            return null;
        }
        GjOrgCustomerVo result = new GjOrgCustomerVo();
        result.setId(gjOrgCustomer.getId());
        result.setOrgId(gjOrgCustomer.getOrgId());
        result.setCid(gjOrgCustomer.getCid());
        result.setState(gjOrgCustomer.getState());
        result.setOrgMan(gjOrgCustomer.getOrgMan());
        result.setOrgTel(gjOrgCustomer.getOrgTel());
        result.setUnitName(gjOrgCustomer.getUnitName());
        result.setUnitCreditCode(gjOrgCustomer.getUnitCreditCode());
        result.setUnitMan(gjOrgCustomer.getUnitMan());
        result.setUnitTel(gjOrgCustomer.getUnitTel());
        result.setUnitAddress(gjOrgCustomer.getUnitAddress());
        result.setSignTime(gjOrgCustomer.getSignTime());
        result.setExpireTime(gjOrgCustomer.getExpireTime());
        result.setContractFileId(gjOrgCustomer.getContractFileId());
        ThirdOrganizationVo thirdOrganization = this.thirdOrgMapper.getThirdOrganization(gjOrgCustomer.getOrgId());
        if (thirdOrganization != null) {
            result.setOrgName(thirdOrganization.getName());
            result.setOrgCreditCode(thirdOrganization.getCreditCode());
            result.setOrgAddress(StringUtils.join((Object[])new String[]{thirdOrganization.getProvinceName(), thirdOrganization.getCityName(), thirdOrganization.getAreaName(), thirdOrganization.getAddress()}));
        }
        return result;
    }

    public Boolean hasOrgSignCompAuditPermit(Long orgId, Long areaId, Integer areaLevel) {
        if (orgId == null || areaId == null || areaLevel == null) {
            return false;
        }
        if (areaLevel <= 1) {
            return true;
        }
        ThirdGjOrg gjOrg = this.thirdGjOrgService.getByAreaId(orgId, areaId);
        return gjOrg != null;
    }

    public void orgSignCompAudit(GjOrgSignCompAuditParam param) {
        ThirdGjOrgCustomer customer = this.orgCustomerService.orgSignCompAudit(param);
        if (customer.getState().equals(ThirdGjOrgCustomerStateEnum.sign.getValue())) {
            this.thirdGjCheckProviderToSupervise.addAutoCreateCheck(Collections.singletonList(customer));
        }
        if (customer.getState().equals(ThirdGjOrgCustomerStateEnum.cancel.getValue())) {
            this.thirdGjCheckProviderToSupervise.handleRemainingCheck(Collections.singletonList(customer.getId()));
        }
    }

    public void cancelSignByAdmin(Long gjOrgCustomerId, String optPeople) {
        ThirdGjOrgCustomer customer = this.orgCustomerService.cancelSignByAdmin(gjOrgCustomerId, optPeople);
        this.thirdGjCheckProviderToSupervise.handleRemainingCheck(Collections.singletonList(customer.getId()));
    }

    public JqGridData<GjOrgSignCompHistoryVo> getGjOrgSignAllCompLog(GjOrgSignCompLogParam param) {
        return this.orgAuditLogService.getGjOrgSignAllCompLog(param);
    }

    public List<ThirdGjOrgAuditLog> getGjOrgSignOneCompLog(Integer type, Long orgId, Long cid) {
        return this.orgAuditLogService.getGjOrgSignOneCompLog(type, orgId, cid);
    }

    public List<GjOrgInfoChooseVo> getGjOrgInfoChooseVoList(Long orgId, Long areaId, Integer areaLevel, String keyword) {
        List<GjOrgInfoChooseVo> chooseVoList = this.thirdGjOrgService.getGjOrgInfoChooseVoList(orgId, areaId, areaLevel, keyword);
        if (!CollectionUtils.isEmpty(chooseVoList) && chooseVoList.size() > 100) {
            return chooseVoList.subList(0, 100);
        }
        return chooseVoList;
    }

    public JqGridData<GjOrgCompanyListVo> getGjOrgCompanyList(GjOrgCompanyQueryParam param) {
        if (param.getOrgId() == null) {
            return new JqGridData();
        }
        return this.orgCustomerService.getGjOrgCompanyList(param);
    }

    public Boolean scoringForGjOrg(GjOrgScoringParam param) {
        if (param.getGjOrgId() == null || param.getScore() == null) {
            return false;
        }
        return this.thirdGjOrgService.scoringForGjOrg(param);
    }

    public void forbiddenGjOrg(ForbiddenGjOrgParam param) {
        List<ThirdGjOrgCustomer> customers = this.thirdGjOrgService.forbiddenGjOrg(param);
        if (!CollectionUtils.isEmpty(customers)) {
            List ids = customers.stream().map(ThirdGjOrgCustomer::getId).collect(Collectors.toList());
            this.thirdGjCheckProviderToSupervise.handleRemainingCheck(ids);
        }
    }

    public List<GjOrgServiceAreaStatisticsVo> getGjOrgServiceAreaStatisticsVoList(Long loginUserAreaId, Integer loginAreaLevel, Long orgId) {
        return this.thirdGjOrgService.getGjOrgServiceAreaStatisticsVoList(loginUserAreaId, loginAreaLevel, orgId);
    }

    public List<ThirdGjOrg> getGjOrgList(Long areaId, Integer areaLevel, Long orgId) {
        return this.thirdGjOrgService.getGjOrgStateList(orgId, areaId, areaLevel);
    }

    public List<String> importGjOrg(List<GjOrgAddParam> list) {
        Map<String, Long> orgEmailCollect1;
        List orgEmailCollect2;
        Map<String, Long> orgCreditCodeCollect1;
        List orgCreditCodeCollect2;
        Map<String, Long> orgNameCollect1;
        List orgNameCollect2;
        ArrayList<String> errMsgList = new ArrayList<String>();
        if (CollectionUtils.isEmpty(list)) {
            errMsgList.add("\u5bfc\u5165\u8868\u683c\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        if (!CollectionUtils.isEmpty(orgNameCollect2 = (orgNameCollect1 = list.stream().collect(Collectors.groupingBy(GjOrgAddParam::getOrgName, Collectors.counting()))).keySet().stream().filter(key -> (Long)orgNameCollect1.get(key) > 1L).collect(Collectors.toList()))) {
            errMsgList.add(String.format("\u8868\u683c\u6570\u636e\u4e2d\u673a\u6784\u540d\uff1a\u201c%s\u201d\u5b58\u5728\u91cd\u590d\uff01", Joiner.on((String)"\uff0c").join(orgNameCollect2)));
        }
        if (!CollectionUtils.isEmpty(orgCreditCodeCollect2 = (orgCreditCodeCollect1 = list.stream().collect(Collectors.groupingBy(GjOrgAddParam::getOrgCreditCode, Collectors.counting()))).keySet().stream().filter(key -> (Long)orgCreditCodeCollect1.get(key) > 1L).collect(Collectors.toList()))) {
            errMsgList.add(String.format("\u8868\u683c\u6570\u636e\u4e2d\u673a\u6784\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\uff1a\u201c%s\u201d\u5b58\u5728\u91cd\u590d\uff01", Joiner.on((String)"\uff0c").join(orgCreditCodeCollect2)));
        }
        if (!CollectionUtils.isEmpty(orgEmailCollect2 = (orgEmailCollect1 = list.stream().collect(Collectors.groupingBy(GjOrgAddParam::getEmail, Collectors.counting()))).keySet().stream().filter(key -> (Long)orgEmailCollect1.get(key) > 1L).collect(Collectors.toList()))) {
            errMsgList.add(String.format("\u8868\u683c\u6570\u636e\u4e2d\u673a\u6784\u90ae\u7bb1\uff1a\u201c%s\u201d\u5b58\u5728\u91cd\u590d\uff01", Joiner.on((String)"\uff0c").join(orgEmailCollect2)));
        }
        List<ThirdGjOrg> list1 = this.thirdGjOrgService.getGjOrgList(list.get(0).getLoginAdminUserAreaId(), list.get(0).getLoginAdminUserAreaLevel());
        for (int i = 0; i < list.size(); ++i) {
            GjOrgAddParam param = list.get(i);
            if (StringUtils.isEmpty((CharSequence)param.getOrgName())) {
                errMsgList.add(String.format("\u7b2c%s\u884c\uff0c\u673a\u6784\u540d\u4e3a\u7a7a\uff01", i + 3));
            }
            if (StringUtils.isEmpty((CharSequence)param.getOrgCreditCode())) {
                errMsgList.add(String.format("\u7b2c%s\u884c\uff0c\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\u4e3a\u7a7a\uff01", i + 3));
            }
            if (StringUtils.isEmpty((CharSequence)param.getAreaName())) {
                errMsgList.add(String.format("\u7b2c%s\u884c\uff0c\u884c\u653f\u533a\u5212\u4e3a\u7a7a\uff01", i + 3));
            }
            if (StringUtils.isEmpty((CharSequence)param.getAddress())) {
                errMsgList.add(String.format("\u7b2c%s\u884c\uff0c\u8be6\u7ec6\u5730\u5740\u4e3a\u7a7a\uff01", i + 3));
            }
            if (StringUtils.isEmpty((CharSequence)param.getContactName())) {
                errMsgList.add(String.format("\u7b2c%s\u884c\uff0c\u8054\u7cfb\u4eba\u4e3a\u7a7a\uff01", i + 3));
            }
            if (StringUtils.isEmpty((CharSequence)param.getContactPhone())) {
                errMsgList.add(String.format("\u7b2c%s\u884c\uff0c\u8054\u7cfb\u65b9\u5f0f\u4e3a\u7a7a\uff01", i + 3));
            }
            if (StringUtils.isEmpty((CharSequence)param.getLegalPerson())) {
                errMsgList.add(String.format("\u7b2c%s\u884c\uff0c\u6cd5\u4eba\u4e3a\u7a7a\uff01", i + 3));
            }
            if (StringUtils.isEmpty((CharSequence)param.getLegalPersonPhone())) {
                errMsgList.add(String.format("\u7b2c%s\u884c\uff0c\u6cd5\u4eba\u8054\u7cfb\u65b9\u5f0f\u4e3a\u7a7a\uff01", i + 3));
            }
            if (StringUtils.isEmpty((CharSequence)param.getEmail())) {
                errMsgList.add(String.format("\u7b2c%s\u884c\uff0c\u90ae\u7bb1\u4e3a\u7a7a\uff01", i + 2));
            }
            if (CollectionUtils.isEmpty(list1) || !list1.stream().anyMatch(c -> c.getOrgCreditCode().equals(param.getOrgCreditCode()))) continue;
            errMsgList.add(String.format("\u7b2c%s\u884c\uff0c\u673a\u6784\u201c%s\u201d\u5728\u672c\u8f96\u533a\u5df2\u6709\u5907\u6848\uff01", i + 2, param.getOrgName()));
        }
        if (!CollectionUtils.isEmpty(errMsgList)) {
            return errMsgList;
        }
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(this::addGjOrg);
        }
        return null;
    }

    public GjOrgCustomerLotDetailImportResultVo importGjOrgCustomerLotDetails(Long lotId, List<GjOrgCustomerLotDetailImportParam> list) {
        Map<String, Long> lotDetailCreditCode1;
        List lotDetailCreditCode2;
        GjOrgCustomerLotDetailImportResultVo result = new GjOrgCustomerLotDetailImportResultVo();
        ArrayList<String> errMsgList = new ArrayList<String>();
        if (CollectionUtils.isEmpty(list)) {
            errMsgList.add("\u5bfc\u5165\u8868\u683c\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
            result.setErrMsgList(errMsgList);
            result.setState(Integer.valueOf(1));
            return result;
        }
        Map<String, Long> lotDetailUnitName1 = list.stream().collect(Collectors.groupingBy(GjOrgCustomerLotDetailImportParam::getUnitName, Collectors.counting()));
        List lotDetailUnitName2 = lotDetailUnitName1.keySet().stream().filter(key -> (Long)lotDetailUnitName1.get(key) > 1L).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(lotDetailUnitName2)) {
            errMsgList.add(String.format("\u8868\u683c\u6570\u636e\u4e2d\u4f01\u4e1a\u540d\uff1a\u201c%s\u201d \u5b58\u5728\u91cd\u590d\uff01", Joiner.on((String)"\uff0c").join(lotDetailUnitName2)));
        }
        if (!CollectionUtils.isEmpty(lotDetailCreditCode2 = (lotDetailCreditCode1 = list.stream().collect(Collectors.groupingBy(GjOrgCustomerLotDetailImportParam::getCreditCode, Collectors.counting()))).keySet().stream().filter(key -> (Long)lotDetailCreditCode1.get(key) > 1L).collect(Collectors.toList()))) {
            errMsgList.add(String.format("\u8868\u683c\u6570\u636e\u4e2d\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\uff1a\u201c%s\u201d \u5b58\u5728\u91cd\u590d\uff01", Joiner.on((String)"\uff0c").join(lotDetailCreditCode2)));
        }
        SearchNoSignCompaniesListParam param = new SearchNoSignCompaniesListParam();
        param.setAreaId(list.get(0).getAreaId());
        param.setAreaLevel(list.get(0).getAreaLevel());
        param.setLoginAdminAreaLevel(list.get(0).getLoginAreaLevel());
        param.setRows(Integer.MAX_VALUE);
        List<CompanyInfoVo> signCompaniesList = this.companyMapper.getNoSignCompaniesList(param);
        if (CollectionUtils.isEmpty(signCompaniesList)) {
            errMsgList.add("\u672c\u8f96\u533a\u65e0\u53ef\u5bfc\u5165\u7684\u672a\u7b7e\u7ea6\u4f01\u4e1a\uff01");
            result.setErrMsgList(errMsgList);
            result.setState(Integer.valueOf(1));
            return result;
        }
        List<ThirdGjOrgCustomerLotDetail> hasChooseUnit = this.orgCustomerLotDetailService.getListByLotId(lotId);
        ArrayList<CompanyInfoVo> toBeSignCompaniesList = new ArrayList<CompanyInfoVo>();
        Iterator<GjOrgCustomerLotDetailImportParam> iterator = list.iterator();
        int i = 3;
        while (iterator.hasNext()) {
            CompanyInfoVo infoVo;
            GjOrgCustomerLotDetailImportParam importParam = iterator.next();
            if (StringUtils.isEmpty((CharSequence)importParam.getUnitName())) {
                errMsgList.add(String.format("\u7b2c%s\u884c\uff0c\u4f01\u4e1a\u540d\u79f0\u4e3a\u7a7a\uff01", i));
            }
            if (StringUtils.isEmpty((CharSequence)importParam.getCreditCode())) {
                errMsgList.add(String.format("\u7b2c%s\u884c\uff0c\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\u4e3a\u7a7a\uff01", i));
            }
            if (importParam.getSignTime() == null) {
                errMsgList.add(String.format("\u7b2c%s\u884c\uff0c\u670d\u52a1\u5f00\u59cb\u65e5\u671f\u4e3a\u7a7a\uff01", i));
            }
            if (importParam.getExpireTime() == null) {
                errMsgList.add(String.format("\u7b2c%s\u884c\uff0c\u670d\u52a1\u7ed3\u675f\u65e5\u671f\u4e3a\u7a7a\uff01", i));
            }
            if (signCompaniesList.stream().noneMatch(c -> StringUtils.isNotEmpty((String)c.getUnitCreditCode()) && c.getUnitCreditCode().equals(importParam.getCreditCode()) && StringUtils.isNotEmpty((String)c.getUnitName()) && c.getUnitName().equals(importParam.getUnitName()))) {
                if (this.orgCustomerService.checkCompSignState(importParam.getCreditCode())) {
                    errMsgList.add(String.format("\u7b2c%s\u884c\uff0c\u201c%s\u201d \u5df2\u88ab\u7b7e\u7ea6\uff01", i, importParam.getUnitName()));
                } else {
                    CompanyInfoVo getByNameVo = this.companyMapper.getCompanyByNameOrCreditCode(importParam.getUnitName(), 1);
                    CompanyInfoVo getByCreditCodeVo = this.companyMapper.getCompanyByNameOrCreditCode(importParam.getCreditCode(), 2);
                    if (getByNameVo == null && getByCreditCodeVo == null) {
                        errMsgList.add(String.format("\u7b2c%s\u884c\uff0c\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u7684\u4f01\u4e1a\u540d\u79f0\uff08%s\uff09\u548c\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\uff08%s\uff09\uff01", i, importParam.getUnitName(), importParam.getCreditCode()));
                    } else if (getByNameVo != null && getByCreditCodeVo == null || getByNameVo == null && getByCreditCodeVo != null || getByNameVo != null && !Objects.equals(getByNameVo.getCid(), getByCreditCodeVo.getCid()) || !Objects.equals(Objects.requireNonNull(getByNameVo).getUnitName(), Objects.requireNonNull(getByCreditCodeVo).getUnitName()) || !Objects.equals(Objects.requireNonNull(getByNameVo).getUnitCreditCode(), Objects.requireNonNull(getByCreditCodeVo).getUnitCreditCode())) {
                        errMsgList.add(String.format("\u7b2c%s\u884c\uff0c\u4f01\u4e1a\u540d\u79f0\uff08%s\uff09\u548c\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\uff08%s\uff09\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u67e5\uff01", i, importParam.getUnitName(), importParam.getCreditCode()));
                    }
                    if (getByNameVo != null && getByCreditCodeVo != null && Objects.equals(getByNameVo.getCid(), getByCreditCodeVo.getCid())) {
                        errMsgList.add(String.format("\u7b2c%s\u884c\uff0c\u201c%s\u201d \u975e\u672c\u8f96\u533a\u53ef\u7b7e\u7ea6\u4f01\u4e1a\uff01", i, importParam.getUnitName()));
                    }
                }
            }
            if ((CollectionUtils.isEmpty(hasChooseUnit) || hasChooseUnit.stream().noneMatch(c -> StringUtils.isNotEmpty((String)c.getUnitCreditCode()) && c.getUnitCreditCode().equals(importParam.getCreditCode()))) && (infoVo = (CompanyInfoVo)signCompaniesList.stream().filter(f -> StringUtils.isNotEmpty((String)f.getUnitCreditCode()) && f.getUnitCreditCode().equals(importParam.getCreditCode()) && StringUtils.isNotEmpty((String)f.getUnitName()) && f.getUnitName().equals(importParam.getUnitName())).findFirst().orElse(null)) != null) {
                infoVo.setSignTime(importParam.getSignTime());
                infoVo.setExpireTime(importParam.getExpireTime());
                toBeSignCompaniesList.add(infoVo);
            }
            ++i;
        }
        if (!CollectionUtils.isEmpty(errMsgList)) {
            result.setErrMsgList(errMsgList);
            result.setState(Integer.valueOf(1));
            return result;
        }
        if (!CollectionUtils.isEmpty(toBeSignCompaniesList)) {
            lotId = this.addCustomerLotDetails(lotId, list.get(0).getCreateBy(), toBeSignCompaniesList);
            result.setLotId(lotId);
        }
        return result;
    }

    private Long addCustomerLotDetails(Long lotId, Long createBy, List<CompanyInfoVo> list) {
        ThirdGjOrgCustomerLot lot = new ThirdGjOrgCustomerLot();
        if (lotId == null) {
            lot.setCreateBy(createBy);
            this.orgCustomerLotService.save(lot);
            lotId = lot.getId();
        }
        ArrayList details = new ArrayList();
        Long finalLotId = lotId;
        list.forEach(importItem -> {
            ThirdGjOrgCustomerLotDetail detail = new ThirdGjOrgCustomerLotDetail();
            BeanUtils.copyProperties((Object)importItem, (Object)detail);
            detail.setLotId(finalLotId);
            details.add(detail);
        });
        this.orgCustomerLotDetailService.saveBatch(details);
        return lotId;
    }

    @Transactional
    public void addGjOrg(GjOrgAddParam param) {
        ThirdOrganization org = this.thirdOrganizationService.getByCreditCode(param.getOrgCreditCode());
        SysUser sysUser = new SysUser();
        if (org == null) {
            org = new ThirdOrganization();
            org.setName(param.getOrgName());
            org.setCreditCode(param.getOrgCreditCode());
            org.setContactName(param.getContactName());
            org.setContactPhone(param.getContactPhone());
            org.setLegalPerson(param.getLegalPerson());
            org.setLegalPersonPhone(param.getLegalPersonPhone());
            org.setOrgTypes("12");
            org.setCreateDate(new Date());
            org.setUpdateDate(new Date());
            org.setCreateBy(param.getLoginAdminUserId());
            AreaModel area = this.sysAreaProvideService.getAreaByName(param.getAreaName());
            if (area != null) {
                org.setProvinceId(area.getProvinceId());
                org.setCityId(area.getCityId());
                org.setAreaId(area.getAreaId());
                org.setDetailAreaId(area.getId());
                org.setProvinceName(area.getProvinceName());
                org.setCityName(area.getCityName());
                org.setAreaName(area.getAreaName());
                if (!StringUtils.isEmpty((CharSequence)area.getProvinceName())) {
                    org.setAddress(area.getProvinceName());
                }
                if (!StringUtils.isEmpty((CharSequence)area.getCityName())) {
                    org.setAddress(org.getAddress() + area.getCityName());
                }
                if (!StringUtils.isEmpty((CharSequence)area.getAreaName())) {
                    org.setAddress(org.getAddress() + area.getAreaName());
                }
            }
            org.setAddress(org.getAddress() + param.getAddress());
            org.setOrgSource(Byte.valueOf((byte)4));
            org.setCreateBy(param.getLoginAdminUserId());
            org.setUpdateBy(param.getLoginAdminUserId());
            this.thirdOrganizationService.save(org);
            sysUser.setUsername(param.getOrgName());
            sysUser.setFullname(param.getOrgName());
            sysUser.setCid(org.getId());
            sysUser.setEmail(param.getEmail());
            sysUser.setCreateDate(new Date());
            sysUser.setCreateBy(param.getLoginAdminUserId());
            sysUser = this.userService.register(sysUser);
        } else {
            String orgTypes;
            SysUser oldUser = this.userService.getOrgAdminUser(org.getId(), org.getName());
            if (oldUser == null) {
                sysUser.setUsername(param.getOrgName());
                sysUser.setFullname(param.getOrgName());
                sysUser.setCid(org.getId());
                sysUser.setEmail(param.getEmail());
                sysUser.setCreateDate(new Date());
                sysUser.setCreateBy(param.getLoginAdminUserId());
                sysUser = this.userService.register(sysUser);
            }
            if (StringUtils.isEmpty((CharSequence)(orgTypes = org.getOrgTypes()))) {
                org.setOrgTypes("12");
                this.thirdOrganizationService.updateById(org);
            } else {
                orgTypes = orgTypes.contains("12") ? orgTypes : String.join((CharSequence)",", orgTypes, "12");
                org.setOrgTypes(orgTypes);
                this.thirdOrganizationService.updateById(org);
            }
        }
        param.setOrgId(org.getId());
        param.setOrgUserId(sysUser.getId());
        this.thirdGjOrgService.addGjOrg(param);
    }

    public ThirdGjOrg getGjOrgById(Long id) {
        return (ThirdGjOrg)this.thirdGjOrgService.getById(id);
    }

    public List<ThirdGjOrg> getOverSixMonthsGjOrgList(Long areaId, Integer areaLevel) {
        return this.thirdGjOrgService.getOverSixMonthsGjOrgList(areaId, areaLevel);
    }

    public List<String> importGjOrgScore(List<GjOrgScoreParam> list) {
        ArrayList<String> errMsgList = new ArrayList<String>();
        if (CollectionUtils.isEmpty(list)) {
            errMsgList.add("\u5bfc\u5165\u8868\u683c\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        for (int i = 0; i < list.size(); ++i) {
            GjOrgScoreParam param = list.get(i);
            if (StringUtils.isEmpty((CharSequence)param.getId())) {
                errMsgList.add(String.format("\u7b2c%s\u884c\uff0c\u7f16\u53f7\u4e3a\u7a7a\uff01", i + 2));
            }
            if (StringUtils.isEmpty((CharSequence)param.getOrgName())) {
                errMsgList.add(String.format("\u7b2c%s\u884c\uff0c\u673a\u6784\u540d\u4e3a\u7a7a\uff01", i + 2));
            }
            if (StringUtils.isEmpty((CharSequence)param.getOrgCreditCode())) {
                errMsgList.add(String.format("\u7b2c%s\u884c\uff0c\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\u4e3a\u7a7a\uff01", i + 2));
            }
            if (!StringUtils.isEmpty((CharSequence)param.getScore())) continue;
            errMsgList.add(String.format("\u7b2c%s\u884c\uff0c\u8bc4\u5206\u4e3a\u7a7a\uff01", i + 2));
        }
        if (!CollectionUtils.isEmpty(errMsgList)) {
            return errMsgList;
        }
        ArrayList result = new ArrayList();
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(item -> {
                ThirdGjOrg org = new ThirdGjOrg();
                org.setId(Long.valueOf(item.getId()));
                org.setScore(Integer.valueOf(item.getScore()));
                result.add(org);
            });
            this.thirdGjOrgService.updateBatchById(result);
        }
        return null;
    }

    @Generated
    public ThirdGjOrgManageServiceProviderImpl(IThirdGjCheckProviderToSupervise thirdGjCheckProviderToSupervise) {
        this.thirdGjCheckProviderToSupervise = thirdGjCheckProviderToSupervise;
    }
}

