/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.provider.supervise.thirdGjCheck;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.fwgj.converter.check.GjCheckInfoConverter;
import cn.smarthse.fwgj.converter.check.GjCheckItemConverter;
import cn.smarthse.fwgj.converter.check.GjReformConverter;
import cn.smarthse.fwgj.dao.ReformItemBasicMapper;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjCheckInfo;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjCheckItem;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgCustomer;
import cn.smarthse.fwgj.enums.CheckStatusEnums;
import cn.smarthse.fwgj.enums.GjCheckInfoSupplyAuditStateEnum;
import cn.smarthse.fwgj.enums.GjCheckInfoSupplyStatusEnum;
import cn.smarthse.fwgj.enums.GjCheckInfoWarningStatusEnum;
import cn.smarthse.fwgj.enums.GjCustomerCycleEnum;
import cn.smarthse.fwgj.provider.supervise.thirdGjCheck.IThirdGjCheckProviderToSupervise;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjCheckInfoService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjCheckItemService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@DubboService
public class ThirdGjCheckProviderToSupervise
implements IThirdGjCheckProviderToSupervise {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThirdGjCheckProviderToSupervise.class);
    private final IThirdGjCheckInfoService infoService;
    private final IThirdGjCheckItemService itemService;
    private final GjCheckInfoConverter infoConverter;
    private final GjCheckItemConverter itemConverter;
    private final GjReformConverter reformConverter;
    @DubboReference
    private ISysFileProvideService fileProvideService;
    private final ReformItemBasicMapper reformItemBasicMapper;

    public void addAutoCreateCheck(List<ThirdGjOrgCustomer> customerList) {
        if (!CollectionUtils.isEmpty(customerList)) {
            customerList.forEach(customer -> {
                LocalDate signDate = customer.getSignTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                LocalDate expireDate = customer.getExpireTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                Period between = Period.between(signDate, expireDate);
                int months = between.getYears() * 12 + between.getMonths();
                if (between.getDays() > 0) {
                    ++months;
                }
                BigDecimal monthsNum = new BigDecimal(months);
                BigDecimal halfNum = new BigDecimal("6");
                int halfCycleNum = monthsNum.divide(halfNum, RoundingMode.CEILING).intValue();
                ArrayList<ThirdGjCheckInfo> addList = new ArrayList<ThirdGjCheckInfo>();
                for (int i = 0; i < halfCycleNum; ++i) {
                    int curYear = i / 2 + 1;
                    int curHalfCycle = (i + 1) % 2 == 1 ? GjCustomerCycleEnum.FIRST.getValue() : GjCustomerCycleEnum.SECOND.getValue();
                    LocalDate curHalfCycleStartDate = signDate.plusMonths((long)i * 6L);
                    LocalDate curHalfCycleEndDate = signDate.plusMonths((long)(i + 1) * 6L);
                    if (!curHalfCycleStartDate.isBefore(LocalDate.now()) && !curHalfCycleStartDate.isEqual(LocalDate.now())) continue;
                    ThirdGjCheckInfo info = new ThirdGjCheckInfo();
                    info.setCheckName(String.format("%s\u5408\u540c-\u670d\u52a1\u5468\u671f%s-%s\u670d\u52a1-\u7cfb\u7edf\u81ea\u52a8\u521b\u5efa", signDate, curYear, GjCustomerCycleEnum.getName((Integer)curHalfCycle)));
                    info.setOrgId(customer.getOrgId());
                    info.setCid(customer.getCid());
                    info.setUnitName(customer.getUnitName());
                    info.setCustomerId(customer.getId());
                    info.setIsAutoCreate(Integer.valueOf(1));
                    info.setCreateContractYear(Integer.valueOf(curYear));
                    info.setCreateCycle(Integer.valueOf(curHalfCycle));
                    info.setCreateSignTime(customer.getSignTime());
                    this.initializeCheckInfoAboutStatus(info, curHalfCycleEndDate);
                    addList.add(info);
                }
                this.infoService.saveBatch(addList);
            });
        }
    }

    private void initializeCheckInfoAboutStatus(ThirdGjCheckInfo info, LocalDate curHalfCycleEndDate) {
        if (curHalfCycleEndDate.isAfter(LocalDate.now())) {
            info.setCheckStatus(CheckStatusEnums.CHECKING.getCode());
            info.setSupplyStatus(GjCheckInfoSupplyStatusEnum.NO_NEED_SUPPLY.getValue());
            if (curHalfCycleEndDate.minusDays(30L).isAfter(LocalDate.now())) {
                info.setWarningStatus(GjCheckInfoWarningStatusEnum.NO_WARNING.getValue());
            } else {
                info.setWarningStatus(GjCheckInfoWarningStatusEnum.WARNING.getValue());
            }
        } else if (curHalfCycleEndDate.isBefore(LocalDate.now()) && curHalfCycleEndDate.plusDays(30L).isBefore(LocalDate.now())) {
            info.setCheckStatus(CheckStatusEnums.INCOMPLETE.getCode());
            info.setSupplyStatus(GjCheckInfoSupplyStatusEnum.CANT_SUPPLY.getValue());
            info.setWarningStatus(GjCheckInfoWarningStatusEnum.EXPIRED_MORE.getValue());
        } else if (curHalfCycleEndDate.isBefore(LocalDate.now()) || curHalfCycleEndDate.isEqual(LocalDate.now()) || curHalfCycleEndDate.plusDays(30L).isEqual(LocalDate.now())) {
            info.setCheckStatus(CheckStatusEnums.INCOMPLETE.getCode());
            info.setSupplyStatus(GjCheckInfoSupplyStatusEnum.COULD_SUPPLY.getValue());
            info.setWarningStatus(GjCheckInfoWarningStatusEnum.EXPIRED_LESS.getValue());
        }
    }

    @Transactional
    public void handleRemainingCheck(List<Long> customerIdList) {
        if (CollUtil.isNotEmpty(customerIdList)) {
            for (Long customerId : customerIdList) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ThirdGjCheckInfo::getCustomerId, (Object)customerId)).eq(ThirdGjCheckInfo::getIsAutoCreate, (Object)0)).in(ThirdGjCheckInfo::getCheckStatus, new Object[]{0, 1});
                List infoList = this.infoService.list((Wrapper)queryWrapper);
                if (CollUtil.isNotEmpty((Collection)infoList)) {
                    this.infoService.removeByIds(infoList.stream().map(ThirdGjCheckInfo::getId).collect(Collectors.toList()));
                    List checkIdList = infoList.stream().map(ThirdGjCheckInfo::getId).collect(Collectors.toList());
                    LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                    updateWrapper.in(ThirdGjCheckItem::getCheckId, checkIdList);
                    this.itemService.remove((Wrapper)updateWrapper);
                }
                LambdaQueryWrapper wrapperForAutoCreate = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapperForAutoCreate.eq(ThirdGjCheckInfo::getCustomerId, (Object)customerId)).eq(ThirdGjCheckInfo::getIsAutoCreate, (Object)1)).in(ThirdGjCheckInfo::getCheckStatus, new Object[]{0, 1});
                List autoCreateInfoList = this.infoService.list((Wrapper)wrapperForAutoCreate);
                if (!CollUtil.isNotEmpty((Collection)autoCreateInfoList)) continue;
                for (ThirdGjCheckInfo autoCreateInfo : autoCreateInfoList) {
                    autoCreateInfo.setCheckStatus(CheckStatusEnums.INCOMPLETE.getCode());
                    autoCreateInfo.setSupplyStatus(GjCheckInfoSupplyStatusEnum.CANT_SUPPLY.getValue());
                    autoCreateInfo.setSupplyAuditState(GjCheckInfoSupplyAuditStateEnum.NONE.getValue());
                }
                this.infoService.updateBatchById(autoCreateInfoList);
            }
        }
    }

    @Generated
    public ThirdGjCheckProviderToSupervise(IThirdGjCheckInfoService infoService, IThirdGjCheckItemService itemService, GjCheckInfoConverter infoConverter, GjCheckItemConverter itemConverter, GjReformConverter reformConverter, ReformItemBasicMapper reformItemBasicMapper) {
        this.infoService = infoService;
        this.itemService = itemService;
        this.infoConverter = infoConverter;
        this.itemConverter = itemConverter;
        this.reformConverter = reformConverter;
        this.reformItemBasicMapper = reformItemBasicMapper;
    }
}

