/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.provider.company;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.fwgj.converter.check.GjCheckInfoConverter;
import cn.smarthse.fwgj.converter.check.GjCheckItemConverter;
import cn.smarthse.fwgj.converter.check.GjReformConverter;
import cn.smarthse.fwgj.dao.ReformItemBasicMapper;
import cn.smarthse.fwgj.entity.sys.ThirdOrganization;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjCheckInfo;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjCheckItem;
import cn.smarthse.fwgj.model.param.CheckRecordParam;
import cn.smarthse.fwgj.model.param.third.GjCheckQueryParam;
import cn.smarthse.fwgj.model.vo.check.CheckVo;
import cn.smarthse.fwgj.model.vo.check.ReformListVo;
import cn.smarthse.fwgj.model.vo.third.CheckRecordVo;
import cn.smarthse.fwgj.model.vo.third.GjCheckListVo;
import cn.smarthse.fwgj.provider.company.IThirdGjCheckProviderToCompany;
import cn.smarthse.fwgj.service.sys.IThirdOrganizationService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjCheckInfoService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjCheckItemService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DubboService
public class ThirdGjCheckProviderToCompany
implements IThirdGjCheckProviderToCompany {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThirdGjCheckProviderToCompany.class);
    private final IThirdGjCheckInfoService infoService;
    private final IThirdGjCheckItemService itemService;
    private final GjCheckInfoConverter infoConverter;
    private final GjCheckItemConverter itemConverter;
    private final GjReformConverter reformConverter;
    private final ISysFileProvideService fileProvideService;
    private final ReformItemBasicMapper reformItemBasicMapper;
    private final IThirdOrganizationService thirdOrganizationService;

    public JqGridData<GjCheckListVo> getGjCheckListData(GjCheckQueryParam param) {
        return this.infoService.getGjCheckListData(param);
    }

    public JqGridData<CheckRecordVo> listCheckInfoForCompany(Long cid, Long customerId, Date startTime, Date endTime) {
        if (cid == null && customerId == null) {
            return null;
        }
        JqGridData<CheckRecordVo> checkList = this.infoService.listCheckRecordForCompany(new CheckRecordParam(cid, customerId, startTime, endTime));
        if (null != checkList.getRows() && !checkList.getRows().isEmpty()) {
            checkList.getRows().stream().forEach(check -> check.setReformStasticsVo(this.reformItemBasicMapper.getReformStatistics(check.getId())));
        }
        return checkList;
    }

    public CheckVo getCheckSummaryInfoForCompany(Long checkInfoId) {
        CheckVo rst = new CheckVo();
        ThirdGjCheckInfo info = (ThirdGjCheckInfo)this.infoService.getById(checkInfoId);
        rst.setCheckInfoVo(this.infoConverter.EntityToVo(info));
        rst.getCheckInfoVo().setOrgName(((ThirdOrganization)this.thirdOrganizationService.getById(info.getOrgId())).getName());
        rst.getCheckInfoVo().setCheckFileUrl(this.fileProvideService.getListByIds(info.getCheckFile()));
        rst.getCheckInfoVo().setUnitManageSignUrl(this.fileProvideService.getFileUrl(info.getUnitManageSign()));
        ThirdGjCheckItem item = this.itemService.getItemByCheckId(checkInfoId);
        rst.setCheckItemVo(this.itemConverter.EntityToVo(item));
        rst.setReformStasticsVo(this.reformItemBasicMapper.getReformStatistics(checkInfoId));
        ArrayList<ReformListVo> list = new ArrayList<ReformListVo>();
        List<ReformListVo> reformListVos = this.reformConverter.voToListVo(this.reformItemBasicMapper.getReformList(checkInfoId, null));
        List<ReformListVo> pastReformListVos = this.reformConverter.voToListVo(this.reformItemBasicMapper.getPastReformListByCid(checkInfoId, info.getCid()));
        reformListVos.stream().forEach(reformVo -> reformVo.setIsThisFind(Integer.valueOf(1)));
        list.addAll(reformListVos);
        list.addAll(pastReformListVos);
        rst.setReformListVo(list);
        return rst;
    }

    public List<ReformListVo> getCheckReformList(Long checkInfoId) {
        ThirdGjCheckInfo info = (ThirdGjCheckInfo)this.infoService.getById(checkInfoId);
        ArrayList<ReformListVo> list = new ArrayList<ReformListVo>();
        List<ReformListVo> reformListVos = this.reformConverter.voToListVo(this.reformItemBasicMapper.getReformList(checkInfoId, null));
        List<ReformListVo> pastReformListVos = this.reformConverter.voToListVo(this.reformItemBasicMapper.getPastReformListByCid(checkInfoId, info.getCid()));
        reformListVos.stream().forEach(reformVo -> reformVo.setIsThisFind(Integer.valueOf(1)));
        list.addAll(reformListVos);
        list.addAll(pastReformListVos);
        return list;
    }

    @Generated
    public ThirdGjCheckProviderToCompany(IThirdGjCheckInfoService infoService, IThirdGjCheckItemService itemService, GjCheckInfoConverter infoConverter, GjCheckItemConverter itemConverter, GjReformConverter reformConverter, ISysFileProvideService fileProvideService, ReformItemBasicMapper reformItemBasicMapper, IThirdOrganizationService thirdOrganizationService) {
        this.infoService = infoService;
        this.itemService = itemService;
        this.infoConverter = infoConverter;
        this.itemConverter = itemConverter;
        this.reformConverter = reformConverter;
        this.fileProvideService = fileProvideService;
        this.reformItemBasicMapper = reformItemBasicMapper;
        this.thirdOrganizationService = thirdOrganizationService;
    }
}

