/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.manage.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.fwgj.bootstrap.security.ShiroUtil;
import cn.smarthse.fwgj.converter.check.GjCheckInfoConverter;
import cn.smarthse.fwgj.converter.check.GjCheckItemConverter;
import cn.smarthse.fwgj.converter.check.GjReformConverter;
import cn.smarthse.fwgj.dao.thirdGj.ThirdGjCheckInfoMapper;
import cn.smarthse.fwgj.dao.thirdGj.ThirdGjOrgCustomerMapper;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjCheckInfo;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjCheckItem;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgCustomer;
import cn.smarthse.fwgj.enums.CheckStatusEnums;
import cn.smarthse.fwgj.enums.GjCheckInfoSupplyStatusEnum;
import cn.smarthse.fwgj.enums.GjCheckInfoWarningStatusEnum;
import cn.smarthse.fwgj.enums.GjCustomerAutoCreateEnum;
import cn.smarthse.fwgj.enums.GjCustomerCheckStatusEnum;
import cn.smarthse.fwgj.enums.GjCustomerCycleEnum;
import cn.smarthse.fwgj.manage.IReformManage;
import cn.smarthse.fwgj.manage.IThirdGjManage;
import cn.smarthse.fwgj.model.param.AddReformListParam;
import cn.smarthse.fwgj.model.param.ChangeAreaOrStatesParam;
import cn.smarthse.fwgj.model.param.ChangeCompanyParam;
import cn.smarthse.fwgj.model.param.ChangeLngAngLatParam;
import cn.smarthse.fwgj.model.param.CheckRecordParam;
import cn.smarthse.fwgj.model.param.CompanyChangePushParam;
import cn.smarthse.fwgj.model.param.CompanyListParam;
import cn.smarthse.fwgj.model.param.UpdateCheckParam;
import cn.smarthse.fwgj.model.param.check.UpdateCheckInfoParam;
import cn.smarthse.fwgj.model.vo.CheckItemReferenceDataVo;
import cn.smarthse.fwgj.model.vo.CheckNumVo;
import cn.smarthse.fwgj.model.vo.CompanyDetailVo;
import cn.smarthse.fwgj.model.vo.CompanyInfoVo;
import cn.smarthse.fwgj.model.vo.CompanyListVo;
import cn.smarthse.fwgj.model.vo.check.CheckVo;
import cn.smarthse.fwgj.model.vo.check.ReformListVo;
import cn.smarthse.fwgj.model.vo.check.ReformVo;
import cn.smarthse.fwgj.model.vo.third.CheckRecordVo;
import cn.smarthse.fwgj.model.vo.third.ReformStasticsVo;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjCheckInfoService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjCheckItemService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjOrgCustomerService;
import cn.smarthse.modules.datacentre.entity.CompanyProposedChange;
import cn.smarthse.modules.datacentre.enums.CompanyBusinessState;
import cn.smarthse.modules.datacentre.enums.StopDataSourceEnums;
import cn.smarthse.modules.datacentre.enums.StopStatusEnums;
import cn.smarthse.modules.datacentre.enums.StopTypeEnums;
import cn.smarthse.modules.datacentre.enums.StopTypeForReasonEnums;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.CompanyProposedChangeClueLastParam;
import cn.smarthse.modules.datacentre.provider.ICompanyProposedChangeProviderService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeV3Rec;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.enums.certificate.CertificateStaffTypeEnum;
import cn.smarthse.modules.health.enums.certificate.OccHeaStaffTypeEnum;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformSourceLiteEnum;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffDetailService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.thirdtime.simple.ITsProjectSimpleService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3RecService;
import cn.smarthse.modules.health.vo.litearchive.ZjArchiveCountView;
import cn.smarthse.modules.health.vo.work.reform.ReformAddParam;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3OneVo;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.wanda.api.entity.WandaDeclare;
import cn.smarthse.services.wanda.api.service.IWandaDeclareService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ThirdGjManageImpl
implements IThirdGjManage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThirdGjManageImpl.class);
    @Autowired
    @Lazy
    private IThirdGjManage self;
    @Autowired
    private GjCheckInfoConverter checkInfoConverter;
    @Autowired
    private GjCheckItemConverter checkItemConverter;
    @Autowired
    private GjReformConverter reformConverter;
    @Autowired
    private IThirdGjCheckInfoService gjCheckInfoService;
    @Autowired
    private IThirdGjCheckItemService gjCheckItemService;
    @Autowired
    private ThirdGjCheckInfoMapper infoMapper;
    @Autowired
    private ThirdGjOrgCustomerMapper customerMapper;
    @Autowired
    private IThirdGjOrgCustomerService customerService;
    @Autowired
    private IReformManage reformManage;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaProvideService;
    @DubboReference
    private ISysFileProvideService fileProvideService;
    @DubboReference
    private IReformItemBasicService reformItemBasicService;
    @DubboReference
    private IReformItemBasicNewService itemBasicNewService;
    @DubboReference
    private ICompanyProposedChangeProviderService companyProposedChangeProviderService;
    @DubboReference
    private ILiteArchiveService archiveService;
    @DubboReference
    private IWandaDeclareService wandaDeclareService;
    @DubboReference
    private IPhcPhysicalCheckService phcPhysicalCheckService;
    @DubboReference
    ICertificateStaffDetailService certificateStaffService;
    @DubboReference
    ICheckPlanService checkPlanService;
    @DubboReference
    private ITsProjectSimpleService simpleService;
    @DubboReference
    private ICompanyGradeV3RecService gradeV3RecService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService hseService;
    private final ThreadPoolTaskExecutor threadPoolTaskExecutor;

    @Override
    public List<CheckNumVo> listCheckNum(Long cid, Long customerId) {
        return this.gjCheckInfoService.listCheckNum(cid, customerId);
    }

    @Override
    public List<CheckRecordVo> listCheckRecord(CheckRecordParam param) {
        List<CheckRecordVo> rst = this.gjCheckInfoService.listCheckRecord(param);
        rst.stream().forEach(check -> check.setReformStasticsVo(this.reformManage.getReformStatistics(check.getId())));
        return rst;
    }

    @Override
    public CheckVo getCheck(Long id) {
        CheckVo rst = new CheckVo();
        ThirdGjCheckInfo info = (ThirdGjCheckInfo)this.gjCheckInfoService.getById(id);
        rst.setCheckInfoVo(this.checkInfoConverter.EntityToVo(info));
        rst.getCheckInfoVo().setCheckFileUrl(this.fileProvideService.getListByIds(info.getCheckFile()));
        rst.getCheckInfoVo().setUnitManageSignUrl(this.fileProvideService.getFileUrl(info.getUnitManageSign()));
        ThirdGjCheckItem item = this.gjCheckItemService.getItemByCheckId(id);
        rst.setCheckItemVo(this.checkItemConverter.EntityToVo(item));
        rst.setReformStasticsVo(this.reformManage.getReformStatistics(id));
        ArrayList<ReformListVo> list = new ArrayList<ReformListVo>();
        List<ReformListVo> reformListVos = this.reformConverter.voToListVo(this.reformManage.getReformListByCheckId(id));
        List<ReformListVo> pastReformListVos = this.reformConverter.voToListVo(this.reformManage.getPastReformListByCid(id, info.getCid()));
        reformListVos.stream().forEach(reformVo -> reformVo.setIsThisFind(Integer.valueOf(1)));
        list.addAll(reformListVos);
        list.addAll(pastReformListVos);
        rst.setReformListVo(list);
        return rst;
    }

    @Override
    @Transactional
    public Long addCheck(Long customerId) {
        ThirdGjOrgCustomer customer = (ThirdGjOrgCustomer)this.customerService.getById(customerId);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd");
        String signDate = dateFormat.format(customer.getSignTime());
        Long cid = customer.getCid();
        CompanyInfoVo companyInfo = this.infoMapper.selectCompanyInfo(cid);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ThirdGjCheckInfo::getCustomerId, (Object)customerId)).eq(ThirdGjCheckInfo::getCreateContractYear, (Object)customer.getCurContractYear())).eq(ThirdGjCheckInfo::getCreateCycle, (Object)customer.getCurCycle())).eq(ThirdGjCheckInfo::getIsAutoCreate, (Object)GjCustomerAutoCreateEnum.IS_AUTO.getValue())).orderByDesc(ThirdGjCheckInfo::getCreateDate)).last("limit 1");
        ThirdGjCheckInfo lastCheck = (ThirdGjCheckInfo)this.gjCheckInfoService.getOne((Wrapper)queryWrapper);
        if (!Objects.equals(lastCheck.getCheckStatus(), CheckStatusEnums.DONE.getCode()) && !Objects.equals(lastCheck.getCheckStatus(), CheckStatusEnums.END.getCode())) {
            throw new ServiceException("\u8bf7\u5b8c\u6210[" + lastCheck.getCheckName() + "]\u5de1\u67e5\u5de5\u4f5c\uff01");
        }
        ThirdGjCheckInfo info = new ThirdGjCheckInfo();
        info.setCheckName(String.format("%s\u5408\u540c-\u670d\u52a1\u5468\u671f%s-%s\u670d\u52a1-\u7b2c%s\u6b21", signDate, customer.getCurContractYear(), GjCustomerCycleEnum.getName((Integer)customer.getCurCycle()), 1 + this.gjCheckInfoService.getCheckNumByCCC(customerId, customer.getCurContractYear(), customer.getCurCycle())));
        info.setCheckStatus(CheckStatusEnums.CHECKING.getCode());
        info.setCid(cid);
        info.setUnitName(companyInfo.getName());
        info.setOrgId(customer.getOrgId());
        info.setCustomerId(customerId);
        info.setCheckPeople(ShiroUtil.getLoginUserNickname());
        info.setGjUserId(ShiroUtil.getLoginUserId());
        info.setCreateContractYear(customer.getCurContractYear());
        info.setCreateCycle(customer.getCurCycle());
        info.setCreateSignTime(customer.getSignTime());
        info.setAreaId(companyInfo.getAreaId());
        AreaModel areaInfo = this.areaProvideService.getAreaById(companyInfo.getAreaId());
        info.setAreaId1(areaInfo.getProvinceId());
        info.setAreaId2(areaInfo.getCityId());
        info.setAreaId3(areaInfo.getAreaId());
        info.setAreaId4(areaInfo.getStreetId());
        this.gjCheckInfoService.save(info);
        ThirdGjCheckItem item = new ThirdGjCheckItem();
        item.setCheckId(info.getId());
        item.setCid(cid);
        item.setOrgId(customer.getOrgId());
        item.setUserId(customer.getUserId());
        item.setGjUserId(ShiroUtil.getLoginUserId());
        this.gjCheckItemService.save(item);
        return info.getId();
    }

    @Override
    @Transactional
    public Boolean updateCheck(UpdateCheckParam updateParam) {
        if (updateParam.getCheckInfoParam() != null) {
            ThirdGjCheckInfo info = this.checkInfoConverter.updateParamToEntity(updateParam.getCheckInfoParam());
            if (Objects.equals(info.getCheckStatus(), CheckStatusEnums.DONE.getCode()) || Objects.equals(info.getCheckStatus(), CheckStatusEnums.END.getCode())) {
                info.setCheckTime(new Date());
            }
            info.setCheckStatus(CheckStatusEnums.CHECKING.getCode());
            AreaModel areaInfo = this.areaProvideService.getAreaById(info.getAreaId());
            info.setAreaId1(areaInfo.getProvinceId());
            info.setAreaId2(areaInfo.getCityId());
            info.setAreaId3(areaInfo.getAreaId());
            info.setAreaId4(areaInfo.getStreetId());
            boolean r1 = this.gjCheckInfoService.updateById(info);
            if (((ThirdGjCheckInfo)this.gjCheckInfoService.getById(info.getId())).getIsAutoCreate() == 1) {
                this.modifyCustomerHalfCheckStatus((ThirdGjCheckInfo)this.gjCheckInfoService.getById(info.getId()), null, GjCustomerCheckStatusEnum.CHECKING.getValue());
            }
        }
        if (updateParam.getCheckItemParam() != null) {
            ThirdGjCheckItem item = this.checkItemConverter.updateParamToEntity(updateParam.getCheckItemParam());
            boolean bl = this.gjCheckItemService.saveOrUpdate(item);
        }
        return null;
    }

    @Override
    @Transactional
    public void delCheck(UpdateCheckInfoParam param) {
        if (param.getId() == null) {
            return;
        }
        ThirdGjCheckInfo checkInfo = (ThirdGjCheckInfo)this.gjCheckInfoService.getById(param.getId());
        if (checkInfo.getCheckStatus() == CheckStatusEnums.DONE.getCode() || checkInfo.getCheckStatus() == CheckStatusEnums.END.getCode()) {
            throw new RuntimeException("\u5df2\u5b8c\u6210\u7684\u670d\u52a1\u68c0\u67e5\u65e0\u6cd5\u5220\u9664\uff01");
        }
        this.gjCheckInfoService.removeById(param.getId());
        this.gjCheckItemService.delItemByCheckId(param.getId());
    }

    @Override
    public CheckItemReferenceDataVo getItemReferenceData(Long cid) {
        ZjArchiveCountView currYearData = this.archiveService.getZjArchiveCountViewByCid(cid);
        ZjArchiveCountView lastYearData = this.archiveService.getLastZjArchiveCountViewByCid(cid);
        WandaDeclare wandaDeclareInfo = this.wandaDeclareService.getLastOneWandaDeclareByCid(cid);
        Date lastPhcCheckDateJobing = this.phcPhysicalCheckService.getLastPhcCheckDateJobing(cid);
        Date occDate = this.certificateStaffService.getCertificateValidate(cid, CertificateStaffTypeEnum.OccTrain.getId(), OccHeaStaffTypeEnum.OccHeaMan.getCode());
        Date mainDate = this.certificateStaffService.getCertificateValidate(cid, CertificateStaffTypeEnum.SaftyTrain.getId(), OccHeaStaffTypeEnum.MAIN.getCode());
        LocalDateTime latestCheckDate = this.checkPlanService.getLatestCheckDate(cid);
        JqGridParam param = new JqGridParam();
        param.setCid(cid);
        param.setPage(1);
        param.setRows(1);
        PageInfo tsProjectSimplePageInfo = this.simpleService.pageTsProjectSimple(param, null, null);
        long total = 0L;
        if (tsProjectSimplePageInfo != null) {
            total = tsProjectSimplePageInfo.getTotal();
        }
        CheckItemReferenceDataVo vo = new CheckItemReferenceDataVo();
        if (currYearData != null) {
            vo.setHseFileThree(currYearData.getThirdStateStr());
            vo.setHseFileCheck(currYearData.getCheckStateStr());
            vo.setHseFileManage(currYearData.getHseManageStateStr());
            vo.setHseFileStaffHealth(currYearData.getStaffStateStr());
            vo.setHseFileTrain(currYearData.getTrainStateStr());
            vo.setHseFileUnitHealth(currYearData.getPhysicalStateStr());
        }
        if (lastYearData != null) {
            vo.setHseFileThreeLast(lastYearData.getThirdStateStr());
            vo.setHseFileCheckLast(lastYearData.getCheckStateStr());
            vo.setHseFileManageLast(lastYearData.getHseManageStateStr());
            vo.setHseFileStaffHealthLast(lastYearData.getStaffStateStr());
            vo.setHseFileTrainLast(lastYearData.getTrainStateStr());
            vo.setHseFileUnitHealthLast(lastYearData.getPhysicalStateStr());
        }
        vo.setCheckDate((Date)DateUtil.date((TemporalAccessor)latestCheckDate));
        vo.setThreeNum(Integer.valueOf(Long.valueOf(total).intValue()));
        vo.setCid(cid);
        if (wandaDeclareInfo != null && wandaDeclareInfo.getDeclareTime() != null) {
            vo.setDeclareDate(wandaDeclareInfo.getDeclareTime());
        } else {
            CompanyBaseInfoModel companyById = this.hseService.getCompanyById(cid);
            if (companyById != null && companyById.getCreateDate() != null) {
                vo.setDeclareDate(companyById.getCreateDate());
            }
        }
        vo.setHealthDate(lastPhcCheckDateJobing);
        if (occDate == null) {
            vo.setTrainManageValid(Integer.valueOf(0));
        } else if (occDate.getTime() < new Date().getTime()) {
            vo.setTrainManageValid(Integer.valueOf(1));
        } else {
            vo.setTrainManageValid(Integer.valueOf(2));
        }
        if (mainDate == null) {
            vo.setTrainMainValid(Integer.valueOf(0));
        } else if (mainDate.getTime() < new Date().getTime()) {
            vo.setTrainMainValid(Integer.valueOf(1));
        } else {
            vo.setTrainMainValid(Integer.valueOf(2));
        }
        ReformItemBasic basic = new ReformItemBasic();
        basic.setCid(cid);
        basic.setReformItemSource(Byte.valueOf((byte)2));
        vo.setWarnSetDate(this.reformItemBasicService.getWarnOrProtectTime(basic));
        basic.setReformItemSource(Byte.valueOf((byte)1));
        vo.setLastDistributeDate(this.reformItemBasicService.getWarnOrProtectTime(basic));
        return vo;
    }

    @Override
    public List<ReformListVo> getReformListByPid(Long patrolId, Long cid) {
        ThirdGjCheckItem item = this.gjCheckItemService.getItemByCheckId(patrolId);
        List<ReformVo> pastList = this.reformManage.getPastReformListByCid(patrolId, cid);
        ArrayList<ReformListVo> list = new ArrayList<ReformListVo>();
        list.addAll(this.transformItem(item));
        list.addAll(this.reformConverter.voToListVo(pastList));
        return list;
    }

    @Override
    @Caching(evict={@CacheEvict(value={"homeData=1"}, key="#param.year +':'+ #param.areaId")})
    @Transactional
    public String commitReformAndCheck(AddReformListParam param) {
        ThirdGjCheckInfo curAutoCreateCheck;
        ThirdGjCheckInfo info = (ThirdGjCheckInfo)this.gjCheckInfoService.getById(param.getCheckId());
        if (info.getSupplyStatus() == GjCheckInfoSupplyStatusEnum.CANT_SUPPLY.getValue()) {
            throw new ServiceException("\u5f53\u524d\u670d\u52a1\u68c0\u67e5\u5df2\u8d85\u671f\uff0c\u4e0d\u53ef\u8865\u5f55\uff01\u8bf7\u5148\u7533\u8bf7\u8865\u5f55");
        }
        ThirdGjOrgCustomer customerInfo = (ThirdGjOrgCustomer)this.customerService.getById(info.getCustomerId());
        if (info.getIsAutoCreate() == 0 && ((curAutoCreateCheck = this.gjCheckInfoService.getAutoCreateCheckByCustomer(customerInfo.getId(), customerInfo.getCurContractYear(), customerInfo.getCurCycle())).getCheckStatus() == CheckStatusEnums.DONE.getCode() || curAutoCreateCheck.getCheckStatus() == CheckStatusEnums.END.getCode()) && DateUtil.isSameDay((Date)curAutoCreateCheck.getCheckTime(), (Date)new Date())) {
            throw new ServiceException("\u4eca\u65e5\u5df2\u5b8c\u6210\u7cfb\u7edf\u521b\u5efa\u7684\u670d\u52a1\u68c0\u67e5\uff0c\u65e0\u6cd5\u518d\u6b21\u63d0\u4ea4\u670d\u52a1\u68c0\u67e5\uff01");
        }
        if (info.getSupplyStatus() == GjCheckInfoSupplyStatusEnum.COULD_SUPPLY.getValue()) {
            info.setSupplyStatus(GjCheckInfoSupplyStatusEnum.SUPPLIED.getValue());
        } else {
            info.setSupplyStatus(GjCheckInfoSupplyStatusEnum.NO_NEED_SUPPLY.getValue());
        }
        info.setCheckStatus(CheckStatusEnums.DONE.getCode());
        info.setWarningStatus(GjCheckInfoWarningStatusEnum.NO_WARNING.getValue());
        info.setUnitManageSign(param.getUnitManageSign());
        info.setCheckPeople(ShiroUtil.getLoginUserNickname());
        info.setGjUserId(ShiroUtil.getLoginUserId());
        info.setCurContractYear(customerInfo.getCurContractYear());
        info.setCurCycle(customerInfo.getCurCycle());
        info.setCheckTime(new Date());
        this.gjCheckInfoService.updateById(info);
        if (info.getSupplyStatus() == GjCheckInfoSupplyStatusEnum.NO_NEED_SUPPLY.getValue()) {
            Date date = new Date();
            ArrayList addParamList = new ArrayList();
            param.getReformList().stream().filter(Objects::nonNull).forEach(addParam -> {
                ReformAddParam basic = new ReformAddParam();
                basic.setCid(addParam.getCid());
                basic.setThirdOrgId(info.getOrgId());
                basic.setFinderName(ShiroUtil.getLoginUserNickname());
                basic.setFindTime(date);
                basic.setName(addParam.getReformName());
                basic.setReformItemSource(ReformSourceLiteEnum.FWGJ.getValue());
                basic.setReformItemSourceId(addParam.getCheckId());
                basic.setGenerationSource(addParam.getReformGenerationSource());
                basic.setDescription(addParam.getReformName());
                basic.setReformMeasure(addParam.getReformMeasure());
                basic.setCreateBy(ShiroUtil.getLoginUserId());
                addParamList.add(basic);
            });
            this.itemBasicNewService.generateReform(addParamList);
        }
        if (info.getIsAutoCreate() == 1) {
            this.modifyCustomerHalfCheckStatus(info, customerInfo, GjCustomerCheckStatusEnum.DONE.getValue());
        }
        return null;
    }

    @Override
    @Transactional
    public Long createForClock(Long customerId) {
        ThirdGjOrgCustomer customer = (ThirdGjOrgCustomer)this.customerService.getById(customerId);
        ThirdGjCheckInfo lastCheck = this.gjCheckInfoService.getLastCheckForApp(customer.getCid(), customer);
        if (lastCheck == null) {
            return this.addCheck(customerId);
        }
        if (lastCheck.getCheckStatus() == CheckStatusEnums.NOT_STARTED.getCode() || lastCheck.getCheckStatus() == CheckStatusEnums.CHECKING.getCode()) {
            return lastCheck.getId();
        }
        if (lastCheck.getCheckStatus() == CheckStatusEnums.DONE.getCode() || lastCheck.getCheckStatus() == CheckStatusEnums.END.getCode()) {
            return this.addCheck(customerId);
        }
        return null;
    }

    @Override
    @Transactional
    public Boolean commitForClock(UpdateCheckInfoParam param) {
        ThirdGjCheckInfo dbInfo = (ThirdGjCheckInfo)this.gjCheckInfoService.getById(param.getId());
        ThirdGjCheckInfo info = this.checkInfoConverter.updateParamToEntity(param);
        ThirdGjOrgCustomer customer = (ThirdGjOrgCustomer)this.customerService.getById(((ThirdGjCheckInfo)this.gjCheckInfoService.getById(info.getId())).getCustomerId());
        info.setCheckPeople(ShiroUtil.getLoginUserNickname());
        info.setCurContractYear(customer.getCurContractYear());
        info.setCurCycle(customer.getCurCycle());
        info.setCheckTime(new Date());
        info.setCheckStatus(CheckStatusEnums.DONE.getCode());
        info.setWarningStatus(GjCheckInfoWarningStatusEnum.NO_WARNING.getValue());
        info.setDoneType(Integer.valueOf(1));
        if (info.getSupplyStatus() == GjCheckInfoSupplyStatusEnum.COULD_SUPPLY.getValue()) {
            info.setSupplyStatus(GjCheckInfoSupplyStatusEnum.SUPPLIED.getValue());
        } else {
            info.setSupplyStatus(GjCheckInfoSupplyStatusEnum.NO_NEED_SUPPLY.getValue());
        }
        AreaModel areaInfo = this.areaProvideService.getAreaById(info.getAreaId());
        info.setAreaId1(areaInfo.getProvinceId());
        info.setAreaId2(areaInfo.getCityId());
        info.setAreaId3(areaInfo.getAreaId());
        info.setAreaId4(areaInfo.getStreetId());
        boolean r1 = this.gjCheckInfoService.updateById(info);
        if (dbInfo.getIsAutoCreate() == 1) {
            this.modifyCustomerHalfCheckStatus(info, customer, GjCustomerCheckStatusEnum.DONE.getValue());
        }
        return r1;
    }

    @Override
    public JqGridData<CompanyListVo> listCompanyByOrgId(CompanyListParam param) throws InterruptedException {
        if (param.getOrgId() == null) {
            return null;
        }
        List<CompanyListVo> rst = this.customerMapper.listCheckCompanyByOrgIdForApp(param);
        CountDownLatch countDownLatch = new CountDownLatch(rst.size() * 2);
        rst.stream().forEach(company -> {
            company.setGjStopType(this.getCompanyStopTypeByCid(company.getId()));
            this.threadPoolTaskExecutor.execute(() -> {
                company.setCheckTotalNum(this.gjCheckInfoService.getCheckTotalNum(company.getId(), company.getCustomerId()));
                company.setLastCheckDate(this.gjCheckInfoService.getLastCheckDateByCid(company.getId()));
                countDownLatch.countDown();
            });
            this.threadPoolTaskExecutor.execute(() -> {
                company.setLastReformData(this.reformManage.getReformStatisticsByCid(company.getId()));
                CompanyGradeV3Rec grade = this.gradeV3RecService.getGradeRecByCid(company.getId());
                if (grade != null && (Objects.equals(grade.getCheckState(), 1) || company.getPickupCount() == null || company.getPickupCount() < 3)) {
                    company.setOccRiskLevel(grade.getGrade());
                    company.setOccManageLevel(grade.getJudgeLevel());
                    company.setHazardRiskLevel(grade.getRiskLevel());
                }
                countDownLatch.countDown();
            });
        });
        countDownLatch.await();
        return new JqGridData(rst, (JqGridParam)param);
    }

    @Override
    @Cacheable(value={"allCompanyData=6"}, key="'userId:' + #param.userId + 'areaId:' + #param.areaId", unless="#result == null")
    public List<CompanyListVo> getAllCompanyByAreaId(CompanyListParam param) {
        param.setKeyword(null);
        return this.infoMapper.selectBatchCompanyByArea(param);
    }

    private Integer getCompanyStopTypeByCid(Long cid) {
        Integer stopType = null;
        stopType = this.infoMapper.getCompanyStopTypeByCid(cid, StopDataSourceEnums.FWGJ.getCode());
        if (stopType == null) {
            stopType = this.infoMapper.getCompanyStopTypeByCid(cid, StopDataSourceEnums.XZXG.getCode());
        }
        return stopType;
    }

    @Override
    public CompanyDetailVo getCompanyById(Long id, Long customerId) {
        CompanyDetailVo rst = new CompanyDetailVo();
        ThirdGjOrgCustomer customer = (ThirdGjOrgCustomer)this.customerService.getById(customerId);
        ThirdGjCheckInfo info = this.gjCheckInfoService.getLastCheckForApp(id, customer);
        if (info != null) {
            rst.setLastCheckId(info.getId());
            rst.setLastCheckName(info.getCheckName());
            rst.setCheckPeople(info.getCheckPeople());
            rst.setCheckTime(info.getCheckTime());
            rst.setCheckStatus(info.getCheckStatus());
            rst.setStopType(info.getStopType());
            rst.setIsAutoCreate(info.getIsAutoCreate());
            ReformStasticsVo thisReform = this.reformManage.getReformStatistics(info.getId());
            rst.setThisReformNum(thisReform.getReformRiskNum());
        }
        rst.setGjStopType(this.getCompanyStopTypeByCid(id));
        rst.setLastReformData(this.reformManage.getReformStatisticsByCid(id));
        rst.setCheckNumData(this.listCheckNum(id, customerId));
        CompanyInfoVo companyInfo = this.infoMapper.selectCompanyInfo(id);
        rst.setLat(companyInfo.getLat());
        rst.setLng(companyInfo.getLng());
        return rst;
    }

    @Override
    public CompanyInfoVo getCompanyBeforeChange(Long id) {
        return this.infoMapper.selectCompanyInfo(id);
    }

    @Override
    @Transactional
    public String changeCompanyInfo(ChangeCompanyParam param) {
        this.infoMapper.updateCompanyInfo(param);
        return null;
    }

    @Override
    @Transactional
    public String changeComAreaOrStates(ChangeAreaOrStatesParam param) {
        if (param == null || param.getChangeType() == null) {
            throw new RuntimeException("\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570!");
        }
        CompanyInfoVo companyInfoVo = this.infoMapper.selectCompanyInfo(param.getId());
        ThirdGjCheckInfo info = (ThirdGjCheckInfo)this.gjCheckInfoService.getById(param.getCheckId());
        ThirdGjOrgCustomer customer = (ThirdGjOrgCustomer)this.customerService.getById(info.getCustomerId());
        CompanyChangePushParam changePushParam = new CompanyChangePushParam();
        changePushParam.setSourceId(param.getCheckId().toString());
        changePushParam.setCid(param.getId());
        changePushParam.setContactName(param.getContactName());
        changePushParam.setContactTel(param.getContactTel());
        changePushParam.setReasonType(param.getReasonType());
        changePushParam.setFileIds(param.getFileIds());
        changePushParam.setStopAreaId(param.getAreaId());
        changePushParam.setUserId(param.getUserId());
        changePushParam.setRepeatCid(param.getRepeatCid());
        if (info.getUnitName() == null) {
            info.setUnitName(companyInfoVo.getName());
            info.setUnitStatus(companyInfoVo.getBusinessState());
            info.setManager(companyInfoVo.getMainLeaderName());
            info.setTel(companyInfoVo.getMainLeaderTel());
            info.setHseManager(companyInfoVo.getOccManagerName());
            info.setHesTel(companyInfoVo.getOccManagerTel());
            info.setAddress(companyInfoVo.getAreaName());
            info.setWorkAddress(companyInfoVo.getWorkAddress());
            info.setIndustryCode(companyInfoVo.getIndustryCategory().toString());
            info.setIndustryName(companyInfoVo.getIndustryCategoryName());
            info.setScaleCode(companyInfoVo.getScale() != null ? companyInfoVo.getScale().toString() : null);
            info.setEconomyCode(companyInfoVo.getRegisterType().toString());
            info.setEconomyName(companyInfoVo.getRegisterTypeName());
        }
        if (param.getChangeType() == 2) {
            if (Objects.equals(param.getBusinessState(), CompanyBusinessState.CLOSE.getCode())) {
                changePushParam.setStopType(StopTypeEnums.CLOSE.getCode());
                this.self.pushCompanyChange(changePushParam);
                info.setStopType(StopTypeEnums.CLOSE.getCode());
                info.setCheckStatus(CheckStatusEnums.END.getCode());
            }
            if (info.getSupplyStatus() == GjCheckInfoSupplyStatusEnum.COULD_SUPPLY.getValue()) {
                info.setSupplyStatus(GjCheckInfoSupplyStatusEnum.SUPPLIED.getValue());
            } else {
                info.setSupplyStatus(GjCheckInfoSupplyStatusEnum.NO_NEED_SUPPLY.getValue());
            }
            info.setWarningStatus(GjCheckInfoWarningStatusEnum.NO_WARNING.getValue());
        }
        if (param.getChangeType() == 1) {
            Integer areaNum;
            if (param.getAreaId() == null) {
                throw new RuntimeException("\u8bf7\u9009\u62e9\u8fc1\u79fb\u540e\u7684\u533a\u57df!");
            }
            Integer stopType = null;
            Integer cityNum = this.infoMapper.countByCityId(companyInfoVo.getAreaId(), param.getAreaId());
            stopType = cityNum > 1 ? StopTypeEnums.CHANGECROSS.getCode() : ((areaNum = this.infoMapper.countByAreaId(companyInfoVo.getAreaId(), param.getAreaId())) > 1 ? StopTypeEnums.CHANGEWITHIN.getCode() : StopTypeEnums.CHANGEDISTRICTWITHIN.getCode());
            changePushParam.setStopType(stopType);
            this.self.pushCompanyChange(changePushParam);
            info.setStopType(stopType);
            info.setCheckStatus(CheckStatusEnums.CHECKING.getCode());
        }
        info.setGjUserId(param.getUserId());
        info.setCheckPeople(ShiroUtil.getLoginUserNickname());
        info.setCheckTime(new Date());
        info.setCurContractYear(customer.getCurContractYear());
        info.setCurCycle(customer.getCurCycle());
        this.gjCheckInfoService.updateById(info);
        if (info.getIsAutoCreate() == 1) {
            this.modifyCustomerHalfCheckStatus(info, customer, GjCustomerCheckStatusEnum.DONE.getValue());
        }
        return null;
    }

    @Override
    @Transactional
    public String changeStatesForPause(ChangeAreaOrStatesParam param) {
        if (param.getChangeType() == 2) {
            CompanyInfoVo companyInfoVo = this.infoMapper.selectCompanyInfo(param.getId());
            if (Objects.equals(param.getBusinessState(), CompanyBusinessState.NORMAL.getCode())) {
                this.infoMapper.addCompanyChangeRecord(IdWorker.getId(), StopDataSourceEnums.FWGJ.getCode(), param.getCheckId(), param.getId(), StopTypeEnums.NORMAL.getCode(), null, null, companyInfoVo.getBusinessState(), CompanyBusinessState.NORMAL.getCode());
            }
        }
        return null;
    }

    @Override
    @Transactional
    public String changeLngAndLat(ChangeLngAngLatParam param) {
        if (param.getNewLat() == null || param.getNewLng() == null) {
            throw new RuntimeException("\u5f53\u524d\u7ecf\u7eac\u5ea6\u6709\u8bef\uff0c\u8bf7\u6253\u5f00\u5b9a\u4f4d\u91cd\u8bd5");
        }
        if (param.getCid() == null) {
            throw new RuntimeException("\u4f01\u4e1aid\u4e3a\u7a7a\uff01");
        }
        param.setChangeInfoId(Long.valueOf(IdWorker.getId()));
        this.infoMapper.addLngChangeRecord(param, StopDataSourceEnums.FWGJ.getCode());
        this.infoMapper.updateCompanyLngAndLat(param);
        ThirdGjCheckInfo info = (ThirdGjCheckInfo)this.gjCheckInfoService.getById(param.getCheckId());
        if (info == null) {
            throw new ServiceException("\u63a5\u5bb3\u4eba\u6570\u5c0f\u4e8e3\u4eba\u5219\u4e0d\u68c0\u67e5\uff01");
        }
        info.setCheckFile(param.getCheckFile());
        this.gjCheckInfoService.updateById(info);
        return null;
    }

    @Override
    public JqGridData<CompanyListVo> listCompanyForClose(CompanyListParam param) {
        if (param.getOrgId() == null) {
            return null;
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<CompanyListVo> rst = this.customerMapper.listCompanyForClose(param);
        return new JqGridData((Page)rst, (JqGridParam)param);
    }

    @Transactional
    public void modifyCustomerHalfCheckStatus(ThirdGjCheckInfo checkInfo, ThirdGjOrgCustomer customer, Integer state) {
        if (customer == null && checkInfo != null) {
            customer = (ThirdGjOrgCustomer)this.customerService.getById(checkInfo.getCustomerId());
        }
        if (checkInfo.getCreateContractYear() == customer.getCurContractYear() && checkInfo.getCreateCycle() == customer.getCurCycle()) {
            if (customer.getCurCycle() == GjCustomerCycleEnum.FIRST.getValue()) {
                customer.setFirstCheckStatus(state);
            } else if (customer.getCurCycle() == GjCustomerCycleEnum.SECOND.getValue()) {
                customer.setSecondCheckStatus(state);
            }
            if (state == GjCustomerCheckStatusEnum.DONE.getValue()) {
                customer.setNeedCheck(Integer.valueOf(2));
                if (customer.getCurCycle() == GjCustomerCycleEnum.FIRST.getValue()) {
                    customer.setFirstCheckNum(Integer.valueOf(customer.getFirstCheckNum() + 1));
                } else if (customer.getCurCycle() == GjCustomerCycleEnum.SECOND.getValue()) {
                    customer.setSecondCheckNum(Integer.valueOf(customer.getSecondCheckNum() + 1));
                }
            }
        } else if (checkInfo.getCreateContractYear() == customer.getCurContractYear()) {
            if (checkInfo.getCreateCycle() == GjCustomerCycleEnum.FIRST.getValue()) {
                customer.setFirstCheckStatus(state);
            } else if (checkInfo.getCreateCycle() == GjCustomerCycleEnum.SECOND.getValue()) {
                customer.setSecondCheckStatus(state);
            }
            if (state == GjCustomerCheckStatusEnum.DONE.getValue()) {
                if (checkInfo.getCreateCycle() == GjCustomerCycleEnum.FIRST.getValue()) {
                    customer.setFirstCheckNum(Integer.valueOf(customer.getFirstCheckNum() + 1));
                } else if (checkInfo.getCreateCycle() == GjCustomerCycleEnum.SECOND.getValue()) {
                    customer.setSecondCheckNum(Integer.valueOf(customer.getSecondCheckNum() + 1));
                }
            }
        }
        if (state == GjCustomerCheckStatusEnum.DONE.getValue()) {
            customer.setWarningStatus(this.gjCheckInfoService.getCustomerWarningStatusByCustomerId(customer.getId()));
        }
        this.customerService.updateById(customer);
    }

    private List<ReformListVo> transformItem(ThirdGjCheckItem item) {
        if (item == null) {
            return null;
        }
        ThirdGjCheckInfo info = (ThirdGjCheckInfo)this.gjCheckInfoService.getById(item.getCheckId());
        CompanyInfoVo companyInfo = this.infoMapper.selectCompanyInfo(info.getCid());
        String checkName = info.getCheckName();
        String companyName = companyInfo.getName();
        ArrayList<ReformListVo> list = new ArrayList<ReformListVo>();
        if (item.getCheck1() == 0) {
            list.add(new ReformListVo(checkName + "-" + companyName + "-\u804c\u4e1a\u75c5\u9632\u6cbb\u5e74\u5ea6\u8ba1\u5212\u65b9\u6848\u4e0d\u7b26\u5408\u8981\u6c42", null, new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.OTHER.getValue()));
        }
        if (item.getCheck2() == 0) {
            list.add(new ReformListVo(checkName + "-" + companyName + "-\u5236\u5ea6\u548c\u64cd\u4f5c\u89c4\u7a0b\u4e0d\u7b26\u5408\u8981\u6c42", null, new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.OTHER.getValue()));
        }
        if (item.getCheck3() == 0) {
            list.add(new ReformListVo(checkName + "-" + companyName + "-\u6709\u5bb3\u4f5c\u4e1a\u548c\u65e0\u5bb3\u4f5c\u4e1a\u5206\u5f00\u4e0d\u7b26\u5408\u8981\u6c42", null, new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.OTHER.getValue()));
        }
        if (item.getCheck4() == 0) {
            list.add(new ReformListVo(checkName + "-" + companyName + "-\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u5b9a\u671f\u68c0\u6d4b\u4e0d\u7b26\u5408\u8981\u6c42", null, new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.DETECTION.getValue()));
        }
        if (item.getCheck5() == 0) {
            list.add(new ReformListVo(checkName + "-" + companyName + "-\u804c\u4e1a\u75c5\u5371\u5bb3\u73b0\u72b6\u8bc4\u4ef7\u4e0d\u7b26\u5408\u8981\u6c42", null, new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.OTHER.getValue()));
        }
        if (item.getCheck6() == 0) {
            list.add(new ReformListVo(checkName + "-" + companyName + "-\u804c\u4e1a\u5065\u5eb7\u4f53\u68c0\u4e0d\u7b26\u5408\u8981\u6c42", null, new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.TJ.getValue()));
        }
        if (item.getCheck7() == 0) {
            list.add(new ReformListVo(checkName + "-" + companyName + "-\u4f53\u68c0\u7ed3\u679c\u4e66\u9762\u544a\u77e5\u4e0d\u7b26\u5408\u8981\u6c42", null, new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.OTHER.getValue()));
        }
        if (item.getCheck8() == 0) {
            list.add(new ReformListVo(checkName + "-" + companyName + "-\u804c\u4e1a\u7981\u5fcc\u8bc1\u8c03\u5c97\u4e0d\u7b26\u5408\u8981\u6c42", null, new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.type_40.getValue()));
        }
        if (item.getCheck9() == 0) {
            list.add(new ReformListVo(checkName + "-" + companyName + "-\u7591\u4f3c\u804c\u4e1a\u75c5\u7684\u62a5\u544a\u548c\u8bca\u65ad", null, new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.type_50.getValue()));
        }
        if (item.getCheck10() == 0) {
            list.add(new ReformListVo(checkName + "-" + companyName + "-\u804c\u4e1a\u75c5\u9632\u6cbb\u516c\u544a\u680f\u4e0d\u7b26\u5408\u8981\u6c42", null, new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.OTHER.getValue()));
        }
        if (item.getCheck11() == 0) {
            list.add(new ReformListVo(checkName + "-" + companyName + "-\u804c\u4e1a\u75c5\u5371\u5bb3\u8b66\u793a\u6807\u8bc6\u4e0e\u544a\u77e5\u5361\u8bbe\u7f6e\u4e0d\u7b26\u5408\u8981\u6c42", null, new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.WARNING_SIGNS.getValue()));
        }
        if (item.getCheck12() == 0) {
            list.add(new ReformListVo(checkName + "-" + companyName + "-\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5\u4e0d\u7b26\u5408\u8981\u6c42", null, new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.DECLARE.getValue()));
        }
        if (item.getCheck13() == 0) {
            list.add(new ReformListVo(checkName + "-" + companyName + "-\u804c\u4e1a\u75c5\u5371\u5bb3\u52b3\u52a8\u5408\u540c\u544a\u77e5\u4e0d\u7b26\u5408\u8981\u6c42", null, new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.OTHER.getValue()));
        }
        if (item.getCheck14() == 0) {
            list.add(new ReformListVo(checkName + "-" + companyName + "-\u4e3b\u8981\u8d1f\u8d23\u4eba\u548c\u804c\u4e1a\u5065\u5eb7\u7ba1\u7406\u5458\u57f9\u8bad\u4e0d\u7b26\u5408\u8981\u6c42", null, new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.TRAIN.getValue()));
        }
        if (item.getCheck15() == 0) {
            list.add(new ReformListVo(checkName + "-" + companyName + "-\u751f\u4ea7\u3001\u7ecf\u8425\u3001\u8fdb\u53e3\u3001\u4f7f\u7528\u56fd\u5bb6\u660e\u4ee4\u7981\u6b62\u7684\u8bbe\u5907\u548c\u6750\u6599", null, new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.OTHER.getValue()));
        }
        if (item.getCheck16() == 0) {
            list.add(new ReformListVo(checkName + "-" + companyName + "-\u804c\u4e1a\u75c5\u5371\u5bb3\u4f5c\u4e1a\u8f6c\u79fb\u4e0d\u7b26\u5408\u8981\u6c42", null, new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.OTHER.getValue()));
        }
        if (item.getCheck17() == 0) {
            list.add(new ReformListVo(checkName + "-" + companyName + "-\u5458\u5de5\u804c\u4e1a\u5065\u5eb7\u57f9\u8bad\u4e0d\u7b26\u5408\u8981\u6c42", null, new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.OTHER.getValue()));
        }
        if (item.getCheck18() == 0) {
            list.add(new ReformListVo(checkName + "-" + companyName + "-\u9632\u62a4\u8bbe\u65bd\u914d\u5907\u548c\u4f7f\u7528\u60c5\u51b5\u4e0d\u7b26\u5408\u8981\u6c42", null, new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.OTHER.getValue()));
        }
        if (item.getCheck19() == 0) {
            list.add(new ReformListVo(checkName + "-" + companyName + "-\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u914d\u7f6e\u548c\u4f7f\u7528\u60c5\u51b5\u4e0d\u7b26\u5408\u8981\u6c42", null, new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.PROTECTION.getValue()));
        }
        if (item.getCheck20() == 0) {
            list.add(new ReformListVo(checkName + "-" + companyName + "-\u5efa\u8bbe\u9879\u76ee\u804c\u4e1a\u75c5\u9632\u62a4\u8bbe\u65bd\u4e09\u540c\u65f6\u4e0d\u7b26\u5408\u8981\u6c42", null, new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.THREE_TIME.getValue()));
        }
        if (item.getCheck21() == 0) {
            list.add(new ReformListVo(checkName + "-" + companyName + "-\u76d1\u7ba1\u90e8\u95e8\u9650\u671f\u6574\u6539\u4e8b\u9879\u4e0d\u7b26\u5408\u8981\u6c42", null, new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.OTHER.getValue()));
        }
        if (item.getCheck22() == 0) {
            list.add(new ReformListVo(checkName + "-" + companyName + "-\u804c\u4e1a\u536b\u751f\u6863\u6848\u4e0d\u7b26\u5408\u8981\u6c42", null, new Date(), Integer.valueOf(1), ReformGenerationSourceEnum.ARCHIVES.getValue()));
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional
    public Boolean pushCompanyChange(CompanyChangePushParam param) {
        CompanyProposedChange entity;
        CompanyInfoVo company = this.infoMapper.selectCompanyInfo(param.getCid());
        if (Objects.isNull(company)) {
            throw new ServiceException("\u8be5\u4f01\u4e1a\u4e0d\u5b58\u5728\u4e8e\u6d59\u91cc\u536b\u4f01");
        }
        Integer stopType = param.getStopType();
        Integer reasonType = param.getReasonType();
        String fileIds = param.getFileIds();
        Long stopAreaId = param.getStopAreaId();
        String repeatCid = param.getRepeatCid();
        LocalDateTime now = LocalDateTime.now();
        String sourceId = param.getSourceId();
        String contactName = param.getContactName();
        String contactTel = param.getContactTel();
        Boolean historicalData = false;
        Long userId = param.getUserId();
        Long cid = param.getCid();
        if (!(StopTypeEnums.CLOSE.getCode().equals(stopType) || StopTypeEnums.CHANGECROSS.getCode().equals(stopType) || StopTypeEnums.CHANGEWITHIN.getCode().equals(stopType) || StopTypeEnums.CHANGEDISTRICTWITHIN.getCode().equals(stopType) || StopTypeEnums.NORMAL.getCode().equals(stopType))) {
            throw new HealthException("stopType\u53c2\u6570\u975e\u6cd5");
        }
        CompanyProposedChangeClueLastParam clueLastParam = new CompanyProposedChangeClueLastParam();
        clueLastParam.setStopDataSource(StopDataSourceEnums.FWGJ.getCode());
        clueLastParam.setCid(param.getCid());
        if (StopTypeEnums.CLOSE.getCode().equals(stopType) || StopTypeEnums.NORMAL.getCode().equals(stopType)) {
            clueLastParam.setStopTypeList(Arrays.asList(StopTypeEnums.CLOSE.getCode(), StopTypeEnums.NORMAL.getCode()));
        } else {
            clueLastParam.setStopTypeList(Arrays.asList(StopTypeEnums.CHANGECROSS.getCode(), StopTypeEnums.CHANGEWITHIN.getCode(), StopTypeEnums.CHANGEDISTRICTWITHIN.getCode()));
        }
        List clueList = this.companyProposedChangeProviderService.getClueList(clueLastParam);
        clueList = clueList.stream().filter(i -> StopStatusEnums.PENDING_CONFIRMATION.getCode().equals(i.getStatus()) || StopStatusEnums.PROCESS.getCode().equals(i.getStatus())).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(clueList)) {
            Map<String, CompanyProposedChange> clueMap = clueList.stream().collect(Collectors.toMap(CompanyProposedChange::getSourceId, companyProposedChange -> companyProposedChange, (v1, v2) -> v2));
            entity = clueMap.get(sourceId);
            if (Objects.nonNull(entity)) {
                if (Objects.equals(entity.getSourceId(), sourceId)) {
                    if (!StopStatusEnums.PENDING_CONFIRMATION.getCode().equals(entity.getStatus())) throw new ServiceException(ResponseStateEnum.fail.getValue(), String.format("\u8be5\u4f01\u4e1a\u5df2\u5b58\u5728\u76f8\u540c\u7c7b\u578b\u7684\u4fe1\u606f\u53d8\u66f4\u7ebf\u7d22\uff0c\u7ebf\u7d22\u72b6\u6001\u662f %s", StopStatusEnums.getName((Integer)entity.getStatus())));
                    entity.setStopType(stopType);
                    entity.setStopAreaId(stopAreaId);
                    entity.setReasonType(reasonType);
                    entity.setFileIds(fileIds);
                    entity.setRepeatCid(repeatCid);
                    entity.setConfirmTime(null);
                    entity.setContactName(contactName);
                    entity.setContactTel(contactTel);
                    entity.setUpdateBy(userId);
                    entity.setUpdateDate(now);
                    entity.setHistoricalData(historicalData);
                } else if (StopTypeEnums.CLOSE.getCode().equals(stopType) || StopTypeEnums.NORMAL.getCode().equals(stopType)) {
                    if (!StopStatusEnums.PENDING_CONFIRMATION.getCode().equals(entity.getStatus())) throw new ServiceException(ResponseStateEnum.fail.getValue(), String.format("\u8be5\u4f01\u4e1a\u5df2\u5b58\u5728\u76f8\u540c\u7c7b\u578b\u7684\u4fe1\u606f\u53d8\u66f4\u7ebf\u7d22\uff0c\u7ebf\u7d22\u72b6\u6001\u662f %s\uff0c\u65e0\u6cd5\u65b0\u589e", StopStatusEnums.getName((Integer)entity.getStatus())));
                    entity = new CompanyProposedChange();
                    entity.setStopDataSource(StopDataSourceEnums.FWGJ.getCode());
                    entity.setSourceId(sourceId);
                    entity.setCid(cid);
                    entity.setStopType(stopType);
                    entity.setStopAreaId(stopAreaId);
                    entity.setReasonType(reasonType);
                    entity.setFileIds(fileIds);
                    entity.setRepeatCid(repeatCid);
                    entity.setStatus(StopStatusEnums.PENDING_CONFIRMATION.getCode());
                    entity.setConfirmTime(null);
                    entity.setContactName(contactName);
                    entity.setContactTel(contactTel);
                    entity.setCreateBy(userId);
                    entity.setCreateDate(now);
                    entity.setUpdateBy(userId);
                    entity.setUpdateDate(now);
                    entity.setIsValid(Boolean.valueOf(true));
                    entity.setHistoricalData(historicalData);
                } else {
                    if (stopAreaId.equals(entity.getStopAreaId())) {
                        throw new ServiceException(ResponseStateEnum.fail.getValue(), String.format("\u8be5\u4f01\u4e1a\u5df2\u5b58\u5728\u76f8\u540c\u7c7b\u578b\u7684\u4fe1\u606f\u53d8\u66f4\u7ebf\u7d22\uff0c\u7ebf\u7d22\u72b6\u6001\u662f %s\uff0c\u53d8\u66f4\u5730\u5740\u76f8\u540c\uff0c\u65e0\u6cd5\u65b0\u589e", StopStatusEnums.getName((Integer)entity.getStatus())));
                    }
                    entity = new CompanyProposedChange();
                    entity.setStopDataSource(StopDataSourceEnums.FWGJ.getCode());
                    entity.setSourceId(sourceId);
                    entity.setCid(cid);
                    entity.setStopType(stopType);
                    entity.setStopAreaId(stopAreaId);
                    entity.setReasonType(reasonType);
                    entity.setFileIds(fileIds);
                    entity.setRepeatCid(repeatCid);
                    entity.setStatus(StopStatusEnums.PENDING_CONFIRMATION.getCode());
                    entity.setConfirmTime(null);
                    entity.setContactName(contactName);
                    entity.setContactTel(contactTel);
                    entity.setCreateBy(userId);
                    entity.setCreateDate(now);
                    entity.setUpdateBy(userId);
                    entity.setUpdateDate(now);
                    entity.setIsValid(Boolean.valueOf(true));
                    entity.setHistoricalData(historicalData);
                }
            } else {
                if (StopTypeEnums.CLOSE.getCode().equals(stopType) || StopTypeEnums.NORMAL.getCode().equals(stopType)) {
                    for (CompanyProposedChange existing : clueList) {
                        if (!stopType.equals(existing.getStopType())) continue;
                        throw new ServiceException(ResponseStateEnum.fail.getValue(), "\u8be5\u4f01\u4e1a\u5df2\u5b58\u5728\u76f8\u540c\u7c7b\u578b\u7684\u4fe1\u606f\u53d8\u66f4\u7ebf\u7d22\uff0c\u65e0\u6cd5\u65b0\u589e");
                    }
                } else {
                    for (CompanyProposedChange existing : clueList) {
                        Integer existingStopType = existing.getStopType();
                        if (!StopTypeEnums.CHANGECROSS.getCode().equals(existingStopType) && !StopTypeEnums.CHANGEWITHIN.getCode().equals(existingStopType) && !StopTypeEnums.CHANGEDISTRICTWITHIN.getCode().equals(existingStopType) || !stopAreaId.equals(existing.getStopAreaId())) continue;
                        throw new ServiceException(ResponseStateEnum.fail.getValue(), "\u8be5\u4f01\u4e1a\u5df2\u5b58\u5728\u76f8\u540c\u7c7b\u578b\u7684\u4fe1\u606f\u53d8\u66f4\u7ebf\u7d22\uff0c\u53d8\u66f4\u5730\u5740\u76f8\u540c\uff0c\u65e0\u6cd5\u65b0\u589e");
                    }
                }
                entity = new CompanyProposedChange();
                entity.setStopDataSource(StopDataSourceEnums.FWGJ.getCode());
                entity.setSourceId(sourceId);
                entity.setCid(cid);
                entity.setStopType(stopType);
                entity.setStopAreaId(stopAreaId);
                entity.setReasonType(reasonType);
                entity.setFileIds(fileIds);
                entity.setRepeatCid(repeatCid);
                entity.setStatus(StopStatusEnums.PENDING_CONFIRMATION.getCode());
                entity.setConfirmTime(null);
                entity.setContactName(contactName);
                entity.setContactTel(contactTel);
                entity.setCreateBy(userId);
                entity.setCreateDate(now);
                entity.setUpdateBy(userId);
                entity.setUpdateDate(now);
                entity.setIsValid(Boolean.valueOf(true));
                entity.setHistoricalData(historicalData);
            }
        } else {
            entity = new CompanyProposedChange();
            entity.setStopDataSource(StopDataSourceEnums.FWGJ.getCode());
            entity.setSourceId(sourceId);
            entity.setCid(cid);
            entity.setStopType(stopType);
            entity.setStopAreaId(stopAreaId);
            entity.setReasonType(reasonType);
            entity.setFileIds(fileIds);
            entity.setRepeatCid(repeatCid);
            entity.setStatus(StopStatusEnums.PENDING_CONFIRMATION.getCode());
            entity.setConfirmTime(null);
            entity.setContactName(contactName);
            entity.setContactTel(contactTel);
            entity.setCreateBy(userId);
            entity.setCreateDate(now);
            entity.setUpdateBy(userId);
            entity.setUpdateDate(now);
            entity.setIsValid(Boolean.valueOf(true));
            entity.setHistoricalData(historicalData);
        }
        SysAreaV3OneVo stopArea = null;
        if (StopTypeEnums.CLOSE.getCode().equals(stopType)) {
            if (Objects.isNull(reasonType)) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u539f\u56e0\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!(StopTypeForReasonEnums.ONE.getCode().equals(reasonType) || StopTypeForReasonEnums.TWO.getCode().equals(reasonType) || StopTypeForReasonEnums.THREE.getCode().equals(reasonType) || StopTypeForReasonEnums.FOUR.getCode().equals(reasonType))) {
                throw new HealthException("reasonType\u53c2\u6570\u975e\u6cd5");
            }
            if (StopTypeForReasonEnums.TWO.getCode().equals(reasonType)) {
                if (StrUtil.isBlank((CharSequence)repeatCid)) {
                    throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u91cd\u590d\u4f01\u4e1acid\u4e0d\u80fd\u4e3a\u7a7a");
                }
                List repeatCidList = StrUtil.split((CharSequence)repeatCid, (CharSequence)",");
                if (CollUtil.isEmpty((Collection)repeatCidList)) {
                    throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u91cd\u590d\u4f01\u4e1acid\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            if (StrUtil.isBlank((CharSequence)fileIds)) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u4f50\u8bc1\u6750\u6599\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isNotBlank((CharSequence)fileIds)) {
                fileIdList = StrUtil.split((CharSequence)fileIds, (CharSequence)",");
                if (CollUtil.isEmpty((Collection)fileIdList)) {
                    throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u4f50\u8bc1\u6750\u6599\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (fileIdList.size() > 3) {
                    throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u4f50\u8bc1\u6750\u6599\u6700\u591a\u4e09\u4efd");
                }
            }
            if (CompanyBusinessState.CLOSE.getCode().byteValue() == company.getBusinessState().intValue()) {
                entity.setStatus(StopStatusEnums.CONFIRMED.getCode());
                entity.setConfirmTime(LocalDateTime.now());
            }
        } else if (StopTypeEnums.CHANGECROSS.getCode().equals(stopType)) {
            if (Objects.isNull(stopAreaId)) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)fileIds)) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u4f50\u8bc1\u6750\u6599\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isNotBlank((CharSequence)fileIds)) {
                fileIdList = StrUtil.split((CharSequence)fileIds, (CharSequence)",");
                if (CollUtil.isEmpty((Collection)fileIdList)) {
                    throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u4f50\u8bc1\u6750\u6599\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (fileIdList.size() > 3) {
                    throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u4f50\u8bc1\u6750\u6599\u6700\u591a\u4e09\u4efd");
                }
            }
            if (Objects.isNull(stopArea = this.areaProvideService.getAreaByIdV3(stopAreaId))) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u4e0d\u5b58\u5728");
            }
            if (stopAreaId != 0L && stopArea.getLevel() < 3) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u9700\u7cbe\u786e\u5230\u533a\u53bf\u7ea7\u522b");
            }
            area = this.areaProvideService.getAreaByIdV3(company.getAreaId());
            if (stopAreaId != 0L && Objects.equals(stopArea.getCityId(), area.getCityId())) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.CHANGECROSS.getName() + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u4e0d\u80fd\u662f\u539f\u5740\u7684\u672c\u5e02\u8303\u56f4\u5185");
            }
        } else if (StopTypeEnums.CHANGEWITHIN.getCode().equals(stopType)) {
            if (Objects.isNull(stopAreaId)) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isNotBlank((CharSequence)fileIds) && CollUtil.isNotEmpty((Collection)(fileIdList = StrUtil.split((CharSequence)fileIds, (CharSequence)","))) && fileIdList.size() > 3) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u4f50\u8bc1\u6750\u6599\u6700\u591a\u4e09\u4efd");
            }
            stopArea = this.areaProvideService.getAreaByIdV3(stopAreaId);
            if (Objects.isNull(stopArea)) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u4e0d\u5b58\u5728");
            }
            if (stopArea.getLevel() < 3) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u9700\u7cbe\u786e\u5230\u533a\u53bf\u7ea7\u522b");
            }
            area = this.areaProvideService.getAreaByIdV3(company.getAreaId());
            if (stopAreaId != 0L && !Objects.equals(stopArea.getCityId(), area.getCityId())) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.CHANGEWITHIN.getName() + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u5fc5\u987b\u662f\u539f\u5740\u7684\u672c\u5e02\u8303\u56f4\u5185");
            }
        } else if (StopTypeEnums.CHANGEDISTRICTWITHIN.getCode().equals(stopType)) {
            if (Objects.isNull(stopAreaId)) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isNotBlank((CharSequence)fileIds) && CollUtil.isNotEmpty((Collection)(fileIdList = StrUtil.split((CharSequence)fileIds, (CharSequence)","))) && fileIdList.size() > 3) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u4f50\u8bc1\u6750\u6599\u6700\u591a\u4e09\u4efd");
            }
            stopArea = this.areaProvideService.getAreaByIdV3(stopAreaId);
            if (Objects.isNull(stopArea)) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u4e0d\u5b58\u5728");
            }
            if (stopArea.getLevel() < 4) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u9700\u7cbe\u786e\u5230\u8857\u9053\u7ea7\u522b");
            }
        }
        try {
            entity.setBeforeAreaId(company.getAreaId());
            entity.setBeforeBusinessState(company.getBusinessState());
            if (StopTypeEnums.CLOSE.getCode().equals(stopType)) {
                entity.setStopBusinessState(CompanyBusinessState.CLOSE.getCode());
            } else if (StopTypeEnums.NORMAL.getCode().equals(stopType)) {
                entity.setStopBusinessState(CompanyBusinessState.NORMAL.getCode());
            }
            this.companyProposedChangeProviderService.saveOrUpdate(entity);
            return true;
        }
        catch (Exception e) {
            log.error("\u536b\u751f\u76d1\u7763\u534f\u7ba1-\u4e0a\u62a5\u7528\u4eba\u5355\u4f4d\u4fe1\u606f\u53d8\u66f4\u60c5\u51b5\u5931\u8d25\uff1a", (Throwable)e);
            return false;
        }
    }

    @Generated
    public ThirdGjManageImpl(ThreadPoolTaskExecutor threadPoolTaskExecutor) {
        this.threadPoolTaskExecutor = threadPoolTaskExecutor;
    }
}

