/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.manage.impl;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.fwgj.converter.GjPatrolInfoConverter;
import cn.smarthse.fwgj.dao.ReformItemBasicMapper;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjCheckInfo;
import cn.smarthse.fwgj.manage.IReformManage;
import cn.smarthse.fwgj.model.param.ReformParam;
import cn.smarthse.fwgj.model.param.SaveReformRecordParam;
import cn.smarthse.fwgj.model.vo.PatrolInfoVo;
import cn.smarthse.fwgj.model.vo.ReformDetailVo;
import cn.smarthse.fwgj.model.vo.ReformItemSource;
import cn.smarthse.fwgj.model.vo.ReformRecordDetailVo;
import cn.smarthse.fwgj.model.vo.check.ReformVo;
import cn.smarthse.fwgj.model.vo.third.ReformStasticsVo;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjCheckInfoService;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.entity.work.reform.param.ReformRecordAcceptanceParam;
import cn.smarthse.modules.health.enums.reform.ReformSourceLiteEnum;
import cn.smarthse.modules.health.enums.reform.ReformStatusEnum;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.platform.model.AreaModel;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ReformManageImpl
implements IReformManage {
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaProvideService;
    @DubboReference
    private ISysFileProvideService fileProvideService;
    @DubboReference
    private IReformItemBasicService reformItemBasicService;
    private final IThirdGjCheckInfoService checkInfoService;
    private final ReformItemBasicMapper baseMapper;
    private final GjPatrolInfoConverter patrolInfoConverter;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideService;
    private String deadline = "03-01";

    @Override
    public List<ReformVo> getReformListByCheckId(Long checkId) {
        return this.baseMapper.getReformList(checkId, null);
    }

    @Override
    public List<ReformVo> getReformListByPatrolId2(Long patrolId) {
        return this.baseMapper.getReformList(patrolId, ReformStatusEnum.DYS.getValue());
    }

    @Override
    public List<ReformVo> getReformListByCid(Long cid) {
        return this.baseMapper.getReformListByCid(cid, null);
    }

    @Override
    public List<ReformVo> getReformListByCid2(Long cid) {
        return this.baseMapper.getReformListByCid(cid, ReformStatusEnum.DYS.getValue());
    }

    @Override
    public List<ReformVo> getPastReformList(Long patrolId, Long orgId) {
        return this.baseMapper.getPastReformList(patrolId, orgId);
    }

    @Override
    public List<ReformVo> getPastReformListByCid(Long patrolId, Long cid) {
        return this.baseMapper.getPastReformListByCid(patrolId, cid);
    }

    @Override
    public JqGridData<ReformVo> getReformListData(ReformParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new JqGridData(new PageInfo(this.baseMapper.getReformListData(param)), (JqGridParam)param);
    }

    @Override
    public ReformDetailVo getReform(Long reformId) {
        if (reformId == null) {
            return null;
        }
        return this.baseMapper.getReform(reformId);
    }

    @Override
    public ReformDetailVo getReformV2(Long reformId) {
        if (reformId == null) {
            return null;
        }
        Long sourceId = reformId;
        ReformDetailVo exists = this.getReform(reformId);
        if (exists != null) {
            reformId = exists.getBasicId();
        }
        ReformDetailVo result = new ReformDetailVo();
        result.setReformItemSourceList(this.getReformItemSourceList(reformId));
        result.setReformRecordList(this.getReformRecordList(reformId));
        if (result.getReformItemSourceList() != null) {
            ReformItemSource source = result.getReformItemSourceList().stream().filter(r -> r.getReformId().equals(sourceId)).findFirst().orElse(new ReformItemSource());
            BeanUtils.copyProperties((Object)source, (Object)result);
            if (result.getFindTime() != null) {
                if (!(result.getStatus() != ReformStatusEnum.WC.getValue() && result.getStatus() != ReformStatusEnum.WXZG.getValue() || DateUtils.getYear((Date)result.getFindTime()) != LocalDate.now().getYear() || CollectionUtils.isEmpty((Collection)result.getReformRecordList()))) {
                    LocalDate acceptanceDate = result.getReformRecordList().stream().max(Comparator.comparing(ReformRecordDetailVo::getReformRecordId)).get().getAcceptanceDate();
                    if (acceptanceDate != null && !acceptanceDate.isBefore(LocalDate.of(LocalDate.now().getYear(), 1, 1)) && !acceptanceDate.isAfter(LocalDate.of(LocalDate.now().getYear(), 3, 1))) {
                        result.setFindTimeStr("\u65e0\u9700\u63a8\u9001");
                        result.setFindTimeRemark(LocalDate.now().getYear() + "-" + this.deadline + "\u4e4b\u524d\u5316\u89e3\u7684\u98ce\u9669\u4e0d\u8fdb\u884c\u98ce\u9669\u63a8\u9001\uff01");
                    } else {
                        result.setFindTimeStr(DateUtil.format((Date)result.getFindTime(), (String)"yyyy-MM-dd"));
                    }
                } else {
                    result.setFindTimeStr(DateUtil.format((Date)result.getFindTime(), (String)"yyyy-MM-dd"));
                }
            }
            if (ReformSourceLiteEnum.FWGJ.getValue().equals(result.getReformItemSource())) {
                ThirdGjCheckInfo checkInfo = (ThirdGjCheckInfo)this.checkInfoService.getById(source.getReformItemSourceId());
                PatrolInfoVo comany = this.patrolInfoConverter.EntityToVo(checkInfo);
                if (checkInfo != null) {
                    comany.setCheckFileUrl(this.fileProvideService.getListByIds(checkInfo.getCheckFile()));
                }
                result.setComany(comany);
            } else {
                CompanySuperviseModel company = this.companyProvideService.getCompanyInfoById(result.getCid());
                if (company != null) {
                    result.setComany(this.patrolInfoConverter.CompanyPlatformModel2PatrolInfoVo(company));
                }
            }
        }
        return result;
    }

    private List<ReformItemSource> getReformItemSourceList(Long basicId) {
        List<ReformItemSource> list = this.baseMapper.getReformItemSourceList(basicId);
        if (list == null) {
            return null;
        }
        Map<Byte, List<ReformItemSource>> map = list.stream().collect(Collectors.groupingBy(ReformItemSource::getReformItemSource));
        for (Byte reformItemSource : map.keySet()) {
            List<ReformItemSource> reformItemSources = map.get(reformItemSource);
            for (int i = 0; i < reformItemSources.size(); ++i) {
                reformItemSources.get(i).setBatchNum(Integer.valueOf(i + 1));
            }
        }
        return list;
    }

    @Override
    public ReformRecordDetailVo getReformRecord(Long reformRecordId) {
        if (reformRecordId == null) {
            return null;
        }
        ReformRecordDetailVo reformRecord = this.baseMapper.getReformRecord(reformRecordId);
        if (reformRecord != null) {
            reformRecord.setReformFinishedFileList(this.fileProvideService.getListByIds(reformRecord.getReformFinishedFiles()));
            reformRecord.setAcceptanceFileList(this.fileProvideService.getListByIds(reformRecord.getAcceptanceFiles()));
        }
        return reformRecord;
    }

    @Override
    public List<ReformRecordDetailVo> getReformRecordList(Long reformId) {
        if (reformId == null) {
            return null;
        }
        List<ReformRecordDetailVo> reformRecordList = this.baseMapper.getReformRecordList(reformId);
        reformRecordList.forEach(reformRecord -> {
            reformRecord.setReformFinishedFileList(this.fileProvideService.getListByIds(reformRecord.getReformFinishedFiles()));
            reformRecord.setAcceptanceFileList(this.fileProvideService.getListByIds(reformRecord.getAcceptanceFiles()));
        });
        return reformRecordList;
    }

    @Override
    public ReformStasticsVo getReformStatisticsByCid(Long cid) {
        return this.baseMapper.getReformStatisticsByCid(cid);
    }

    @Override
    public ReformStasticsVo getReformStatistics(Long patrolId) {
        return this.baseMapper.getReformStatistics(patrolId);
    }

    @Override
    public void saveReformRecord(SaveReformRecordParam param) {
        ReformRecordAcceptanceParam dto = new ReformRecordAcceptanceParam();
        ReformDetailVo reform = this.baseMapper.getReform(param.getReformId());
        if (reform == null) {
            dto.setReformItemId(param.getReformId());
        } else {
            dto.setReformItemId(reform.getBasicId());
        }
        dto.setUserId(param.getUserId());
        dto.setFullName(param.getFullName());
        dto.setAcceptanceResultExplain(param.getSituationDescription());
        dto.setAcceptanceDirectorName(param.getAcceptanceDirectorName());
        dto.setAcceptanceFiles(param.getAcceptanceFiles());
        if (param.getStatus().intValue() == ReformStatusEnum.TH.getValue().intValue()) {
            dto.setAcceptanceResult(Byte.valueOf((byte)0));
        } else {
            dto.setAcceptanceResult(Byte.valueOf((byte)1));
        }
        this.reformItemBasicService.reformRecordAcceptance(dto);
    }

    @Override
    public ReformStasticsVo getHomeData(Long orgId) {
        return this.baseMapper.getHomeData(orgId);
    }

    private Byte getAreaLevel(Long areaId) {
        AreaModel area = this.areaProvideService.getAreaById(areaId);
        return area != null ? area.getLevel() : null;
    }

    @Generated
    public ReformManageImpl(IThirdGjCheckInfoService checkInfoService, ReformItemBasicMapper baseMapper, GjPatrolInfoConverter patrolInfoConverter) {
        this.checkInfoService = checkInfoService;
        this.baseMapper = baseMapper;
        this.patrolInfoConverter = patrolInfoConverter;
    }
}

