/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.manage.impl;

import cn.smarthse.fwgj.enums.ThirdGjUserLogForbiddenStateEnum;
import cn.smarthse.fwgj.manage.IHomeManage;
import cn.smarthse.fwgj.manage.IReformManage;
import cn.smarthse.fwgj.model.vo.HomeData;
import cn.smarthse.fwgj.model.vo.admin.GjOrgListAdminVo;
import cn.smarthse.fwgj.model.vo.third.ReformStasticsVo;
import cn.smarthse.fwgj.service.sys.IThirdGjUserLogService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjCheckInfoService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjOrgCustomerService;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HomeManageImpl
implements IHomeManage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HomeManageImpl.class);
    private final IThirdGjUserLogService thirdGjUserLogService;
    private final IThirdGjCheckInfoService checkInfoService;
    private final IThirdGjOrgCustomerService thirdGjOrgCustomerService;
    private final IReformManage reformManage;

    @Override
    public List<GjOrgListAdminVo> getOrgList(Long gjUserId) {
        if (gjUserId == null) {
            return null;
        }
        List<GjOrgListAdminVo> list = this.thirdGjUserLogService.getGjOrgList(gjUserId);
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(record -> {
                if (!ThirdGjUserLogForbiddenStateEnum.PASS.getValue().equals(record.getForbiddenState())) {
                    record.setOrgName(record.getOrgName() + "\uff08\u7981\u7528\uff09");
                }
            });
        }
        return list;
    }

    @Override
    @Cacheable(value={"homeData=15m"}, key="#orgId", unless="#result == null")
    public HomeData getHomeData(Long orgId) {
        HomeData result = new HomeData();
        HomeData data = this.thirdGjOrgCustomerService.getHomeData(orgId, new Date());
        if (data != null) {
            result.setUnCheckNum(data.getUnCheckNum());
            result.setNeedCheckNum(data.getNeedCheckNum());
            result.setLastUpdateDate(data.getLastUpdateDate());
        }
        ReformStasticsVo reformStasticsVo = this.reformManage.getHomeData(orgId);
        result.setUnacceptRiskNum(reformStasticsVo.getUnacceptRiskNum());
        result.setUnReformRiskNum(reformStasticsVo.getUnReformRiskNum());
        result.setReformRiskNum(reformStasticsVo.getReformRiskNum());
        return result;
    }

    @Generated
    public HomeManageImpl(IThirdGjUserLogService thirdGjUserLogService, IThirdGjCheckInfoService checkInfoService, IThirdGjOrgCustomerService thirdGjOrgCustomerService, IReformManage reformManage) {
        this.thirdGjUserLogService = thirdGjUserLogService;
        this.checkInfoService = checkInfoService;
        this.thirdGjOrgCustomerService = thirdGjOrgCustomerService;
        this.reformManage = reformManage;
    }
}

