/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.framework.interceptor;

import cn.hutool.core.convert.Convert;
import cn.smarthse.fwgj.bootstrap.security.ShiroUtil;
import cn.smarthse.modules.datacentre.model.bigdata.BigLog;
import cn.smarthse.modules.datacentre.provider.bigdata.IBigDataLogProviderService;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.sx.log.enums.ActionTypeEnum;
import com.sx.log.enums.UserRoleEnum;
import com.sx.log.util.LogUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;

public class BigDataLogInterceptor
implements HandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BigDataLogInterceptor.class);
    @DubboReference
    private IBigDataLogProviderService bigDataLogProviderService;
    @Value(value="${bigLog.appCode}")
    private String appCode;

    public void postHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, ModelAndView modelAndView) throws IOException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        if (handler == null) {
            throw new NullPointerException("handler is marked non-null but is null");
        }
        if (handler instanceof HandlerMethod) {
            BigLog bigLog = (BigLog)((HandlerMethod)handler).getMethodAnnotation(BigLog.class);
            if (bigLog == null) {
                return;
            }
            Long userId = ShiroUtil.getLoginUserId();
            Long regionId = ShiroUtil.getOrgAreaId();
            if (userId == null || regionId == null) {
                return;
            }
            String businessId = this.resolveBusinessId(request, bigLog.businessIdParamName());
            String areaCode = Convert.toStr((Object)regionId).substring(0, Math.min(Convert.toStr((Object)regionId).length(), 9));
            ActionTypeEnum actionType = bigLog.actionType();
            String actionId = actionType == ActionTypeEnum.LOGIN_TYPE ? "" : bigLog.businessModule().getValue().concat(businessId);
            UserRoleEnum userRole = bigLog.userRole();
            this.bigDataLogProviderService.handleBigDataLog(actionType, userRole, actionId, userId, areaCode, this.appCode);
            switch (actionType) {
                case LOGIN_TYPE: {
                    LogUtils.login((String)Convert.toStr((Object)userId), (UserRoleEnum)userRole, (String)areaCode);
                    break;
                }
                case WORK_START_TYPE: {
                    LogUtils.workStart((String)Convert.toStr((Object)userId), (UserRoleEnum)userRole, (String)areaCode, (String)actionId);
                    break;
                }
                case WORK_END_TYPE: {
                    LogUtils.workEnd((String)Convert.toStr((Object)userId), (UserRoleEnum)userRole, (String)areaCode, (String)actionId);
                    break;
                }
            }
        }
    }

    private String resolveBusinessId(HttpServletRequest request, String paramName) throws IOException {
        String requestBody;
        JsonObject jsonObject;
        String id = request.getParameter(paramName);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            return id;
        }
        Map<String, String> pathVars = this.getPathVariables(request);
        id = pathVars.get(paramName);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            return id;
        }
        if (request.getContentType() != null && request.getContentType().contains("application/json") && (jsonObject = JsonParser.parseString((String)(requestBody = IOUtils.toString((InputStream)request.getInputStream(), (String)request.getCharacterEncoding()))).getAsJsonObject()).has(paramName)) {
            return jsonObject.get(paramName).getAsString();
        }
        Object attr = request.getAttribute(paramName);
        if (attr != null) {
            return attr.toString();
        }
        String[] uriParts = request.getRequestURI().split("/");
        return uriParts.length > 0 ? uriParts[uriParts.length - 1] : "";
    }

    private Map<String, String> getPathVariables(HttpServletRequest request) {
        return (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
    }

    @Generated
    public BigDataLogInterceptor() {
    }
}

