/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.framework.aspect;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.annotation.LogConstans;
import cn.smarthse.framework.core.utils.ServletUtils;
import cn.smarthse.framework.core.utils.StringUtils;
import cn.smarthse.fwgj.bootstrap.security.ShiroUtil;
import cn.smarthse.fwgj.framework.Constant;
import cn.smarthse.fwgj.service.sys.ISysLogService;
import cn.smarthse.modules.health.entity.sys.SysLog;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LogAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    private final ThreadPoolTaskExecutor taskExecutor;
    private final ISysLogService logService;

    @Pointcut(value=" @annotation(cn.smarthse.common.annotation.Log)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object afterCompletion(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Object proceed = joinPoint.proceed();
        this.addLog(method.getAnnotation(Log.class));
        return proceed;
    }

    private void addLog(Log logAnno) {
        if (logAnno != null) {
            byte type = logAnno.type();
            HttpServletRequest request = ServletUtils.getRequest();
            if (type == 1) {
                String token = ServletUtils.getResponse().getHeader(Constant.TOKEN_HEADER_NAME);
            } else {
                String token = request.getHeader(Constant.TOKEN_HEADER_NAME);
            }
            Long userId = ShiroUtil.getLoginUserId();
            SysLog syslog = new SysLog();
            syslog.setCid(ShiroUtil.getLoginUserId());
            syslog.setUsername(ShiroUtil.getLoginUsername());
            syslog.setFullname(ShiroUtil.getLoginUserNickname());
            syslog.setTitle(logAnno.title());
            syslog.setType(Byte.valueOf(type));
            syslog.setRequestMethod(request.getMethod());
            syslog.setRemoteIp(ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]));
            Map parameterMap = request.getParameterMap();
            syslog.setParams(StringUtils.substring(type == 1 || type == 26 ? null : (CollectionUtil.isNotEmpty((Map)parameterMap) ? JSONUtil.toJsonStr((Object)parameterMap) : ServletUtils.getBody((ServletRequest)request)), (int)0, (int)255));
            syslog.setRequestUri(ServletUtils.getRequestUri((HttpServletRequest)request));
            syslog.setUserAgent(ServletUtils.getUserAgent((HttpServletRequest)request));
            syslog.setLogSource(Byte.valueOf(LogConstans.FWGJ.getValue().byteValue()));
            syslog.setCreateDate(new Date());
            syslog.setCreateBy(userId);
            try {
                if (this.taskExecutor != null) {
                    this.taskExecutor.execute(() -> this.logService.addLog(syslog));
                } else {
                    this.logService.addLog(syslog);
                }
            }
            catch (Exception e) {
                log.error("Exception: ", (Throwable)e);
            }
        }
    }

    @Generated
    public LogAspect(ThreadPoolTaskExecutor taskExecutor, ISysLogService logService) {
        this.taskExecutor = taskExecutor;
        this.logService = logService;
    }
}

