/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.controller.app;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.fwgj.bootstrap.security.JwtUtil;
import cn.smarthse.fwgj.bootstrap.security.ShiroUtil;
import cn.smarthse.fwgj.entity.sys.ThirdGjUser;
import cn.smarthse.fwgj.model.param.ModifyPasswordByOldPwdParam;
import cn.smarthse.fwgj.model.param.ModifyPasswordParam;
import cn.smarthse.fwgj.service.sys.IThirdGjUserService;
import lombok.Generated;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/m/user"})
@Validated
public class UserController
extends ControllerSupport {
    private final IThirdGjUserService thirdGjUserService;

    @GetMapping(value={"/getUser"})
    public ResponseData<ThirdGjUser> getUser() {
        ThirdGjUser userInfo = ShiroUtil.getUserInfo();
        ThirdGjUser data = new ThirdGjUser();
        data.setId(userInfo.getId());
        data.setFullname(userInfo.getFullname());
        data.setUsername(userInfo.getUsername());
        data.setGjUserLogId(userInfo.getGjUserLogId());
        data.setMobile(userInfo.getMobile());
        data.setPost(userInfo.getPost());
        data.setZlbUserId(userInfo.getZlbUserId());
        return ResponseData.success((Object)data);
    }

    @ApiEncrypt(request=true)
    @Log(title="\u4fee\u6539\u5bc6\u7801\uff08\u767b\u5f55\u540e\uff09", type=29)
    @PostMapping(value={"/modifyPassword"})
    public ResponseData<String> modifyPassword(@Validated @RequestBody ModifyPasswordParam param) {
        this.logger.info("\u670d\u52a1\u7ba1\u5bb6\u4fee\u6539\u5bc6\u7801\uff08\u767b\u5f55\u540e\uff09:username: {}", (Object)JwtUtil.getUsername());
        this.thirdGjUserService.modifyPassword(ShiroUtil.getLoginUserId(), param.getNewPassword());
        return ResponseData.success();
    }

    @ApiEncrypt(request=true)
    @Log(title="\u4fee\u6539\u5bc6\u7801\uff08by\u65e7\u5bc6\u7801\uff09", type=29)
    @PostMapping(value={"/modifyPasswordByOldPwd"})
    public ResponseData<String> modifyPasswordByOldPwd(@Validated @RequestBody ModifyPasswordByOldPwdParam param) {
        this.logger.info("\u670d\u52a1\u7ba1\u5bb6\u4fee\u6539\u5bc6\u7801\uff08by\u65e7\u5bc6\u7801\uff09:username: {}", (Object)JwtUtil.getUsername());
        this.thirdGjUserService.modifyPassword(ShiroUtil.getLoginUserId(), param.getOldPassword(), param.getNewPassword());
        return ResponseData.success();
    }

    @Generated
    public UserController(IThirdGjUserService thirdGjUserService) {
        this.thirdGjUserService = thirdGjUserService;
    }
}

