/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.controller.app;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.fwgj.bootstrap.security.ShiroUtil;
import cn.smarthse.fwgj.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.fwgj.entity.sys.ThirdGjUserLog;
import cn.smarthse.fwgj.entity.sys.ThirdOrganization;
import cn.smarthse.fwgj.enums.ThirdGjUserLogForbiddenStateEnum;
import cn.smarthse.fwgj.framework.Constant;
import cn.smarthse.fwgj.framework.RedisKey;
import cn.smarthse.fwgj.manage.IHomeManage;
import cn.smarthse.fwgj.model.vo.HomeData;
import cn.smarthse.fwgj.model.vo.admin.GjOrgListAdminVo;
import cn.smarthse.fwgj.service.sys.IThirdGjUserLogService;
import cn.smarthse.fwgj.service.sys.IThirdOrganizationService;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/m/home"})
@Validated
public class HomeController
extends ControllerSupport {
    private final IHomeManage homeService;
    private final IThirdGjUserLogService thirdGjUserLogService;
    private final IThirdOrganizationService thirdOrganizationService;
    private final RedisTemplate<String, ShiroPrincipal> redisTemplate;

    @GetMapping(value={"/getOrgList"})
    public ResponseData<List<GjOrgListAdminVo>> getOrgList() {
        Long gjUserId = ShiroUtil.getLoginUserId();
        return ResponseData.success(this.homeService.getOrgList(gjUserId));
    }

    @PostMapping(value={"/flushOrgId"})
    public ResponseData<String> flushOrgId(@NotNull Long orgId, @NotNull Long gjUserLogId, @NotNull String orgName) {
        ThirdGjUserLog gjUserLog = this.thirdGjUserLogService.getGjUserLog(gjUserLogId, orgId);
        if (gjUserLog == null || !ThirdGjUserLogForbiddenStateEnum.PASS.equals((Object)gjUserLog.getForbiddenState())) {
            ResponseData.fail((String)"\u60a8\u5728\u8be5\u673a\u6784\u4e0b\u7684\u7ba1\u5bb6\u8d26\u53f7\u88ab\u7981\u7528\u4e86\uff0c\u4e0d\u80fd\u5207\u6362\uff01");
        }
        ThirdOrganization thirdOrganization = (ThirdOrganization)this.thirdOrganizationService.getById(orgId);
        ShiroUtil.flushOrgId(orgId, gjUserLogId, orgName, thirdOrganization.getAreaId());
        this.redisTemplate.opsForValue().set((Object)RedisKey.getLoginUserKey(ShiroUtil.getLoginUserId()), (Object)ShiroUtil.getShiroPrincipal(), Constant.REDIS_PRINCIPAL_TIME.longValue(), TimeUnit.MINUTES);
        return ResponseData.success();
    }

    @GetMapping(value={"/getHomeData"})
    public ResponseData<HomeData> getHomeData() {
        HomeData result = this.homeService.getHomeData(ShiroUtil.getLoginOrgId());
        result.setName(ShiroUtil.getLoginUserNickname());
        result.setCurOrgName(ShiroUtil.getLoginOrgName());
        return ResponseData.success((Object)result);
    }

    @Generated
    public HomeController(IHomeManage homeService, IThirdGjUserLogService thirdGjUserLogService, IThirdOrganizationService thirdOrganizationService, RedisTemplate<String, ShiroPrincipal> redisTemplate) {
        this.homeService = homeService;
        this.thirdGjUserLogService = thirdGjUserLogService;
        this.thirdOrganizationService = thirdOrganizationService;
        this.redisTemplate = redisTemplate;
    }
}

