/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.controller.app;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.fwgj.bootstrap.security.ShiroUtil;
import cn.smarthse.fwgj.manage.IThirdGjManage;
import cn.smarthse.fwgj.model.param.ChangeAreaOrStatesParam;
import cn.smarthse.fwgj.model.param.ChangeCompanyParam;
import cn.smarthse.fwgj.model.param.ChangeLngAngLatParam;
import cn.smarthse.fwgj.model.param.CompanyListParam;
import cn.smarthse.fwgj.model.vo.CompanyDetailVo;
import cn.smarthse.fwgj.model.vo.CompanyInfoVo;
import cn.smarthse.fwgj.model.vo.CompanyListVo;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/m/company"})
@Validated
public class CompanyController
extends ControllerSupport {
    private final IThirdGjManage thirdGjManage;

    @GetMapping(value={"/listCompanyByOrgId"})
    public ResponseData<JqGridData<CompanyListVo>> listCompanyByOrgId(CompanyListParam param) throws ExecutionException, InterruptedException {
        param.setOrgId(ShiroUtil.getLoginOrgId());
        param.setBeginTime(new Date());
        return ResponseData.success(this.thirdGjManage.listCompanyByOrgId(param));
    }

    @GetMapping(value={"/getCompanyById"})
    public ResponseData<CompanyDetailVo> getCompanyById(Long id, Long customerId) {
        return ResponseData.success((Object)this.thirdGjManage.getCompanyById(id, customerId));
    }

    @GetMapping(value={"/getCompanyBeforeChange"})
    public ResponseData<CompanyInfoVo> getCompanyBeforeChange(Long id) {
        return ResponseData.success((Object)this.thirdGjManage.getCompanyBeforeChange(id));
    }

    @PostMapping(value={"/changeCompanyInfo"})
    public ResponseData<String> changeCompanyInfo(@RequestBody ChangeCompanyParam param) {
        return ResponseData.success((String)ResponseStateEnum.success.getName(), (Object)this.thirdGjManage.changeCompanyInfo(param));
    }

    @PostMapping(value={"/changeComAreaOrStates"})
    public ResponseData<String> changeComAreaOrStates(@RequestBody ChangeAreaOrStatesParam param) {
        param.setUserId(ShiroUtil.getLoginUserId());
        return ResponseData.success((String)ResponseStateEnum.success.getName(), (Object)this.thirdGjManage.changeComAreaOrStates(param));
    }

    @GetMapping(value={"/listCompanyForClose"})
    public ResponseData<JqGridData<CompanyListVo>> listCompanyForClose(CompanyListParam param) {
        param.setOrgId(ShiroUtil.getLoginOrgId());
        param.setBeginTime(new Date());
        return ResponseData.success(this.thirdGjManage.listCompanyForClose(param));
    }

    @PostMapping(value={"/changeLngAndLat"})
    public ResponseData<String> changeLngAndLat(@RequestBody ChangeLngAngLatParam param) {
        param.setOperateId(ShiroUtil.getLoginUserId());
        return ResponseData.success((String)ResponseStateEnum.success.getName(), (Object)this.thirdGjManage.changeLngAndLat(param));
    }

    @Generated
    public CompanyController(IThirdGjManage thirdGjManage) {
        this.thirdGjManage = thirdGjManage;
    }
}

