/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.controller.api;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.fwgj.manage.CommonManage;
import cn.smarthse.fwgj.model.vo.sys.AreaVo;
import cn.smarthse.fwgj.model.vo.sys.EconomyVo;
import cn.smarthse.fwgj.model.vo.sys.IndustryDetailVo;
import cn.smarthse.fwgj.model.vo.sys.IndustryVo;
import cn.smarthse.modules.health.enums.company.CompanySizeEnum;
import java.util.List;
import lombok.Generated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class CommonController {
    private final CommonManage commonManage;

    @GetMapping(value={"/area/getAreaList"})
    public ResponseData<List<AreaVo>> getAreaList(@RequestParam(defaultValue="0") Long pid) {
        return ResponseData.success(this.commonManage.getAreaList(pid));
    }

    @GetMapping(value={"/industry/getIndustryList"})
    public ResponseData<List<IndustryDetailVo>> getIndustryList(@RequestParam(defaultValue="2478") Long pid) {
        return ResponseData.success(this.commonManage.getIndustryList(pid));
    }

    @RequestLimit(maxCount=1, second=2, expression="#keyword")
    @GetMapping(value={"/industry/search"})
    public ResponseData<List<IndustryVo>> search(String keyword) {
        return ResponseData.success(this.commonManage.searchIndustryList4(keyword));
    }

    @GetMapping(value={"/scale/getScaleList"})
    public ResponseData<CompanySizeEnum[]> getScaleList() {
        return ResponseData.success((Object)CompanySizeEnum.values());
    }

    @GetMapping(value={"/economy/getEconomyList"})
    public ResponseData<List<EconomyVo>> getEconomyList() {
        return ResponseData.success(this.commonManage.getEconomyList());
    }

    @Generated
    public CommonController(CommonManage commonManage) {
        this.commonManage = commonManage;
    }
}

