package cn.smarthse.fwgj.provider.third;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.fwgj.model.param.company.CompanyCustomerSearchParam;
import cn.smarthse.fwgj.model.param.third.GjOrgCompanyQueryParam;
import cn.smarthse.fwgj.model.param.third.GjOrgCustomerAddParam;
import cn.smarthse.fwgj.model.vo.admin.GjOrgSignCompHistoryVo;
import cn.smarthse.fwgj.model.vo.third.*;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;

/**
 * 管家机构-企业签约相关 dubbo 接口
 *
 * @author chuhy
 * @date 2023/7/4
 */
public interface IThirdGjOrgCustomerProviderService {

    /**
     * 获取当前机构的服务检查统计信息
     * @param orgId 机构id，而不是管家机构id
     * @author chuhy
     */
    GjOrgCheckStatisticVo getGjOrjCheckStatistic(Long orgId);

    /**
     * 获取当前机构的服务范围(所有签约企业的区域及对应企业数量,用于侧边栏)- (废弃)
     * @param orgId 机构id，而不是管家机构id
     * @author chuhy
     */
    @Deprecated
    List<GjOrgCompanyAreaVo> getGjOrjCompanyAreaList(Long orgId);

    /**
     * 机构端 - 服务企业列表
     * @param param
     * @return {@link JqGridData< GjOrgCompanyListVo>}
     * @author chuhy
     * @date 2023/7/4 16:11
     */
    JqGridData<GjOrgCompanyListVo> getGjOrgCompanyList(GjOrgCompanyQueryParam param);


    /**
     * 获取当前机构下[服务企业统计信息]
     * @param customerId 企业签约id
     * @return {@link GjOrgCustomerStatisticVo}
     * @author chuhy
     * @date 2023/7/6 14:35
     */
    GjOrgCustomerStatisticVo getGjOrjCustomerStatistic(Long customerId);
    /**
     * 企业、机构签约详情
     * @param gjOrgCustomerId 签约id
     * @return {@link GjOrgCustomerVo}
     * @author liaoly
     * @date 2023/7/11 14:12
     */
    GjOrgCustomerVo getGjOrgCustomer(Long gjOrgCustomerId);
    /**
     * 机构、企业 最近一次的签约详情
     * @param orgId 机构id
     * @param cid 企业id
     * @return {@link GjOrgCustomerVo}
     * @author liaoly
     * @date 2023/9/28 13:47
     */
    GjOrgCustomerVo getLastGjOrgCustomer(Long orgId, Long cid);

    /**
     * 签约：机构-企业签约 添加
     * @param param
     * @return {@link Long} 返回 签约id
     * @author liaoly
     * @date 2023/7/11 16:18
     */
    Long addGjOrgCustomer(GjOrgCustomerAddParam param);

    /**
     * 签约：机构-企业签约 添加
     * @param param
     * @return {@link Long} 返回 签约id
     * @author liaoly
     * @date 2023/7/31 16:18
     */
    Long submitGjOrgCustomer(GjOrgCustomerAddParam param);

    /**
     * 解约提交 （state: 4-解约待审核）
     * @param gjOrgCustomerId  third_gj_org_customer.id
     * @param cancelReason 解约理由
     * @param orgName 机构名
     * @author liaoly
     * @date 2023/7/11 16:32
     */
    void cancelGjOrgCustomer(Long gjOrgCustomerId, String cancelReason, String orgName);

    /**
     * 校验gjOrgCustomerId、orgId是否匹配 （都匹配则机构端能操作、反之不能操作）
     * @param gjOrgCustomerId  third_gj_org_customer.id
     * @param orgId 机构id
     * @return {@link boolean} （都匹配则机构端能操作返回true、反之不能操作返回false）
     * @author liaoly
     * @date 2023/7/3 9:41
     */
    boolean checkPermission(Long gjOrgCustomerId, Long orgId);

    /**
     * 校验是否能和指定企业续约 能续约返回true，反之返回false (最新一个合同：合同期限剩余时间小于60天 && 不是解约审核状态)
     * @param cid 企业id
     * @param orgId 机构id
     * @return {@link boolean}
     * @author liaoly
     * @date 2023/10/7 9:03
     */
    boolean checkContinueGjOrgCustomer(Long cid, Long orgId);

    /**
     * 机构签约：查询可选签约的企业
     * @param orgId 机构id
     * @param keyword 匹配企业名称、企业信用代码
     * @return {@link List<GjOrgCustomerChooseCompanyVo>}
     * @author liaoly
     * @date 2023/7/14 10:38
     */
    List<GjOrgCustomerChooseCompanyVo> searchCompanyWithGjOrg(Long orgId, String keyword);


    /**
     * 查询当前机构与企业的历史签约记录
     * @param param orgId 机构id
     * @param param cid 企业id
     * @return {@link JqGridData<  GjOrgSignCompHistoryVo >}
     * @author chuhy
     * @date 2023/7/21 16:46
     */
    JqGridData<GjOrgSignCompHistoryVo> listCustomerHistoryForOrj(CompanyCustomerSearchParam param);

    /**
     * 定时任务 - 查找并更新，变更关于[是否在服务范围内状态]的签约企业
     *
     * @param cid 企业id，不为空则查找所有的企业
     * @author chuhy
     * @date 2023/7/10 17:00
     */
    void searchAndUpdateCustomerAboutRange(Long cid, LocalDate date);

    /**
     * 获取当前机构已签约的企业id和对应机构id列表
     * @param cidList
     * @return {@link Map<Long,Long>}
     * @author ShenZQ
     * @since 2023/12/5 15:55
     */
    Map<Long,Long> getSignedEnterpriseIdList(List<Long> cidList);

}
