package cn.smarthse.fwgj.provider.third;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgAuditLog;
import cn.smarthse.fwgj.model.param.third.GjCheckQueryParam;
import cn.smarthse.fwgj.model.param.third.GjOrgWarningCheckParam;
import cn.smarthse.fwgj.model.vo.check.CheckVo;
import cn.smarthse.fwgj.model.vo.third.*;
import cn.smarthse.modules.health.vo.work.reform.RiskReformGjListVo;
import cn.smarthse.modules.health.vo.work.reform.RiskReformGjSearch;

import java.util.Date;
import java.util.List;

/**
 *
 * 管家：巡查记录 dubbo接口
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2023/7/12 15:18
 */
public interface IThirdGjCheckProviderService {

    /**
     * 查询管家账号的 巡查记录 （分页）
     * @param param
     * @return {@link JqGridData<GjOrgListVo>}
     * @author liaoly
     * @date 2023/7/12 15:19
     */
    JqGridData<GjCheckListVo> getGjCheckListData(GjCheckQueryParam param);

    /**
     * 获取当前签约下的服务记录
     * @param cid
     * @return {@link List <  GjOrgCustomerStatisticVo >}
     * @author chuhy
     * @date 2023/7/13 8:58
     */
    List<CheckRecordVo> listCheckInfoForGjOrj(Long cid, Date beginTime, Date endTime);

    /**
     * 获取检查记录详情，汇总信息(统计信息、检查记录、检查项、风险告知)
     * tips:用于三端基本一样页面的接口，当前是提供机构端使用
     * @param checkInfoId
     * @return {@link CheckVo}
     * @author chuhy
     * @date 2023/7/14 16:49
     */
    CheckVo getCheckSummaryInfoForOrj(Long checkInfoId);

    /**
     * 管家风险列表（分页）
     * @param param 综合查询参数
     * @return {@link JqGridData<RiskReformGjListVo>}
     * @author liaoly
     * @date 2023/7/6 9:44
     */
    JqGridData<RiskReformGjListVo> getGjReformListData(RiskReformGjSearch param);

    /**
     * 机构-企业检查记录预警清单。
     * 展示本机构签约企业中，检查超期、检查预警的检查记录清单
     * @param param
     * @return {@link JqGridData< GjOrgCompanyListVo>}
     * @author chuhy
     * @date 2023/7/4 16:11
     */
    JqGridData<GjOrgWarningCheckVo> getGjOrgWarningCheckListForOrg(GjOrgWarningCheckParam param);

    /**
     * 监管 - 检查超期预警清单。
     * @param param
     * @return {@link JqGridData< GjOrgCompanyListVo>}
     * @author chuhy
     * @date 2023/7/4 16:11
     */
    JqGridData<GjOrgWarningCheckVo> listWarningCheckForSup(GjOrgWarningCheckParam param);

    /**
     * 补录完成清单
     * @param param
     * @return {@link JqGridData< GjOrgWarningCheckVo>}
     * @author chuhy
     * @date 2023/10/27 9:01
     */
    JqGridData<GjOrgWarningCheckVo> listSupplyCompletedForSup(GjOrgWarningCheckParam param);

    /**
     * 查询补录历史记录
     * @param param
     * @return {@link JqGridData<  ThirdGjOrgAuditLog >}
     * @author chuhy
     * @date 2023/10/26 9:39
     */
    JqGridData<ThirdGjOrgAuditLog> listSupplyHistory(GjOrgWarningCheckParam param);

    /**
     * 补录 - 补录申请清单
     * @author chuhy
     * @date 2023/10/26 10:25
     */
    JqGridData<GjOrgWarningCheckVo> listUnauditedSupplyForSup(GjOrgWarningCheckParam param);

    /**
     * 提交补录申请
     * @param param
     * @author chuhy
     * @date 2023/10/26 10:42
     */
    void submitSupply(GjOrgWarningCheckParam param);

    /**
     * 补录 - 审核
     * @param param
     * @author chuhy
     * @date 2023/10/26 10:42
     */
    void auditSupply(GjOrgWarningCheckParam param);
}
