
package cn.smarthse.fwgj.provider.supervise.thirdGjOrgAddCompanyList;


import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgCustomerLot;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgCustomerLotDetail;
import cn.smarthse.fwgj.model.param.admin.GjOrgAddCompListPageParam;
import cn.smarthse.fwgj.model.param.admin.GjOrgAddCompParam;
import cn.smarthse.fwgj.model.param.admin.SearchNoSignCompaniesListParam;
import cn.smarthse.fwgj.model.vo.admin.CompanyInfoVo;
import cn.smarthse.fwgj.model.vo.admin.GjOrgAddCompDetailVo;
import cn.smarthse.fwgj.model.vo.admin.GjOrgNoSignCompAreaStatisticsVo;

import java.util.List;

/**
 * 管家服务机构添加企业清单 接口类
 *
 * @author wuxq
 * @date 2023/6/29 09:34
 */
public interface IThirdGjOrgAddCompanyListServiceProvider {

    /**
     * 监管添加企业签约清单列表
     *
     * @param param 参数对象
     * @return JqGridData<ThirdGjOrgCustomerLot>
     * @author wuxq
     * @date 2023/6/30 9:49
     */
    JqGridData<ThirdGjOrgCustomerLot> getGjOrgAddCompListPageData(GjOrgAddCompListPageParam param);

    /**
     * 方法描述:  【监管端】查询区域内未签约服务管家的企业列表
     *
     * @param param 查询参数
     * @return List<CompanyInfoVo>
     * @author wuxq
     * @date 2023/7/10
     */
    JqGridData<CompanyInfoVo> getNoSignCompaniesList(SearchNoSignCompaniesListParam param);

    /**
     * 方法描述:  【监管端】管家机构添加企业清单详情
     *
     * @param lotId 批次id
     * @return GjOrgAddCompDetailVo
     * @author wuxq
     * @date 2023/7/11
     */
    GjOrgAddCompDetailVo getGjOrgAddCompDetailVo(Long lotId);

    /**
     * 方法描述:  按区域统计（侧面区域下拉筛选）
     *
     * @param areaId 当前区域
     * @param areaLevel       当前区域等级
     * @param loginAdminAreaLevel  监管账号区域等级
     * @return GjOrgNoSignCompAreaStatisticsVo
     * @author wuxq
     * @date 2023/7/11
     */
    List<GjOrgNoSignCompAreaStatisticsVo> getGjOrgNoSignCompAreaStatisticsVo(Long areaId, Integer areaLevel, Integer loginAdminAreaLevel);

    /**
     * 方法描述:  存草稿-添加企业签约清单
     *
     * @param   param 参数对象
     * @return  Long
     * @author  wuxq
     * @date    2023/7/7
     */
    Long saveDraft(GjOrgAddCompParam param);

    /**
     * 方法描述:  完成添加-添加企业签约清单
     *
     * @param   lotId 批次id
     * @param   loginUser 操作人
     * @return  List<ThirdGjOrgCustomerLotDetail> 被剔除的已签约清单
     * @author  wuxq
     * @date    2023/7/7
     */
    List<ThirdGjOrgCustomerLotDetail> saveList(Long lotId, String loginUser);

    /**
     * 方法描述: 根据lotId查询已添加企业 ThirdGjOrgCustomerLotDetail
     *
     * @param   param  查询参数
     * @return  JqGridData<ThirdGjOrgCustomerLotDetail>
     * @author  wuxq
     * @date    2023/7/14
     */
    JqGridData<ThirdGjOrgCustomerLotDetail> getSelectedLotDetailList(SearchNoSignCompaniesListParam param);

    /**
     * 方法描述:  查询机构添加企业批次详情
     *
     * @param   id ThirdGjOrgCustomerLot.id
     * @return  ThirdGjOrgCustomerLot
     * @author  wuxq
     * @date    2023/7/14
     */
    ThirdGjOrgCustomerLot getGjOrgCustomerLotData(Long id);

    /**
     * 方法描述:  移除勾选企业
     *
     * @param   id ThirdGjOrgCustomerLotDetail.id
     * @return  Integer
     * @author  wuxq
     * @date    2023/7/14
     */
    boolean removeComById(Long id);

    /**
     * 方法描述:  删除清单
     *
     * @param   id lotId
     * @param   loginUserId 操作账号id
     * @return  Boolean
     * @author  wuxq
     * @date    2023/7/25
     */
    Boolean del(Long id, Long loginUserId);
}
