
package cn.smarthse.fwgj.provider.supervise.thirdGjFilingAudit;


import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.fwgj.model.param.admin.GjFilingAuditListParam;
import cn.smarthse.fwgj.model.param.admin.GjFilingAuditParam;
import cn.smarthse.fwgj.model.vo.admin.GjFilingAuditStatisticsVo;
import cn.smarthse.fwgj.model.vo.admin.GjFilingAuditVo;
import cn.smarthse.fwgj.model.vo.admin.GjOrgFilingDetailVo;
import cn.smarthse.fwgj.model.vo.third.ThirdGjUserVo;

import java.util.List;

/**
 * 管家服务机构 接口类
 *
 * @author wuxq
 * @date 2023/6/29 09:34
 */
public interface IThirdGjOrgFilingAuditServiceProvider {

    /**
     * 方法描述:  机构备案审核列表（省市区）
     *
     * @param param 参数
     * @return PageInfo<GjFilingAuditStatisticsVo>
     * @author wuxq
     * @date 2023/6/29
     */
    List<GjFilingAuditStatisticsVo> fwgjFilingAuditStatisticsPageData(GjFilingAuditListParam param);

    /**
     * 方法描述:  机构备案审核列表（街道级）
     *
     * @param param 参数
     * @return PageInfo<GjFilingAuditStatisticsVo>
     * @author wuxq
     * @date 2023/6/29
     */
    JqGridData<GjFilingAuditVo> fwgjFilingAuditPageData(GjFilingAuditListParam param);

    /**
     * 查询管家备案 详情
     * @param gjOrgId 管家备案申请id
     * @return {@link GjOrgFilingDetailVo}
     * @author wuxq
     * @date 2023/6/30 17:28
     */
    GjOrgFilingDetailVo getGjOrgFilingDetailVo(Long gjOrgId);

    /**
     * 查询机构的管家账号列表
     * @param orgId 机构id
     * @param state ThirdGjUserLogStateEnums
     * @return {@link List < ThirdGjUserVo >}
     * @author wuxq
     * @date 2023/6/30 11:06
     */
    List<ThirdGjUserVo> getGjUserList(Long orgId, Integer state);

    /**
     * 方法描述:  审核操作
     *
     * @param   param 参数
     * @author  wuxq
     * @date    2023/6/30
     */
    void fwgjFilingAudit(GjFilingAuditParam param);
}
