package cn.smarthse.fwgj.provider.supervise.thirdGjCheck;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgCustomer;
import cn.smarthse.fwgj.model.vo.third.GjOrgListVo;

import java.util.List;

/**
 *
 * 管家巡查 dubbo接口 to 监管端
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2023/7/13 8:44
 */
public interface IThirdGjCheckProviderToSupervise {

    /**
     * 添加系统创建的巡查记录
     * @param customerList id 签约id
     * @param customerList signTime 签约开始时间
     * @param customerList expireTime 到期时间
     * @return {@link JqGridData<GjOrgListVo>}
     * @author liaoly
     * @date 2023/7/12 15:19
     */
    void addAutoCreateCheck(List<ThirdGjOrgCustomer> customerList);

    /**
     * 解约时，处理剩下的检查，进行逻辑删除
     * @param customerIdList 签约id
     * @author chuhy
     * @date 2023/7/26 16:33
     */
    void handleRemainingCheck(List<Long> customerIdList);

}
