package cn.smarthse.fwgj.provider.company;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgAuditLog;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgCustomer;
import cn.smarthse.fwgj.enums.ThirdGjOrgAuditLogTypeEnum;
import cn.smarthse.fwgj.model.param.GjOrgCustomerQueryParam;
import cn.smarthse.fwgj.model.param.company.CompanyCustomerSearchParam;
import cn.smarthse.fwgj.model.param.third.GjOrgCompanyQueryParam;
import cn.smarthse.fwgj.model.param.third.GjOrgCustomerAddParam;
import cn.smarthse.fwgj.model.vo.company.CompanyCustomerHistoryListVo;
import cn.smarthse.fwgj.model.vo.company.CompanyCustomerStatisticVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgCheckStatisticVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgCompanyAreaVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgCompanyListVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgCustomerVo;

import java.util.List;

/**
 * 管家机构-企业签约相关 dubbo 接口
 *
 * @author chuhy
 * @date 2023/7/4
 */
public interface IThirdGjOrgCustomerProviderToCompany {

    /**
     * 根据公司id，获取当前最新签约id
     * @param cid 公司id
     * @return {@link Long}
     * @author chuhy
     * @date 2023/7/18 19:19
     */
    Long getCurCustomerIdByCid(Long cid);

    /**
     * 获取当前机构的服务检查统计信息
     * @param orgId 机构id，而不是管家机构id
     * @author chuhy
     */
    GjOrgCheckStatisticVo getGjOrjCheckStatistic(Long orgId);

    /**
     * 获取当前机构的服务范围(所有签约企业的区域及对应企业数量,用于侧边栏)
     * @param orgId 机构id，而不是管家机构id
     * @author chuhy
     */
    List<GjOrgCompanyAreaVo> getGjOrjCompanyAreaList(Long orgId);

    /**
     * 机构端 - 服务企业列表
     * @param param
     * @return {@link JqGridData< GjOrgCompanyListVo>}
     * @author chuhy
     * @date 2023/7/4 16:11
     */
    JqGridData<GjOrgCompanyListVo> getGjOrgCompanyList(GjOrgCompanyQueryParam param);


    /**
     * 服务企业统计信息
     * @param customerId 企业签约id
     * @param cid 企业id
     * @return {@link CompanyCustomerStatisticVo}
     * @author chuhy
     * @date 2023/7/6 14:35
     */
    CompanyCustomerStatisticVo getCompanyCustomerStatistic(Long customerId, Long cid);
    /**
     * 企业解约消息
     * @param customerId 签约id
     * @author chuhy
     */
    String getCustomerUnsignMsg(Long customerId);
    /**
     * 企业、机构签约详情
     * @param gjOrgCustomerId 签约id
     * @param cid 企业id
     * @return {@link GjOrgCustomerVo}
     * @author liaoly
     * @date 2023/7/11 14:12
     */
    GjOrgCustomerVo getGjOrgCustomer(Long gjOrgCustomerId, Long cid);

    /**
     * 续约：机构-企业续约 添加
     * @param param
     * @return {@link Long} 返回 签约id
     * @author liaoly
     * @date 2023/7/11 16:18
     */
    Long addGjOrgCustomer(GjOrgCustomerAddParam param);

    /**
     * 解约提交 （state: 4-解约待审核）
     * @param gjOrgCustomerId  third_gj_org_customer.id
     * @param cancelReason 解约理由
     * @param companyName 企业名
     * @author liaoly
     * @date 2023/7/11 16:32
     */
    void cancelGjOrgCustomer(Long gjOrgCustomerId, String cancelReason, String companyName);

    /**
     * 校验gjOrgCustomerId、cid是否匹配 （都匹配则企业端能操作、反之不能操作）
     * @param gjOrgCustomerId  third_gj_org_customer.id
     * @param cid 企业id
     * @return {@link boolean} （都匹配则企业端能操作返回true、反之不能操作返回false）
     * @author liaoly
     * @date 2023/7/3 9:41
     */
    boolean checkPermission(Long gjOrgCustomerId, Long cid);

    /**
     * 管家申请的 审核记录
     * @param businessId 关联业务id（type：1-third_gj_org.id；2-third_gj_org_customer.id；3-third_gj_user_log.id）
     * @param type 记录类型：1-管家机构申请审核记录；2-管家机构签约企业审核记录；3-管家账号审核记录 ({@link ThirdGjOrgAuditLogTypeEnum})
     * @return {@link List< ThirdGjOrgAuditLog >}
     * @author liaoly
     * @date 2023/6/30 14:28
     */
    List<ThirdGjOrgAuditLog> getGjOrgAuditLogList(Long businessId, Integer type);
    /**
     * 企业签约列表 （分页）
     * @param param
     * @return {@link JqGridData<ThirdGjOrgCustomer> }
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2023/7/14 16:32
     */
    JqGridData<CompanyCustomerHistoryListVo> getGjOrgCustomerListData(GjOrgCustomerQueryParam param);

    /**
     * 企业、机构签约记录（辖区企业清单模块用）
     * @param param
     * @return
     */
    JqGridData<CompanyCustomerHistoryListVo> getSigningRecordsForOneUnit(GjOrgCustomerQueryParam param);

    /**
     * 企业，查看与当前机构的历史合同
     * @param param cid 企业id
     * @param param orgId 机构id
     * @return {@link JqGridData< CompanyCustomerHistoryListVo>}
     * @author chuhy
     * @date 2023/7/14 20:20
     */
    JqGridData<CompanyCustomerHistoryListVo> listCustomerHistoryForCompany(CompanyCustomerSearchParam param);

    /**
     * 机构、企业 最近一次的签约详情
     * @param orgId 机构id
     * @param cid 企业id
     * @return {@link GjOrgCustomerVo}
     * @author liaoly
     * @date 2023/9/28 13:47
     */
    GjOrgCustomerVo getLastGjOrgCustomer(Long orgId, Long cid);

    /**
     * 校验是否能和指定企业续约 能续约返回true，反之返回false (最新一个合同：合同期限剩余时间小于60天 && 不是解约审核状态)
     * @param cid 企业id
     * @param orgId 机构id
     * @return {@link boolean}
     * @author liaoly
     * @date 2023/10/7 9:03
     */
    boolean checkContinueGjOrgCustomer(Long cid, Long orgId);
}
