package cn.smarthse.fwgj.provider.company;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.fwgj.model.param.third.GjCheckQueryParam;
import cn.smarthse.fwgj.model.vo.check.CheckVo;
import cn.smarthse.fwgj.model.vo.check.ReformListVo;
import cn.smarthse.fwgj.model.vo.third.CheckRecordVo;
import cn.smarthse.fwgj.model.vo.third.GjCheckListVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgListVo;

import java.util.Date;
import java.util.List;

/**
 *
 * 管家巡查 dubbo接口 to 企业端
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2023/7/13 8:44
 */
public interface IThirdGjCheckProviderToCompany {

    /**
     * 查询管家账号的 巡查记录 （分页）
     * @param param
     * @return {@link JqGridData<GjOrgListVo>}
     * @author liaoly
     * @date 2023/7/12 15:19
     */
    JqGridData<GjCheckListVo> getGjCheckListData(GjCheckQueryParam param);

    /**
     * 获取当前公司的服务记录
     * @param cid 公司id
     * @return {@link List <  GjOrgCustomerStatisticVo >}
     * @author chuhy
     * @date 2023/7/13 8:58
     */
    JqGridData<CheckRecordVo> listCheckInfoForCompany(Long cid, Long customerId, Date startTime, Date endTime);

    /**
     * 获取检查记录详情，汇总信息(统计信息、检查记录、检查项、风险告知)
     * tips:用于三端基本一样页面的接口，当前是提供机构端使用
     * @param checkInfoId
     * @return {@link CheckVo}
     * @author chuhy
     * @date 2023/7/14 16:49
     */
    CheckVo getCheckSummaryInfoForCompany(Long checkInfoId);

    /**
     * 获取检查记录-风险告知
     * @param checkInfoId
     * @return {@link CheckVo}
     * @author chuhy
     * @date 2023/7/14 16:49
     */
    List<ReformListVo> getCheckReformList(Long checkInfoId);
}
