package cn.smarthse.fwgj.provider;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgAuditLog;
import cn.smarthse.fwgj.enums.ThirdGjOrgAuditLogTypeEnum;
import cn.smarthse.fwgj.model.param.GjOrgAuditLogQueryParam;

import java.util.List;

/**
 *
 * 管家 公共接口
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2023/7/13 15:23
 */
public interface IThirdGjCommonProvider {

    /**
     * 管家模块：操作记录
     * @param businessId 关联业务id（type：1-third_gj_org.id；2-third_gj_org_customer.id；3-third_gj_user_log.id）
     * @param type 记录类型：1-管家机构申请审核记录；2-管家机构签约企业审核记录；3-管家账号审核记录 ({@link ThirdGjOrgAuditLogTypeEnum})
     * @return {@link List<ThirdGjOrgAuditLog>}
     * @author liaoly
     * @date 2023/7/13 14:28
     */
    List<ThirdGjOrgAuditLog> getGjOrgAuditLogList(Long businessId, Integer type);
    /**
     * 管家模块：操作记录 (分页)
     * @param param
     * @return {@link JqGridData<ThirdGjOrgAuditLog>}
     * @author liaoly
     * @date 2023/7/13 14:28
     */
    JqGridData<ThirdGjOrgAuditLog> getGjOrgAuditLogListData(GjOrgAuditLogQueryParam param);
}
