package cn.smarthse.fwgj.model.vo.third;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class ThirdOrganizationVo implements Serializable {

    private Long id;

    /**
     * 机构名称
     */
    private String name;
    /**
     * 法定代表人
     */
    private String legalPerson;
    /**
     * 法定代表人联系电话
     */
    private String legalPersonPhone;

    /**
     * 联系人
     */
    private String contactName;
    /**
     * 联系人电话
     */
    private String contactPhone;

    private Long provinceId;

    private Long cityId;

    private Long areaId;

    private String provinceName;

    private String cityName;

    private String areaName;

    private String address;
    /**
     * 机构类型  1:检测评价机构 2:体检机构 4:诊断机构 6:培训机构 8:鉴定机构
     */
    private Integer orgType; //  （一个机构可能具有多个机构类型 用 orgTypes ）
    /**
     * 资质等级（检测评价机构才有该字段） 0：无， 1：甲， 2：乙， 3：丙
     */
    private Integer level;
    /**
     * 备案主管单位字典id
     */
    private Long recordManageUnitDicId;

    private Date createDate;

    private Long createBy;

    private Date updateDate;

    private Long updateBy;

    private Boolean isValid;

    private String creditCode; // 社会统一信用代码
    private Boolean canOutCheck; // 能否开展外出职业健康检查（体检机构）

    private String orgTypes; // 具有的机构类型，多个用逗号隔开

    /**
     *单位网址
     */
    private String unitWeb;
    /**
     * 主要负责人
     */
    private String principal;

    private String principalPhone;//主要负责人手机

    private String certificateNo; //资质证书编号

    private Integer technicistNum; //专业技术人员数

    private Integer highTechnicistNum; //高级职称人数

    private Integer middleTechnicistNum; //中级职称人数

    private String technologyPrincipal; //专业技术负责人

    private String technologyPrincipalTitle;//专业技术负责人技术职称

    private String technologyPrincipalQualificationNo; //专业技术负责人培训合格证证号

    private String qualityPrincipal; //质量控制负责人

    private String qualityPrincipalTitle; //质量控制负责人技术职称

    private String qualityPrincipalQualificationNo; //质量控制负责人培训合格证证号

    private Boolean testData; //是否是测试数据

    private Long cid = 0L; // 所属集团id(集团版该字段有效， 为0 表示 不是集团版)
    private Boolean isEnable = true; // 是否启用
    private Byte businessStatus;//营业状态 1:正常 2:暂停 3:关闭 （可能为空）

    private Date businessUpdateTime;//营业状态更新时间
    private Date deleteTime;//删除时间
    private Date importRecoverTime;//被删除的机构，导入时填充又被恢复的时间

    private Boolean hidden;// 是否隐藏

    private Boolean zjServiceOrg; //是否列为可提供服务的机构(诸暨市独有)

    private String deleteReason;//删除原因

    private String deleteReasonDesc;//删除原因描述

    /**
     * 企业id(将企业添加为托管机构时，该字段有效)
     */
    private Long trusteeshipCid;

    /**
     * 机构来源（1 万达仓; 2 体检; null 其他）
     */
    private Byte orgSource;
}