package cn.smarthse.fwgj.model.vo.third;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;


/**
 * 企业检查记录预警清单
 * @author chuhy
 * @since 2023-03-08 11:01
*/
@Data
public class GjOrgWarningCheckVo implements Serializable{
	private static final long serialVersionUID = -3109474664855777433L;


	/**
	 * 服务检查记录id
	 */
	//@ApiModelProperty="服务检查记录id")
	private Long id;

	/**
	 * 检查名称
	 */
	//@ApiModelProperty="检查名称")
	private String checkName;

	/**
	 * 单位名称
	 */
	//@ApiModelProperty="单位名称")
	private String unitName;

	/**
	 * 机构名称
	 */
	//@ApiModelProperty="机构名称")
	private String orgName;

	/**
	 * 检查状态(0-未开始；1-进行中(存草稿)；2-已完成；3-已终止；4-未完成)
	 */
	//@ApiModelProperty="检查状态(0-未开始；1-进行中(存草稿)；2-已完成；3-已终止；4-未完成)")
	private Integer checkStatus;


	/**
	 * 预警状态(0-无预警；1-检查预警；2-超期小于等于30天；3-超期大于30天)
	 */
	private Integer warningStatus;

	/**
	 * 补录状态(0-无需补录；1-可补录；2-不可补录；3-补录完成)
	 */
	private Integer supplyStatus;

	/**
	 * 申请补录状态（1-待审核；2-已通过；3-被退回；）
	 */
	private Byte applyState;

	/**
	 * 申请补录状态（1-待审核；2-已通过；3-被退回；）
	 */
	private Byte supplyAuditState;

	/**
	 * 对应周期开始时间
	 */
	//@ApiModelProperty="对应周期开始时间")
	private Date beginTime;

	/**
	 * 对应周期结束时间
	 */
	//@ApiModelProperty="对应周期结束时间")
	private Date endTime;

	private String reason;


}
