package cn.smarthse.fwgj.model.vo.third;

import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;


/**
 * 服务检查记录-服务检查项 - 新增参数
 * @author chuhy
 * @since 2023-03-08 11:01
*/
public @Data class CheckRecordVo implements Serializable{
	private static final long serialVersionUID = 227279401819413419L;


	/**
	 * 服务检查记录id
	 */
	//@ApiModelProperty="服务检查记录id")
	private Long id;

	/**
	 * 检查名称
	 */
	//@ApiModelProperty="检查名称")
	private String checkName;

	/**
	 * 检查年份
	 */
	//@ApiModelProperty="检查年份")
	private Integer year;

	/**
	 * 单位名称
	 */
	//@ApiModelProperty="单位名称")
	private String unitName;

	/**
	 * 机构名称
	 */
	//@ApiModelProperty="机构名称")
	private String orgName;

	/**
	 * 检查详情(风险数量统计)
	 */
	//@ApiModelProperty="检查详情(风险数量统计)")
	private ReformStasticsVo reformStasticsVo;

	/**
	 * 检查人
	 */
	//@ApiModelProperty="检查人")
	@Desensitization(type = DesensitizationType.NAME)
	private String checkPeople;

	/**
	 * 检查时间
	 */
	//@ApiModelProperty="检查时间")
	private Date checkTime;

	/**
	 * 检查状态(0-未开始；1-进行中(存草稿)；2-已完成；3-已终止；4-未完成)CheckStatusEnums
	 */
	//@ApiModelProperty="检查状态(0-未开始；1-进行中(存草稿)；2-已完成；3-已终止；4-未完成)")
	private Integer checkStatus;

	/**
	 * 服务完成类型(0-无；1-巡查打卡；2-监管认定)
	 */
	//@ApiModelProperty="服务完成类型(0-无；1-巡查打卡；2-监管认定)")
	private Integer doneType;

	/**
	 * 中止类型(1-企业暂停；2-企业关闭；3-区域变更)
	 */
	//@ApiModelProperty="中止类型(1-企业暂停；2-企业关闭；3-区域变更)")
	private Integer stopType;

	/**
	 * 预警状态(0-无预警；1-检查预警；2-超期小于等于30天；3-超期大于30天)
	 */
	//@ApiModelProperty="预警状态(0-无预警；1-检查预警；2-超期小于等于30天；3-超期大于30天)")
	private Integer warningStatus;

	/**
	 * 补录状态(0-无需补录；1-可补录；2-不可补录；3-补录中；4-补录完成)
	 */
	//@ApiModelProperty="补录状态(0-无需补录；1-可补录；2-不可补录；3-补录中；4-补录完成)")
	private Integer supplyStatus;

	/**
	 * 是否为系统自动创建(0-否；1-是)
	 */
	private Integer isAutoCreate;

	/**
	 * 重写中止类型get方法，因为移动端不需要展示详细的迁移类型，所以将31、32的类型转为3
	 * @author chuhy
	 * @date 2023/6/25 15:42
	 */
	public Integer getStopType() {
		if (stopType != null && (stopType == 31 || stopType == 32 || stopType == 33)){
			return 3;
		} else {
			return stopType;
		}
	}
}
