package cn.smarthse.fwgj.model.vo.admin;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import lombok.Data;

import java.io.Serializable;

/**
 * @Classname OrgGjListVo
 * @Description 监管-服务管家机构信息统计列表
 * @Date 2023/6/29 10:25
 * @Author chenliang
 */
@Data
public class OrgGjListAdminVo implements Serializable {
    private static final long serialVersionUID = -3686348616450647575L;
    //@ApiModelProperty("用户id")
    private Long id;
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    //@ApiModelProperty("姓名")
    private String fullname;
    //@ApiModelProperty("机构名称")
    private String orgName;
    //@ApiModelProperty("性别")
    private String sex;
    //@ApiModelProperty("年龄")
    private Integer age;
    //@ApiModelProperty("职称")
    private String post;
    @Desensitization(type = DesensitizationType.ID_CARD)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    //@ApiModelProperty("身份证")
    private String idcard;
    //@ApiModelProperty("文化程度")
    private String edu;
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    //@ApiModelProperty("联系方式")
    private String mobile;
    //@ApiModelProperty("服务企业总数")
    private Integer companyTotalNum;
    //@ApiModelProperty("本年度服务企业数")
    private Integer currentYearCompanyTotalNum;
    //@ApiModelProperty("本年度发现风险数")
    private Integer currentYearRiskNum;
}
