package cn.smarthse.fwgj.model.vo.admin;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Classname JurisdictionalUnitListAdminVo
 * @Description 监管-辖区服务清单-服务记录
 * @Date 2023/6/29 10:25
 * @Author chenliang
 */
@Data
public class OneUnitServiceRecordListAdminVo implements Serializable {

    private static final long serialVersionUID = 4118431926403456438L;

    //@ApiModelProperty("检查记录id")
    private Long checkInfoId;
    //@ApiModelProperty("检查名称")
    private String checkName;
    //@ApiModelProperty("服务机构名")
    private String serviceOrg;
    //@ApiModelProperty("服务管家名")
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String fullname;
    //@ApiModelProperty("服务时间")
    private Date checkTime;
    //@ApiModelProperty("服务状态(0-未开始；1-进行中(存草稿)；2-已完成；3-已终止)")
    private Integer checkStatus;
    //@ApiModelProperty("服务完成类型(0-无；1-巡查打卡；2-监管认定)")
    private Integer doneType;
    //@ApiModelProperty("服务中止类型(0-无；1-企业暂停；2-企业关闭；31-区域变更(跨地市迁移)； 32-区域变更(地市内迁移)；4-企业恢复(正常营业))")
    private Integer stopType;
    //@ApiModelProperty("预警状态(0-无预警；1-检查预警；2-超期小于等于30天；3-超期大于30天)")
    private Integer warningStatus;
    //@ApiModelProperty("补录状态(0-无需补录；1-可补录；2-不可补录；3-补录完成)")
    private Integer supplyStatus;
    //@ApiModelProperty("申请补录状态（1-待审核；2-已通过；3-被退回；）")
    private Integer supplyAuditState;
    //@ApiModelProperty("认定类型（1监管认定）")
    private Integer identificationType;
    //@ApiModelProperty("是否为系统自动创建(0-否；1-是)")
    private Integer isAutoCreate;
    //@ApiModelProperty("本次发现风险数")
    private Integer riskNum;
    //@ApiModelProperty("已整改风险数")
    private Integer rectifiedNum;
    //@ApiModelProperty("待整改风险数")
    private Integer toBeRectifiedNum;
    //@ApiModelProperty("待验收风险数")
    private Integer toBeAcceptedNum;

}
