package cn.smarthse.fwgj.model.vo.admin;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Classname JurisdictionalUnitListAdminVo
 * @Description 监管-辖区服务清单-单个企业统计
 * @Date 2023/6/29 10:25
 * @Author chenliang
 */
@Data
public class OnUnitServiceStatisticsAdminVo implements Serializable {

    private static final long serialVersionUID = 4118431926403456438L;

    //@ApiModelProperty("企业id")
    public Long cid;
    //@ApiModelProperty("企业名称")
    private String unitName;
    //@ApiModelProperty("监督单位名称")
    private String supervisionUnit;
    //@ApiModelProperty("职业卫生管理人员")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String occManagerName;
    //@ApiModelProperty("职业卫生管理人员联系方式")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String occManagerTel;
    //@ApiModelProperty("行政区划id")
    private Long areaId;
    //@ApiModelProperty("行政区划")
    private String areaAddress;
    //@ApiModelProperty("签约记录id")
    private Long customerId;
    //@ApiModelProperty("机构id")
    private Long orgId;
    //@ApiModelProperty("机构名称")
    private String orgName;
    //@ApiModelProperty("剩余天数")
    public Integer remainingSigningTime;
    //@ApiModelProperty("预警情况（0无超期预警 1有超期预警）")
    private Integer isInspectionOverdue;
    //@ApiModelProperty("上半周期服务")
    private Integer firstCheckStatus;
    //@ApiModelProperty("下半周期服务")
    private Integer secondCheckStatus;
    //@ApiModelProperty("累计服务次数")
    private Integer serviceNum;
    //@ApiModelProperty("待整改风险数")
    private Integer toBeRectifiedNum;
    //@ApiModelProperty("待验收风险数")
    private Integer toBeAcceptedNum;

    //@ApiModelProperty("下半周期合同开始时间")
    private Date secondHalfCycleStartTime;

}
