package cn.smarthse.fwgj.model.vo.admin;

import cn.smarthse.fwgj.enums.ThirdGjOrgCustomerStateEnum;
import cn.smarthse.fwgj.enums.ThirdGjOrgCustomerTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 服务管家机构七月企业历史记录 VO类
 *
 * @author wuxq
 * @date 2023/6/29 09:34
 */
@Data
public class GjOrgSignCompHistoryVo implements Serializable {

    private static final long serialVersionUID = -1L;

    //@ApiModelProperty = "签约id")
    private Long gjOrgCustomerId;

    //@ApiModelProperty = "机构id")
    private Long orgId;

    //@ApiModelProperty = "企业id")
    private Long cid;

    //@ApiModelProperty = "企业名")
    private String unitName;

    //@ApiModelProperty = "合同开始时间")
    private Date signTime;
    //@ApiModelProperty = "合同结束时间")
    private Date expireTime;

    //@ApiModelProperty = "签约 时间")
    private Date signDate;
    //@ApiModelProperty = "解约 时间")
    private Date cancelDate;

    //@ApiModelProperty = "合同类型（1-签约；2-续约）")
    private Integer type;

    //@ApiModelProperty = "状态（1-签约待审核；2-已签约(签约中)；3-签约被退回；4-解约待审核；5-已解约(未签约)；6-解约被退回）")
    private Integer state;

    public String getTypeName() {

        return ThirdGjOrgCustomerTypeEnum.getName(type);
    }

    public String getStateName() {
        return ThirdGjOrgCustomerStateEnum.getName(state);
    }
}
