package cn.smarthse.fwgj.model.vo.admin;

import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrg;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

/**
 * 服务管家服务综合统计 VO类
 *
 * @author wuxq
 * @date 2023/6/29 09:34
 */
@Accessors(chain = true)
@Data
public class GjOrgServiceStatisticsVo implements Serializable {

    private static final long serialVersionUID = -1L;

    //@ApiModelProperty = "机构id")
    private Long orgId;

    //@ApiModelProperty = "机构名")
    private String orgName;

    //@ApiModelProperty = "服务范围")
    private String serviceAreas;

    //@ApiModelProperty = "服务管家人数")
    private Integer orgUserNum;

    //@ApiModelProperty = "服务企业总数")
    private Integer signComNum;

    //@ApiModelProperty = "需服务 企业数")
    private Integer servicedComNum;

    //@ApiModelProperty = "合约即将到期企业数")
    private Integer nearDueNum;

    //@ApiModelProperty = "入库时间")
    private Date storageTime;

    //@ApiModelProperty = "当前备案（市本级、区级有）")
    private ThirdGjOrg currGjOrg;

    //@ApiModelProperty = "管家机构当前备案列表")
    private List<ThirdGjOrg> gjOrgList;

    public Date getStorageTime() {
        if (!CollectionUtils.isEmpty(this.gjOrgList)) {
            ThirdGjOrg thirdGjOrg = this.gjOrgList.stream().min(Comparator.comparing(ThirdGjOrg::getAuditTime)).orElse(null);
            if (thirdGjOrg.getAuditTime() != null) {
                return thirdGjOrg.getAuditTime();
            }
        }
        return storageTime;
    }
}
