package cn.smarthse.fwgj.model.vo.admin;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import lombok.Data;

import java.io.Serializable;

/**
 * 机构：管家备案详情vo
 *
 * @author wuxq
 * @date 2023/6/29 17:05
 */
@Data
public class GjOrgFilingDetailVo implements Serializable {

    private static final long serialVersionUID = 6276305049881753623L;

    /**
     * 管家备案id
     */
    private Long id;

    /**
     * 管家备案状态
     */
    private Integer state;

    /**
     * 机构id
     */
    private Long orgId;
    /**
     * 机构名称
     */
    private String orgName;
    /**
     * 机构社会统一信用代码
     */
    private String orgCreditCode;
    /**
     * 联系人
     */
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String contactName;
    /**
     * 联系电话
     */
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String contactPhone;
    /**
     * 法人
     */
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String legalPerson;
    /**
     * 法人联系电话
     */
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String legalPersonPhone;
    /**
     * 工作场所地址
     */
    private String workAddress;

    /**
     * 申请书附件
     */
    private String applyFile;
    /**
     * 承诺书附件
     */
    private String commitmentFile;
    /**
     * 营业执照附件
     */
    private String busLicenseFile;
}
