package cn.smarthse.fwgj.model.vo.admin;

import cn.hutool.core.date.DateUtil;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 服务管家机构备案申请审核统计对象（省市区级） VO类
 *
 * @author wuxq
 * @date 2023/6/29 09:34
 */
@Data
public class GjFilingAuditStatisticsVo implements Serializable {

    private static final long serialVersionUID = -1L;

    //@ApiModelProperty = "区域id")
    private Long areaId;

    //@ApiModelProperty = "区域名称")
    private String areaName;

    //@ApiModelProperty = "区域等级")
    private Integer areaLevel;

    //@ApiModelProperty = "当前监管账号区域等级")
    private Integer loginAdminAreaLevel;

    //@ApiModelProperty = "新增审核数")
    private String pendingAuditNum;

    //@ApiModelProperty = "服务管家机构数")
    private String gjOrgNum;

    //@ApiModelProperty = "更新时间")
    private Date updateTime;

    //@ApiModelProperty = "更新时间")
    private String updateTimeStr;

    public String getUpdateTimeStr() {
        if (updateTime != null) {
            return DateUtil.format(updateTime, "yyyy-MM-dd HH:mm:ss");
        }
        return "-";
    }
}
