package cn.smarthse.fwgj.model.vo;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.enums.reform.ReformAcceptanceRecordStatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;


/**
 *
 * 移动端：风险整改详情vo
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2023/3/8 11:05
 */
@Data
public class ReformRecordDetailVo implements Serializable {

    private static final long serialVersionUID = -1986975018306621730L;

//@ApiModelProperty("风险整改记录id")
    private Long reformRecordId;

//@ApiModelProperty("状态(草稿-0; 待审核-1; 无需整改-2; 完成-3 ReformAcceptanceRecordStatusEnum)")
    private Integer status;

//@ApiModelProperty("整改负责人")
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String reformDirectorName;

//@ApiModelProperty("整改协作人")
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String reformCollaboratorName;

//@ApiModelProperty("整改期限")
    private LocalDate requireFinishTime;

//@ApiModelProperty("实际完成时间")
    private LocalDate actualFinishTime;

//@ApiModelProperty("整改佐证材料ids")
    private String reformFinishedFiles;

//@ApiModelProperty("整改佐证材料")
    private List<SysFileModel> reformFinishedFileList;

//@ApiModelProperty("整改措施")
    private String reformMeasure;

//@ApiModelProperty("验收负责人")
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String acceptanceDirectorName;

//@ApiModelProperty("验收时间")
    private LocalDate acceptanceDate;

//@ApiModelProperty("验收佐证材料ids")
    private String acceptanceFiles;

//@ApiModelProperty("验收佐证材料")
    private List<SysFileModel> acceptanceFileList;

//@ApiModelProperty("不通过说明")
    private String situationDescription;

//@ApiModelProperty("验收结论（1-通过；0-不通过 AcceptanceResultEnum）")
    private Integer acceptanceResult;

//@ApiModelProperty("创建时间")
    private Date createDate;

//@ApiModelProperty("处理措施")
    private Integer dealMeasure;

//@ApiModelProperty("自定义处理措施名称")
    private String dealMeasureName;

//@ApiModelProperty("诊断/体检机构id")
    private Long thirdOrgId;

//@ApiModelProperty("诊断/体检机构名称")
    private String  thirdOrgName;

//@ApiModelProperty("诊断、体检时间开始")
    private Date  dealTimeBegin;

    public String getStatusStr() {
        //状态(草稿-0; 待审核-1; 无需整改-2; 完成-3)
        return ReformAcceptanceRecordStatusEnum.getNameByValue(status.byteValue());
    }
}
