package cn.smarthse.fwgj.model.vo;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.modules.health.enums.reform.ReformSourceLiteEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;


/**
 *
 * 风险来源
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2023/9/5 13:31
 */
@Data
public class ReformItemSource implements Serializable {

    private static final long serialVersionUID = 5735182087545622368L;

//@ApiModelProperty("风险id")
    private Long reformId;

//@ApiModelProperty("风险来源(乡镇协管-7 关键因素画像-8 ReformSourceLiteEnum)")
    private Byte reformItemSource;

//@ApiModelProperty("风险来源名称")
    private Integer reformItemSourceName;

//@ApiModelProperty("风险批次")
    private Integer batchNum;

//@ApiModelProperty("风险批次")
    private Integer batchNumDb;

    //------------------------
//@ApiModelProperty("风险id(basic.id)")
    private Long basicId;

//@ApiModelProperty("单位id")
    private Long cid;

//@ApiModelProperty("风险名/对应工作")
    private String reformName;

//@ApiModelProperty("风险发现人")
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String finderName;

//@ApiModelProperty("发现时间")
    private Date findTime;

//@ApiModelProperty("创建时间")
    private Date createDate;

//@ApiModelProperty("风险来源id")
    private Long reformItemSourceId;

//@ApiModelProperty("风险等级（一般事故隐患现场立即整改-1; 一般事故隐患限期整改-2; 重大事故隐患停产停业整顿-3 ReformItemLevelEnum）")
    private Integer reformItemLevel;

//@ApiModelProperty("隐患分类(管理类-1; 从业人员类-2; 设备设施及物料类-3; 场所环境类-4 ReformItemTypeEnum)")
    private Integer reformItemType;

//@ApiModelProperty("风险描述")
    private String description;

//@ApiModelProperty("生成来源(巡查包括10, 12, 13, 14, 15, 16, 17, 18) ReformGenerationSourceEnum")
    private Integer generationSource;

//@ApiModelProperty("状态(草稿-0; 待整改-1; 待验收-2; 已完成-3; 无需整改-4; 退回-5; 监管忽略-6（已废弃）)")
    private Byte status;

    public String getReformItemSourceName() {

        return reformId == null ? null : ReformSourceLiteEnum.getSourceNameByValue(reformItemSource.byteValue());
    }
}
